/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.base.CharMatcher;
import java.util.Optional;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Cursor;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.PotentialEmphasisDelimiter;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.SourceSpan;

public class PotentialEmphasisSpan
extends SourceSpan {
    @Override
    public Optional<? extends Inline> createInline(Cursor cursor) {
        char c = cursor.getChar();
        if (!(c != '_' && c != '*' || this.currentPositionIsEscaped(cursor))) {
            int length = this.lengthMatching(cursor, c);
            boolean leftFlanking = this.isLeftFlanking(cursor, length);
            boolean rightFlanking = this.isRightFlanking(cursor, length);
            boolean canOpen = leftFlanking;
            boolean canClose = rightFlanking;
            if (c == '_') {
                canOpen = leftFlanking && (!rightFlanking || this.isPunctuation(this.charBefore(cursor)));
                canClose = rightFlanking && (!leftFlanking || this.isPunctuation(this.charAfter(cursor, length)));
            }
            return Optional.of(new PotentialEmphasisDelimiter(cursor.getLineAtOffset(), cursor.getOffset(), length, cursor.getTextAtOffset(length), canOpen, canClose));
        }
        return Optional.empty();
    }

    boolean isLeftFlanking(Cursor cursor, int length) {
        char charBefore = this.charBefore(cursor);
        char charAfter = this.charAfter(cursor, length);
        return !this.isWhitespace(charAfter) && (!this.isPunctuation(charAfter) || this.isWhitespace(charBefore) || this.isPunctuation(charBefore));
    }

    private char charAfter(Cursor cursor, int length) {
        return cursor.hasNext(length) ? cursor.getNext(length) : (char)'\n';
    }

    private char charBefore(Cursor cursor) {
        return cursor.hasPrevious() ? (char)cursor.getPrevious() : (char)'\n';
    }

    boolean isRightFlanking(Cursor cursor, int length) {
        char charBefore = this.charBefore(cursor);
        char charAfter = this.charAfter(cursor, length);
        return !this.isWhitespace(charBefore) && (!this.isPunctuation(charBefore) || this.isWhitespace(charAfter) || this.isPunctuation(charAfter));
    }

    private boolean isWhitespace(char c) {
        return CharMatcher.whitespace().matches(c);
    }

    private boolean isPunctuation(char c) {
        String punctuation = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`,{|}~";
        return punctuation.indexOf(c) >= 0;
    }

    private boolean currentPositionIsEscaped(Cursor cursor) {
        int backslashCount = 0;
        int x = 1;
        while (cursor.hasPrevious(x) && cursor.getPrevious(x) == '\\') {
            ++backslashCount;
            ++x;
        }
        return backslashCount % 2 == 1;
    }

    private int lengthMatching(Cursor cursor, char c) {
        int x = 1;
        while (cursor.hasNext(x) && cursor.getNext(x) == c) {
            ++x;
        }
        return x;
    }

    static boolean isLetterOrDigit(char previous) {
        return previous >= '0' && previous <= '9' || previous >= 'A' && previous <= 'Z' || previous >= 'a' && previous <= 'z';
    }
}

