/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.block;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.asciidoc.internal.AsciiDocContentState;
import org.eclipse.mylyn.wikitext.asciidoc.internal.util.ReadAheadDispatcher;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.ListAttributes;
import org.eclipse.mylyn.wikitext.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class ListBlock
extends Block {
    private static final String PARAM_NAME_START = "start";
    private static final String PARAM_NAME_STYLE = "style";
    private static final String ANY_CHAR = "\\s+(.*+)";
    private static final List<String> TYPE_ORDER = ImmutableList.of((Object)"arabic", (Object)"loweralpha", (Object)"lowerroman", (Object)"upperalpha", (Object)"upperroman");
    private static final List<String> TYPE_LISTSPEC = ImmutableList.of((Object)"1.", (Object)"a.", (Object)"i)", (Object)"A.", (Object)"I)");
    private static final List<String> TYPE_CSS_STYLE = ImmutableList.of((Object)"decimal", (Object)"lower-alpha", (Object)"lower-roman", (Object)"upper-alpha", (Object)"upper-roman");
    private static final Pattern startPattern = Pattern.compile("\\s*((?:(?:\\*)|(?:\\.)){1,5}+|-|[a-zA-Z0-9]+\\.|[IVXLCDM]+\\)|[ivxlcdm]+\\))\\s+(.*+)");
    private static final Pattern leadingBlankPattern = Pattern.compile("^\\s+");
    private int blockLineCount = 0;
    private Matcher matcher;
    private Stack<ListState> listState;
    private boolean blankSeparator;
    private boolean listContinuation;
    private boolean nestingBegin;
    private boolean nestedBlockInterruptible;

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        this.listState = null;
        return this.correspondsToListLine(line, lineOffset);
    }

    private boolean correspondsToListLine(String line, int lineOffset) {
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    protected int processLineContent(String line, int offset) {
        boolean closeItem = true;
        if (this.blockLineCount == 0) {
            this.listState = new Stack();
            ListAttributes attributes = new ListAttributes();
            String listSpec = this.normalizeListSpec(this.matcher.group(1));
            DocumentBuilder.BlockType type = this.calculateType(listSpec);
            if (type == DocumentBuilder.BlockType.NUMERIC_LIST) {
                ArrayList<String> positionalParameters = new ArrayList<String>();
                positionalParameters.add(PARAM_NAME_STYLE);
                Map<String, String> lastProperties = this.getAsciiDocState().getLastProperties(positionalParameters);
                this.getAsciiDocState().setLastPropertiesText("");
                String startProperty = lastProperties.get(PARAM_NAME_START);
                if (startProperty != null) {
                    attributes.setStart(startProperty);
                }
                String styleProperty = lastProperties.get(PARAM_NAME_STYLE);
                this.updateStyleAttribute(attributes, listSpec, styleProperty);
            }
            offset = this.matcher.start(2);
            this.listState.push(new ListState(listSpec, 1, type));
            this.builder.beginBlock(type, (Attributes)attributes);
            this.adjustLevel(this.matcher, type, listSpec);
        } else {
            if (line.isEmpty()) {
                if (!this.listContinuation) {
                    this.blankSeparator = true;
                }
                return -1;
            }
            if (this.isListContinuation(line)) {
                this.blankSeparator = false;
                this.listContinuation = true;
                closeItem = false;
                return -1;
            }
            Matcher matcher = startPattern.matcher(line);
            if (!matcher.matches()) {
                if (this.blankSeparator) {
                    this.setClosed(true);
                    this.blankSeparator = false;
                    return 0;
                }
                closeItem = false;
                Matcher leadingBlankMatcher = leadingBlankPattern.matcher(line);
                if (leadingBlankMatcher.find()) {
                    offset = leadingBlankMatcher.end();
                }
                this.markupLanguage.emitMarkupText(this.getParser(), this.state, " ");
            } else {
                String listSpec = this.normalizeListSpec(matcher.group(1));
                DocumentBuilder.BlockType type = this.calculateType(listSpec);
                offset = matcher.start(2);
                this.adjustLevel(matcher, type, listSpec);
            }
            this.blankSeparator = false;
            this.listContinuation = false;
        }
        ++this.blockLineCount;
        ListState listState = this.listState.peek();
        if (closeItem) {
            if (listState.openItem) {
                this.builder.endBlock();
            }
            listState.openItem = true;
            this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        }
        this.markupLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    private void updateStyleAttribute(ListAttributes attributes, String listSpec, String styleProperty) {
        int listTypeIndex = TYPE_ORDER.indexOf(styleProperty);
        if (listTypeIndex < 0) {
            listTypeIndex = TYPE_LISTSPEC.indexOf(listSpec);
        }
        if (listTypeIndex < 0) {
            int level = 0;
            for (ListState ls : this.listState) {
                if (ls.type != DocumentBuilder.BlockType.NUMERIC_LIST) continue;
                ++level;
            }
            listTypeIndex = level % TYPE_ORDER.size();
        }
        attributes.appendCssStyle("list-style-type:" + TYPE_CSS_STYLE.get(listTypeIndex) + ";");
    }

    private String normalizeListSpec(String group) {
        if (group.matches("[a-z]+\\.")) {
            group = "a.";
        } else if (group.matches("[A-Z]+\\.")) {
            group = "A.";
        } else if (group.matches("[IVXLCDM]+\\)")) {
            group = "I)";
        } else if (group.matches("[ivxlcdm]+\\)")) {
            group = "i)";
        } else if (group.matches("[0-9]+\\.")) {
            group = "1.";
        }
        return group;
    }

    private AsciiDocContentState getAsciiDocState() {
        return (AsciiDocContentState)this.getState();
    }

    private boolean isListContinuation(String line) {
        return "+".equals(line);
    }

    private DocumentBuilder.BlockType calculateType(String listSpec) {
        return switch (listSpec.charAt(listSpec.length() - 1)) {
            case ')', '.' -> DocumentBuilder.BlockType.NUMERIC_LIST;
            default -> DocumentBuilder.BlockType.BULLETED_LIST;
        };
    }

    private void adjustLevel(Matcher matcher, DocumentBuilder.BlockType type, String tag) {
        int level = this.listState.size() + 1;
        for (ListState ls : this.listState) {
            if (!ls.tag.equals(tag)) continue;
            level = ls.level;
        }
        ListState prevState = this.listState.peek();
        while (level != prevState.level || prevState.type != type) {
            if (level > prevState.level) {
                if (!prevState.openItem) {
                    this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
                    prevState.openItem = true;
                }
                attributes = new ListAttributes();
                if (type == DocumentBuilder.BlockType.NUMERIC_LIST) {
                    this.updateStyleAttribute(attributes, tag, null);
                }
                this.listState.push(new ListState(tag, prevState.level + 1, type));
                this.builder.beginBlock(type, (Attributes)attributes);
            } else {
                this.closeOne();
                if (this.listState.isEmpty()) {
                    attributes = new ListAttributes();
                    this.listState.push(new ListState(tag, 1, type));
                    this.builder.beginBlock(type, (Attributes)attributes);
                }
            }
            prevState = this.listState.peek();
        }
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            while (this.listState != null && !this.listState.isEmpty()) {
                this.closeOne();
            }
            this.listState = null;
        }
        super.setClosed(closed);
    }

    private void closeOne() {
        ListState e = this.listState.pop();
        if (e.openItem) {
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    public boolean beginNesting() {
        this.nestingBegin = this.listContinuation;
        return this.nestingBegin;
    }

    public int findCloseOffset(String line, int lineOffset) {
        if (this.listContinuation) {
            if (this.nestingBegin) {
                AbstractMarkupLanguage language = (AbstractMarkupLanguage)this.getParser().getMarkupLanguage();
                Block block = language.startBlock(line, lineOffset);
                this.nestedBlockInterruptible = this.isInterruptibleNestedBlock(block);
                this.nestingBegin = false;
            }
            if (this.nestedBlockInterruptible && (line.isEmpty() || this.isListContinuation(line))) {
                this.listContinuation = this.isListContinuation(line);
                return 0;
            }
        }
        return -1;
    }

    private boolean isInterruptibleNestedBlock(Block block) {
        return block == null || block instanceof ReadAheadDispatcher;
    }

    public boolean canResume(String line, int lineOffset) {
        boolean resume;
        boolean bl = resume = this.listContinuation && (this.correspondsToListLine(line, lineOffset) || line.isEmpty() || this.isListContinuation(line));
        if (resume) {
            this.listContinuation = false;
            this.nestingBegin = false;
        }
        return resume;
    }

    private static class ListState {
        int level;
        String tag;
        DocumentBuilder.BlockType type;
        boolean openItem;

        private ListState(String tag, int level, DocumentBuilder.BlockType type) {
            this.tag = tag;
            this.level = level;
            this.type = type;
        }
    }
}

