/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public final class TaskHyperlinkPresenter
extends MultipleHyperlinkPresenter {
    private IRegion activeRegion;
    private ITask currentTask;
    private TaskHyperlink currentTaskHyperlink;
    private ITextViewer textViewer;
    private String oldToolTip;
    private boolean restoreToolTip;
    private final MultipleHyperlinkPresenter delegate;
    private boolean errorLogged;

    public TaskHyperlinkPresenter(IPreferenceStore store) {
        super(store);
        this.delegate = new MultipleHyperlinkPresenter(store);
    }

    public TaskHyperlinkPresenter(RGB color) {
        super(color);
        this.delegate = new MultipleHyperlinkPresenter(color);
    }

    public void install(ITextViewer textViewer) {
        this.textViewer = textViewer;
        this.delegate.install(textViewer);
    }

    public void uninstall() {
        this.hideHyperlinks();
        this.textViewer = null;
        this.delegate.uninstall();
    }

    public void applyTextPresentation(TextPresentation textPresentation) {
        this.delegate.applyTextPresentation(textPresentation);
        if (this.activeRegion != null && this.currentTask != null && this.currentTask.isCompleted()) {
            Iterator styleRangeIterator = textPresentation.getAllStyleRangeIterator();
            while (styleRangeIterator.hasNext()) {
                StyleRange styleRange = (StyleRange)styleRangeIterator.next();
                if (this.activeRegion.getOffset() != styleRange.start || this.activeRegion.getLength() != styleRange.length) continue;
                styleRange.strikeout = true;
                break;
            }
        }
    }

    public void showHyperlinks(IHyperlink[] hyperlinks) {
        this.showHyperlinks(hyperlinks, false);
    }

    /*
     * WARNING - void declaration
     */
    public void showHyperlinks(IHyperlink[] hyperlinks, boolean takesFocusWhenVisible) {
        block11: {
            IHyperlink iHyperlink;
            this.activeRegion = null;
            if (hyperlinks.length == 1 && (iHyperlink = hyperlinks[0]) instanceof TaskHyperlink) {
                void hyperlink;
                TaskHyperlink taskHyperlink = (TaskHyperlink)iHyperlink;
                TaskHyperlink cfr_ignored_0 = (TaskHyperlink)iHyperlink;
                TaskList taskList = TasksUiPlugin.getTaskList();
                String repositoryUrl = hyperlink.getRepository().getRepositoryUrl();
                ITask task = taskList.getTask(repositoryUrl, hyperlink.getTaskId());
                if (task == null) {
                    task = taskList.getTaskByKey(repositoryUrl, hyperlink.getTaskId());
                }
                if (!hyperlinks[0].equals(this.currentTaskHyperlink)) {
                    this.currentTaskHyperlink = (TaskHyperlink)hyperlinks[0];
                    this.currentTask = task;
                    this.activeRegion = hyperlink.getHyperlinkRegion();
                    if (this.textViewer != null && this.textViewer.getTextWidget() != null && !this.textViewer.getTextWidget().isDisposed()) {
                        this.oldToolTip = this.textViewer.getTextWidget().getToolTipText();
                        this.restoreToolTip = true;
                        if (task == null) {
                            Object taskLabel = TasksUiInternal.getTaskPrefix(hyperlink.getRepository().getConnectorKind());
                            taskLabel = (String)taskLabel + this.currentTaskHyperlink.getTaskId();
                            this.textViewer.getTextWidget().setToolTipText(NLS.bind((String)Messages.TaskHyperlinkPresenter_Not_In_Task_List, (Object)taskLabel));
                        } else if (task.getTaskKey() == null) {
                            this.textViewer.getTextWidget().setToolTipText(task.getSummary());
                        } else {
                            this.textViewer.getTextWidget().setToolTipText(task.getTaskKey() + ": " + task.getSummary());
                        }
                    }
                }
            }
            try {
                Method method = MultipleHyperlinkPresenter.class.getDeclaredMethod("showHyperlinks", IHyperlink[].class, Boolean.TYPE);
                method.invoke((Object)this.delegate, hyperlinks, takesFocusWhenVisible);
            }
            catch (NoSuchMethodException e) {
                this.delegate.showHyperlinks(hyperlinks);
            }
            catch (Exception e) {
                if (this.errorLogged) break block11;
                this.errorLogged = true;
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unexpected error while displaying hyperlink", (Throwable)e));
            }
        }
    }

    public void hideHyperlinks() {
        if (this.currentTaskHyperlink != null) {
            if (this.restoreToolTip && this.textViewer != null && this.textViewer.getTextWidget() != null && !this.textViewer.getTextWidget().isDisposed()) {
                this.textViewer.getTextWidget().setToolTipText(this.oldToolTip);
                this.restoreToolTip = false;
            }
            this.currentTaskHyperlink = null;
            this.currentTask = null;
        }
        this.delegate.hideHyperlinks();
    }

    public boolean canHideHyperlinks() {
        return this.delegate.canHideHyperlinks();
    }

    public boolean canShowMultipleHyperlinks() {
        return this.delegate.canShowMultipleHyperlinks();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.delegate.documentAboutToBeChanged(event);
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        this.delegate.inputDocumentAboutToBeChanged(oldInput, newInput);
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        this.delegate.inputDocumentChanged(oldInput, newInput);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.delegate.propertyChange(event);
    }

    public void setColor(Color color) {
        this.delegate.setColor(color);
    }
}

