/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.commons.workbench.AdaptiveRefreshPolicy;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListInterestFilter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListInterestSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskScheduleContentProvider;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class FocusTaskListAction
implements AdaptiveRefreshPolicy.IFilteredTreeListener,
IViewActionDelegate,
IActionDelegate2 {
    private Set<AbstractTaskListFilter> previousFilters = new HashSet<AbstractTaskListFilter>();
    private ViewerSorter previousSorter;
    private final TaskListInterestFilter taskListInterestFilter = new TaskListInterestFilter();
    private final TaskListInterestSorter taskListInterestSorter = new TaskListInterestSorter();
    private TaskListView taskListView;
    private IAction action;

    public void filterTextChanged(String text) {
        if (this.taskListView.isFocusedMode() && (text == null || "".equals(text.trim()))) {
            this.taskListView.getViewer().expandAll();
        }
    }

    public void init(IAction action) {
        this.action = action;
        this.initAction();
    }

    public void init(IViewPart view) {
        if (view instanceof TaskListView) {
            this.taskListView = (TaskListView)view;
            this.taskListView.getFilteredTree().getRefreshPolicy().addListener((AdaptiveRefreshPolicy.IFilteredTreeListener)this);
            this.taskListView.getFilteredTree().addDisposeListener(e -> this.taskListView.getFilteredTree().getRefreshPolicy().removeListener((AdaptiveRefreshPolicy.IFilteredTreeListener)this));
            if (TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.task.list.focused")) {
                this.installInterestFilter();
            }
            this.initAction();
            this.showProgressBar(this.taskListView.isFocusedMode());
        }
    }

    private void initAction() {
        if (this.action != null && this.taskListView != null) {
            this.action.setChecked(this.taskListView.isFocusedMode());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void showProgressBar(boolean visible) {
        this.taskListView.getFilteredTree().setShowProgress(visible);
    }

    protected void installInterestFilter() {
        TasksUiInternal.preservingSelection(this.taskListView.getViewer(), () -> {
            try {
                this.taskListView.getFilteredTree().setRedraw(false);
                this.taskListView.setFocusedMode(true);
                this.previousSorter = this.taskListView.getViewer().getSorter();
                this.previousFilters = this.taskListView.clearFilters();
                if (!this.taskListView.getFilters().contains(this.taskListInterestFilter)) {
                    this.taskListView.addFilter(this.taskListInterestFilter);
                }
                this.taskListInterestSorter.setconfiguredSorter(this.previousSorter);
                this.taskListView.getViewer().setSorter((ViewerSorter)this.taskListInterestSorter);
                this.taskListView.getViewer().expandAll();
                this.showProgressBar(true);
            }
            finally {
                this.taskListView.getFilteredTree().setRedraw(true);
            }
        });
    }

    protected void uninstallInterestFilter() {
        TasksUiInternal.preservingSelection(this.taskListView.getViewer(), () -> {
            try {
                this.taskListView.getViewer().getControl().setRedraw(false);
                this.taskListView.setFocusedMode(false);
                for (AbstractTaskListFilter filter : this.previousFilters) {
                    this.taskListView.addFilter(filter);
                }
                this.taskListView.removeFilter(this.taskListInterestFilter);
                Text textControl = this.taskListView.getFilteredTree().getFilterControl();
                if (textControl != null && textControl.getText().length() > 0) {
                    this.taskListView.getViewer().expandAll();
                } else {
                    TreeItem item;
                    this.taskListView.getViewer().collapseAll();
                    if (this.taskListView.getViewer().getContentProvider() instanceof TaskScheduleContentProvider && this.taskListView.getViewer().getTree().getItemCount() > 0 && (item = this.taskListView.getViewer().getTree().getItem(0)).getData() != null) {
                        this.taskListView.getViewer().expandToLevel(item.getData(), 1);
                    }
                }
                this.taskListView.getViewer().setSorter(this.previousSorter);
                this.showProgressBar(false);
            }
            finally {
                this.taskListView.getViewer().getControl().setRedraw(true);
            }
        });
    }

    public void run() {
        if (this.taskListView == null) {
            return;
        }
        if (!this.taskListView.isFocusedMode()) {
            TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.task.list.focused", true);
            this.installInterestFilter();
        } else {
            TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.task.list.focused", false);
            this.uninstallInterestFilter();
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void runWithEvent(IAction action, Event event) {
        this.run();
    }

    public void dispose() {
    }
}

