/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import java.util.ArrayList;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.context.ui.ContextUi;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.ui.AbstractEditorTracker;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EditorInteractionMonitor
extends AbstractEditorTracker {
    public static final String SOURCE_ID = "org.eclipse.mylyn.resources.ui.editor.tracker.interest";

    /*
     * WARNING - void declaration
     */
    protected void editorBroughtToTop(IEditorPart part) {
        Object object = part.getEditorInput().getAdapter(IResource.class);
        Object object2 = object;
        if (object2 instanceof IResource) {
            void resource;
            IResource iResource = (IResource)object2;
            IResource cfr_ignored_0 = (IResource)object2;
            AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((Object)resource);
            InteractionEvent selectionEvent = new InteractionEvent(InteractionEvent.Kind.SELECTION, bridge.getContentType(), bridge.getHandleIdentifier((Object)resource), part.getSite().getId());
            ContextCore.getContextManager().processInteractionEvent(selectionEvent);
        }
    }

    public void editorOpened(IEditorPart editorPartOpened) {
        if (!ContextUi.isEditorAutoManageEnabled() || ContextCore.getContextManager().isContextCapturePaused()) {
            return;
        }
        IWorkbenchPage page = editorPartOpened.getSite().getPage();
        ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            try {
                IInteractionElement element = null;
                Object adapter = editorReference.getEditorInput().getAdapter(IResource.class);
                if (adapter instanceof IFile) {
                    String handle = ContextCore.getStructureBridge((Object)adapter).getHandleIdentifier(adapter);
                    element = ContextCore.getContextManager().getElement(handle);
                }
                if (element != null && !element.getInterest().isInteresting() && !this.isSameEditor(editorPartOpened, editorReference)) {
                    toClose.add(editorReference);
                }
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
            ++n2;
        }
        if (toClose.size() > 0) {
            page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), true);
        }
    }

    private boolean isSameEditor(IEditorPart editorPart1, IEditorReference editorReference2) throws PartInitException {
        if (editorPart1 == null || editorReference2 == null) {
            return false;
        }
        return editorPart1.getEditorInput().equals(editorReference2.getEditorInput());
    }

    /*
     * WARNING - void declaration
     */
    public void editorClosed(IEditorPart editorPart) {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        if (ContextUi.isEditorAutoCloseEnabled() && !this.otherEditorsOpenForResource(editorPart) && !(editorPart instanceof CompareEditor)) {
            Object adapter;
            Object object;
            IInteractionElement element = null;
            AbstractContextUiBridge uiBridge = ContextUi.getUiBridgeForEditor((IEditorPart)editorPart);
            Object object2 = uiBridge.getObjectForTextSelection(null, editorPart);
            if (object2 != null) {
                AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((Object)object2);
                element = ContextCore.getContextManager().getElement(bridge.getHandleIdentifier(object2));
            }
            if (element == null && (object = (adapter = editorPart.getEditorInput().getAdapter(IResource.class))) instanceof IResource) {
                void resource;
                IResource iResource = (IResource)object;
                IResource cfr_ignored_0 = (IResource)object;
                AbstractContextStructureBridge resourceBridge = ContextCore.getStructureBridge((Object)resource);
                element = ContextCore.getContextManager().getElement(resourceBridge.getHandleIdentifier((Object)resource));
            }
            if (element != null) {
                ContextCorePlugin.getContextManager().manipulateInterestForElement(element, false, false, false, SOURCE_ID);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean otherEditorsOpenForResource(IEditorPart editorPart) {
        Object adapter = editorPart.getEditorInput().getAdapter(IResource.class);
        Object object = adapter;
        if (object instanceof IResource) {
            IResource iResource = (IResource)object;
            IResource cfr_ignored_0 = (IResource)object;
            IWorkbenchPage page = editorPart.getSite().getPage();
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                try {
                    void resource;
                    Object otherAdapter = editorReference.getEditorInput().getAdapter(IResource.class);
                    if (otherAdapter instanceof IResource && otherAdapter.equals(resource)) {
                        return true;
                    }
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return false;
    }
}

