/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class MenuCommandMonitor
implements Listener {
    public static final String MENU_ITEM_ID = "item.label.";
    public static final String MENU_ITEM_SELECTED = "menu";
    public static final String TOOLBAR_ITEM_SELECTED = "toolbar";
    public static final String MENU_PATH_DELIM = "/";

    /*
     * WARNING - void declaration
     */
    public void handleEvent(Event event) {
        try {
            IAction action;
            void item;
            Widget widget = event.widget;
            if (!(widget instanceof Item)) {
                return;
            }
            Item item2 = (Item)widget;
            Item cfr_ignored_0 = (Item)widget;
            if (item.getData() == null) {
                return;
            }
            Object target = event.widget.getData();
            String id = null;
            String delta = null;
            if (target instanceof IContributionItem) {
                id = ((IContributionItem)target).getId();
            }
            if (id == null && target instanceof ActionContributionItem) {
                action = ((ActionContributionItem)target).getAction();
                id = action.getId() != null ? action.getId() : action.getClass().getName();
            } else if (id == null) {
                id = target.getClass().getName();
            }
            void var10_9 = item;
            if (var10_9 instanceof MenuItem) {
                void menu;
                action = (MenuItem)var10_9;
                MenuItem cfr_ignored_1 = (MenuItem)var10_9;
                Menu parentMenu = menu.getParent();
                Object location = "";
                if (parentMenu != null) {
                    while (parentMenu.getParentItem() != null) {
                        location = parentMenu.getParentItem().getText() + MENU_PATH_DELIM + (String)location;
                        parentMenu = parentMenu.getParentMenu();
                    }
                }
                if (id == null) {
                    return;
                }
                delta = MENU_ITEM_SELECTED;
            } else if (item instanceof ToolItem) {
                delta = TOOLBAR_ITEM_SELECTED;
            }
            InteractionEvent interactionEvent = InteractionEvent.makeCommand((String)id, (String)delta);
            MonitorUiPlugin.getDefault().notifyInteractionObserved(interactionEvent);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.ui", "Could not log selection", t));
        }
    }
}

