/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.UIJob;

public class BrowseFilteredListener
implements MouseListener,
KeyListener {
    private final StructuredViewer viewer;
    private boolean wasExternalClick = false;

    public BrowseFilteredListener(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public void unfilterSelection(TreeViewer treeViewer, IStructuredSelection targetSelection) {
        InterestFilter filter = this.getInterestFilter((StructuredViewer)treeViewer);
        Object targetObject = targetSelection.getFirstElement();
        if (filter != null && targetObject != null) {
            filter.addTemporarilyUnfiltered(targetObject);
            if (targetObject instanceof Tree) {
                treeViewer.refresh();
            } else {
                treeViewer.refresh(targetObject, true);
                treeViewer.expandToLevel(targetObject, 1);
            }
        }
    }

    private void unfilter(InterestFilter filter, TreeViewer treeViewer, Object targetObject) {
        if (targetObject != null) {
            filter.addTemporarilyUnfiltered(targetObject);
            if (targetObject instanceof Tree) {
                treeViewer.refresh();
            } else {
                treeViewer.refresh(targetObject, true);
                treeViewer.expandToLevel(targetObject, 1);
            }
        }
    }

    public void setWasExternalClick(boolean wasExternalClick) {
        this.wasExternalClick = wasExternalClick;
    }

    public void keyPressed(KeyEvent event) {
    }

    /*
     * WARNING - void declaration
     */
    public void keyReleased(KeyEvent event) {
        InterestFilter filter = this.getInterestFilter(this.viewer);
        if (event.keyCode == 0x1000004) {
            void treeViewer;
            StructuredViewer structuredViewer;
            if (filter == null || !((structuredViewer = this.viewer) instanceof TreeViewer)) {
                return;
            }
            TreeViewer treeViewer2 = (TreeViewer)structuredViewer;
            TreeViewer cfr_ignored_0 = (TreeViewer)structuredViewer;
            ISelection selection = treeViewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object targetObject = ((IStructuredSelection)selection).getFirstElement();
                this.unfilter(filter, (TreeViewer)treeViewer, targetObject);
            }
        }
    }

    public void mouseDown(MouseEvent event) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    /*
     * WARNING - void declaration
     */
    public void mouseUp(MouseEvent event) {
        void treeViewer;
        StructuredViewer structuredViewer;
        InterestFilter filter = this.getInterestFilter(this.viewer);
        if (filter == null || !((structuredViewer = this.viewer) instanceof TreeViewer)) {
            return;
        }
        TreeViewer treeViewer2 = (TreeViewer)structuredViewer;
        TreeViewer cfr_ignored_0 = (TreeViewer)structuredViewer;
        Object selectedObject = null;
        Object clickedObject = this.getClickedItem(event);
        selectedObject = clickedObject != null ? clickedObject : treeViewer.getTree();
        if (BrowseFilteredListener.isUnfilterEvent(event)) {
            void var10_7 = treeViewer;
            if (var10_7 instanceof CommonViewer) {
                void commonViewer;
                CommonViewer commonViewer2 = (CommonViewer)var10_7;
                CommonViewer cfr_ignored_1 = (CommonViewer)var10_7;
                commonViewer.setSelection((ISelection)new StructuredSelection(selectedObject), true);
            }
            this.unfilter(filter, (TreeViewer)treeViewer, selectedObject);
        } else if (event.button == 1) {
            if ((event.stateMask & SWT.MOD1) != 0 || this.wasExternalClick) {
                this.viewer.refresh(selectedObject);
                this.wasExternalClick = false;
            } else {
                Object unfiltered = filter.getLastTemporarilyUnfiltered();
                if (unfiltered != null) {
                    this.resetUnfiltered();
                }
            }
        }
    }

    public void resetUnfiltered() {
        new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                InterestFilter filter = BrowseFilteredListener.this.getInterestFilter(BrowseFilteredListener.this.viewer);
                filter.resetTemporarilyUnfiltered();
                BrowseFilteredListener.this.viewer.refresh();
                return Status.OK_STATUS;
            }
        }.schedule((long)(Display.getDefault().getDoubleClickTime() + 50));
    }

    private Object getClickedItem(MouseEvent event) {
        if (event.getSource() instanceof Table) {
            TableItem item = ((Table)event.getSource()).getItem(new Point(event.x, event.y));
            if (item != null) {
                return item.getData();
            }
            return null;
        }
        if (event.getSource() instanceof Tree) {
            TreeItem item = ((Tree)event.getSource()).getItem(new Point(event.x, event.y));
            if (item != null) {
                return item.getData();
            }
            return null;
        }
        return null;
    }

    public static boolean isUnfilterEvent(MouseEvent event) {
        return (event.stateMask & 0x10000) != 0;
    }

    private InterestFilter getInterestFilter(StructuredViewer structuredViewer) {
        ViewerFilter[] filters;
        ViewerFilter[] viewerFilterArray = filters = structuredViewer.getFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (filter instanceof InterestFilter) {
                return (InterestFilter)filter;
            }
            ++n2;
        }
        return null;
    }

    public boolean isUnfiltered(Object object) {
        InterestFilter interestFilter = this.getInterestFilter(this.viewer);
        if (interestFilter != null) {
            return interestFilter.isTemporarilyUnfiltered(object);
        }
        return false;
    }
}

