/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.RevId;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.IntKey;
import java.sql.Timestamp;

public final class PatchSet {
    private static final String REFS_CHANGES = "refs/changes/";
    @Column(id=1, name="--NONE--")
    protected Id id;
    @Column(id=2, notNull=false)
    protected RevId revision;
    @Column(id=3, name="uploader_account_id")
    protected Account.Id uploader;
    @Column(id=4)
    protected Timestamp createdOn;

    public static boolean isRef(String name) {
        return name.matches("^refs/changes/.*/[1-9][0-9]*/[1-9][0-9]*$");
    }

    protected PatchSet() {
    }

    public PatchSet(Id k) {
        this.id = k;
    }

    public Id getId() {
        return this.id;
    }

    public int getPatchSetId() {
        return this.id.get();
    }

    public RevId getRevision() {
        return this.revision;
    }

    public void setRevision(RevId i) {
        this.revision = i;
    }

    public Account.Id getUploader() {
        return this.uploader;
    }

    public void setUploader(Account.Id who) {
        this.uploader = who;
    }

    public Timestamp getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Timestamp ts) {
        this.createdOn = ts;
    }

    public String getRefName() {
        StringBuilder r = new StringBuilder();
        r.append(REFS_CHANGES);
        int changeId = this.id.getParentKey().get();
        int m = changeId % 100;
        if (m < 10) {
            r.append('0');
        }
        r.append(m);
        r.append('/');
        r.append(changeId);
        r.append('/');
        r.append(this.id.get());
        return r.toString();
    }

    public String toString() {
        return "[PatchSet " + this.getId().toString() + "]";
    }

    public static class Id
    extends IntKey<Change.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected Change.Id changeId;
        @Column(id=2)
        protected int patchSetId;

        protected Id() {
            this.changeId = new Change.Id();
        }

        public Id(Change.Id change, int id) {
            this.changeId = change;
            this.patchSetId = id;
        }

        public Change.Id getParentKey() {
            return this.changeId;
        }

        public int get() {
            return this.patchSetId;
        }

        protected void set(int newValue) {
            this.patchSetId = newValue;
        }

        public static Id parse(String str) {
            Id r = new Id();
            r.fromString(str);
            return r;
        }

        public static Id fromRef(String name) {
            if (!name.startsWith(PatchSet.REFS_CHANGES)) {
                throw new IllegalArgumentException("Not a PatchSet.Id: " + name);
            }
            String[] parts = name.substring(PatchSet.REFS_CHANGES.length()).split("/");
            int n = parts.length;
            if (n < 2) {
                throw new IllegalArgumentException("Not a PatchSet.Id: " + name);
            }
            int changeId = Integer.parseInt(parts[n - 2]);
            int patchSetId = Integer.parseInt(parts[n - 1]);
            return new Id(new Change.Id(changeId), patchSetId);
        }
    }
}

