/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.tasks.ui;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.ui.ContextAwareEditorInput;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;

public class ContextTasksAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{IInteractionContext.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IInteractionContext.class) {
            if (adaptableObject == TasksUi.getTaskActivityManager().getActiveTask()) {
                return ContextCore.getContextManager().getActiveContext();
            }
            if (adaptableObject instanceof TaskEditorInput) {
                TaskEditorInput editorInput = (TaskEditorInput)adaptableObject;
                ITask task = editorInput.getTask();
                return ContextCorePlugin.getContextStore().loadContext(task.getHandleIdentifier());
            }
        } else if (adapterType == ContextAwareEditorInput.class && adaptableObject instanceof TaskEditorInput) {
            final TaskEditorInput input = (TaskEditorInput)adaptableObject;
            return new ContextAwareEditorInput(){

                public boolean forceClose(String contextHandle) {
                    return !input.getTask().getHandleIdentifier().equals(contextHandle);
                }
            };
        }
        return null;
    }

    public Class[] getAdapterList() {
        return ADAPTER_LIST;
    }
}

