/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tasks.ui.editor;

import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.commons.workbench.browser.UrlHyperlink;
import org.eclipse.mylyn.internal.wikitext.tasks.ui.util.Util;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.util.PreferenceStoreFacade;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.AnnotationHyperlinkDetector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskHyperlinkPresenter;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.mylyn.wikitext.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguageConfiguration;
import org.eclipse.mylyn.wikitext.ui.editor.MarkupSourceViewer;
import org.eclipse.mylyn.wikitext.ui.editor.MarkupSourceViewerConfiguration;
import org.eclipse.mylyn.wikitext.ui.editor.ShowInTargetBridge;
import org.eclipse.mylyn.wikitext.ui.viewer.AbstractTextSourceViewerConfiguration;
import org.eclipse.mylyn.wikitext.ui.viewer.DefaultHyperlinkDetectorDescriptorFilter;
import org.eclipse.mylyn.wikitext.ui.viewer.MarkupViewer;
import org.eclipse.mylyn.wikitext.ui.viewer.MarkupViewerConfiguration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class MarkupTaskEditorExtension<MarkupLanguageType extends MarkupLanguage>
extends AbstractTaskEditorExtension
implements IAdaptable {
    private static final String MARKUP_SOURCE_CONTEXT_ID = "org.eclipse.mylyn.wikitext.tasks.ui.markupSourceContext";
    private static final String MARKUP_VIEWER = "org.eclipse.mylyn.wikitext.tasks.ui.markupViewer";
    private static final boolean DISABLE_WIKI_WORD = Boolean.getBoolean(String.valueOf(MarkupTaskEditorExtension.class.getSimpleName()) + ".wikiWordDisabled");
    private static final String ID_CONTEXT_EDITOR_TASK = "org.eclipse.mylyn.tasks.ui.TaskEditor";
    private static final String ID_CONTEXT_EDITOR_TEXT = "org.eclipse.ui.DefaultTextEditor";
    private MarkupLanguageType markupLanguage;

    public MarkupLanguageType getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguageType markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    public String getEditorContextId() {
        return MARKUP_SOURCE_CONTEXT_ID;
    }

    @Deprecated
    public SourceViewer createViewer(TaskRepository taskRepository, Composite parent, int style) {
        return this.createViewer(taskRepository, parent, style, null);
    }

    public SourceViewer createViewer(TaskRepository taskRepository, Composite parent, int style, IAdaptable context) {
        if (this.markupLanguage == null) {
            throw new IllegalStateException();
        }
        MarkupViewer markupViewer = new MarkupViewer(parent, null, style | 0x800000 | 0x40);
        MarkupLanguageType markupLanguageCopy = this.createRepositoryMarkupLanguage(taskRepository);
        this.configureMarkupLanguage(taskRepository, markupLanguageCopy);
        markupViewer.setMarkupLanguage(markupLanguageCopy);
        TaskMarkupViewerConfiguration configuration = this.createViewerConfiguration(taskRepository, markupViewer, context);
        configuration.setDisableHyperlinkModifiers(true);
        configuration.setEnableSelfContainedIncrementalFind(true);
        if (markupLanguageCopy instanceof AbstractMarkupLanguage && ((AbstractMarkupLanguage)markupLanguageCopy).isDetectingRawHyperlinks()) {
            configuration.addHyperlinkDetectorDescriptorFilter((AbstractTextSourceViewerConfiguration.HyperlinkDetectorDescriptorFilter)new DefaultHyperlinkDetectorDescriptorFilter("org.eclipse.mylyn.tasks.ui.hyperlinks.detectors.url"));
        }
        markupViewer.configure((SourceViewerConfiguration)configuration);
        markupViewer.setEditable(false);
        markupViewer.getTextWidget().setCaret(null);
        if (JFaceResources.getFontRegistry().hasValueFor("org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment")) {
            markupViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment"));
        }
        if (JFaceResources.getFontRegistry().hasValueFor("org.eclipse.mylyn.wikitext.tasks.ui.monospaceFont")) {
            markupViewer.setDefaultMonospaceFont(JFaceResources.getFontRegistry().get("org.eclipse.mylyn.wikitext.tasks.ui.monospaceFont"));
        }
        markupViewer.setStylesheet(WikiTextUiPlugin.getDefault().getPreferences().getStylesheet());
        IFocusService focusService = (IFocusService)PlatformUI.getWorkbench().getService(IFocusService.class);
        if (focusService != null) {
            focusService.addFocusTracker((Control)markupViewer.getTextWidget(), MARKUP_VIEWER);
        }
        markupViewer.getTextWidget().setData(ISourceViewer.class.getName(), (Object)markupViewer);
        return markupViewer;
    }

    private MarkupLanguageType createRepositoryMarkupLanguage(TaskRepository taskRepository) {
        MarkupLanguage copy = this.markupLanguage.clone();
        MarkupLanguageConfiguration configuration = this.createMarkupLanguageConfiguration(taskRepository);
        copy.configure(configuration);
        return (MarkupLanguageType)copy;
    }

    protected MarkupLanguageConfiguration createMarkupLanguageConfiguration(TaskRepository taskRepository) {
        MarkupLanguageConfiguration configuration = Util.create(taskRepository.getConnectorKind());
        if (DISABLE_WIKI_WORD) {
            configuration.setWikiWordLinking(Boolean.valueOf(false));
        }
        return configuration;
    }

    protected TaskMarkupViewerConfiguration createViewerConfiguration(TaskRepository taskRepository, MarkupViewer markupViewer) {
        return this.createViewerConfiguration(taskRepository, markupViewer, null);
    }

    protected TaskMarkupViewerConfiguration createViewerConfiguration(TaskRepository taskRepository, MarkupViewer markupViewer, IAdaptable context) {
        return new TaskMarkupViewerConfiguration(markupViewer, taskRepository, context);
    }

    protected TaskMarkupSourceViewerConfiguration createSourceViewerConfiguration(TaskRepository taskRepository, SourceViewer viewer) {
        return this.createSourceViewerConfiguration(taskRepository, viewer, null);
    }

    protected TaskMarkupSourceViewerConfiguration createSourceViewerConfiguration(TaskRepository taskRepository, SourceViewer viewer, IAdaptable context) {
        IPreferenceStore preferenceStore = EditorsUI.getPreferenceStore();
        return new TaskMarkupSourceViewerConfiguration(preferenceStore, taskRepository, context);
    }

    @Deprecated
    public SourceViewer createEditor(TaskRepository taskRepository, Composite parent, int style) {
        return this.createEditor(taskRepository, parent, style, null);
    }

    public SourceViewer createEditor(TaskRepository taskRepository, Composite parent, int style, IAdaptable context) {
        MarkupLanguageType markupLanguageCopy = this.createRepositoryMarkupLanguage(taskRepository);
        this.configureMarkupLanguage(taskRepository, markupLanguageCopy);
        MarkupSourceViewer viewer = new MarkupSourceViewer(parent, null, style | 0x40, markupLanguageCopy);
        TaskMarkupSourceViewerConfiguration configuration = this.createSourceViewerConfiguration(taskRepository, (SourceViewer)viewer, context);
        configuration.setEnableSelfContainedIncrementalFind(true);
        configuration.setMarkupLanguage((MarkupLanguage)markupLanguageCopy);
        configuration.setShowInTarget((IShowInTarget)new ShowInTargetBridge((SourceViewer)viewer));
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.showAnnotations(true);
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        MarkerAnnotationPreferences annotationPreferences = new MarkerAnnotationPreferences();
        final SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)viewer, null, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
        for (AnnotationPreference preference : annotationPreferences.getAnnotationPreferences()) {
            support.setAnnotationPreference(preference);
        }
        support.setCursorLinePainterPreferenceKeys("currentLine", "currentLineColor");
        support.setMarginPainterPreferenceKeys("printMargin", "printMarginColor", "printMarginColumn");
        support.install((IPreferenceStore)new EditorExtensionPreferenceStore(EditorsUI.getPreferenceStore(), viewer.getControl()));
        viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                support.dispose();
            }
        });
        IFocusService focusService = (IFocusService)PlatformUI.getWorkbench().getService(IFocusService.class);
        if (focusService != null) {
            focusService.addFocusTracker((Control)viewer.getTextWidget(), "org.eclipse.mylyn.wikitext.ui.editor.sourceViewer");
        }
        viewer.getTextWidget().setData(MarkupLanguage.class.getName(), markupLanguageCopy);
        viewer.getTextWidget().setData(ISourceViewer.class.getName(), (Object)viewer);
        return viewer;
    }

    protected void configureMarkupLanguage(TaskRepository taskRepository, MarkupLanguageType markupLanguage) {
        String internalLinkPattern = taskRepository.getProperty("wikiLinkPattern");
        if (internalLinkPattern != null && internalLinkPattern.trim().length() > 0) {
            ((AbstractMarkupLanguage)markupLanguage).setInternalLinkPattern(internalLinkPattern.trim());
        } else {
            this.configureDefaultInternalLinkPattern(taskRepository, markupLanguage);
        }
    }

    protected void configureDefaultInternalLinkPattern(TaskRepository taskRepository, MarkupLanguageType markupLanguage) {
    }

    private static IAdaptable createDefaultHyperlinkDetectorContext(final TaskRepository repository) {
        return new IAdaptable(){

            public <T> T getAdapter(Class<T> adapter) {
                if (adapter == TaskRepository.class) {
                    return (T)repository;
                }
                return null;
            }
        };
    }

    private static void addRepositoryHyperlinkDetectorTargets(IAdaptable context, Map hyperlinkDetectorTargets) {
        hyperlinkDetectorTargets.put(ID_CONTEXT_EDITOR_TEXT, context);
        hyperlinkDetectorTargets.put(ID_CONTEXT_EDITOR_TASK, context);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (MarkupLanguage.class == adapter) {
            return (T)this.getMarkupLanguage();
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    private static class EditorExtensionPreferenceStore
    extends PreferenceStoreFacade {
        boolean controlFocused;

        public EditorExtensionPreferenceStore(IPreferenceStore preferenceStore, Control control) {
            super(preferenceStore);
            this.controlFocused = control.isFocusControl();
            control.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    controlFocused = true;
                    this.focusChanged();
                }

                public void focusLost(FocusEvent e) {
                    controlFocused = false;
                    this.focusChanged();
                }
            });
        }

        protected void focusChanged() {
            if (!this.getCurrentLineHighlightPreference()) {
                return;
            }
            boolean newValue = this.getBoolean("currentLine");
            this.firePropertyChangeEvent("currentLine", !newValue, newValue);
        }

        private boolean getCurrentLineHighlightPreference() {
            return TasksUiUtil.getHighlightCurrentLine();
        }

        public boolean getBoolean(String name) {
            if ("currentLine".equals(name)) {
                if (!this.controlFocused) {
                    return false;
                }
                return this.getCurrentLineHighlightPreference();
            }
            if ("printMargin".equals(name)) {
                return false;
            }
            return super.getBoolean(name);
        }
    }

    private static class PlatformUrlAnnotationHyperlinkDetector
    extends AnnotationHyperlinkDetector {
        private PlatformUrlAnnotationHyperlinkDetector() {
        }

        protected IHyperlink createUrlHyperlink(IRegion region, String href) {
            return new UrlHyperlink(region, href);
        }
    }

    protected static class TaskMarkupSourceViewerConfiguration
    extends MarkupSourceViewerConfiguration {
        private final TaskRepository taskRepository;
        private final IAdaptable context;

        public TaskMarkupSourceViewerConfiguration(IPreferenceStore preferenceStore, TaskRepository taskRepository) {
            this(preferenceStore, taskRepository, null);
            this.setEnableHippieContentAssist(false);
        }

        public TaskMarkupSourceViewerConfiguration(IPreferenceStore preferenceStore, TaskRepository taskRepository, IAdaptable context) {
            super(preferenceStore, "org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment", "org.eclipse.mylyn.wikitext.tasks.ui.monospaceFont");
            this.taskRepository = taskRepository;
            this.context = context == null ? MarkupTaskEditorExtension.createDefaultHyperlinkDetectorContext(taskRepository) : context;
            this.addHyperlinkDetectorDescriptorFilter((AbstractTextSourceViewerConfiguration.HyperlinkDetectorDescriptorFilter)new DefaultHyperlinkDetectorDescriptorFilter("org.eclipse.ui.internal.editors.text.URLHyperlinkDetector"));
        }

        protected IContentAssistProcessor[] createContentAssistProcessors() {
            IContentAssistProcessor[] iContentAssistProcessorArray;
            IContentAssistProcessor processor = TasksUi.getUiFactory().createTaskContentAssistProcessor(this.taskRepository);
            if (processor == null) {
                iContentAssistProcessorArray = null;
            } else {
                IContentAssistProcessor[] iContentAssistProcessorArray2 = new IContentAssistProcessor[1];
                iContentAssistProcessorArray = iContentAssistProcessorArray2;
                iContentAssistProcessorArray2[0] = processor;
            }
            return iContentAssistProcessorArray;
        }

        public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
            return new DefaultAnnotationHover(){

                protected boolean isIncluded(Annotation annotation) {
                    return annotation.getType().startsWith("org.eclipse.wikitext") || super.isIncluded(annotation);
                }
            };
        }

        protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
            Map hyperlinkDetectorTargets = super.getHyperlinkDetectorTargets(sourceViewer);
            MarkupTaskEditorExtension.addRepositoryHyperlinkDetectorTargets(this.context, hyperlinkDetectorTargets);
            return hyperlinkDetectorTargets;
        }

        public IReconciler getReconciler(ISourceViewer sourceViewer) {
            if (sourceViewer.isEditable()) {
                return super.getReconciler(sourceViewer);
            }
            return null;
        }

        public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
            return 0;
        }

        public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
            if (this.fPreferenceStore == null) {
                return new TaskHyperlinkPresenter(new RGB(0, 0, 255));
            }
            return new TaskHyperlinkPresenter(this.fPreferenceStore);
        }
    }

    protected static class TaskMarkupViewerConfiguration
    extends MarkupViewerConfiguration {
        private final IAdaptable context;

        public TaskMarkupViewerConfiguration(MarkupViewer viewer, TaskRepository taskRepository) {
            this(viewer, taskRepository, null);
        }

        public TaskMarkupViewerConfiguration(MarkupViewer viewer, TaskRepository taskRepository, IAdaptable context) {
            super(viewer);
            this.context = context == null ? MarkupTaskEditorExtension.createDefaultHyperlinkDetectorContext(taskRepository) : context;
            this.markupHyperlinksFirst = false;
        }

        protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
            Map hyperlinkDetectorTargets = super.getHyperlinkDetectorTargets(sourceViewer);
            MarkupTaskEditorExtension.addRepositoryHyperlinkDetectorTargets(this.context, hyperlinkDetectorTargets);
            return hyperlinkDetectorTargets;
        }

        protected AnnotationHyperlinkDetector createAnnotationHyperlinkDetector() {
            return new PlatformUrlAnnotationHyperlinkDetector();
        }

        public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
            if (this.fPreferenceStore == null) {
                return new TaskHyperlinkPresenter(new RGB(0, 0, 255));
            }
            return new TaskHyperlinkPresenter(this.fPreferenceStore);
        }
    }
}

