/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.block;

import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.asciidoc.internal.block.AsciiDocBlock;
import org.eclipse.mylyn.wikitext.asciidoc.internal.util.LanguageSupport;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.TableAttributes;
import org.eclipse.mylyn.wikitext.parser.TableCellAttributes;
import org.eclipse.mylyn.wikitext.parser.TableRowAttributes;

public class TableBlock
extends AsciiDocBlock {
    private TableFormat format;
    private String separator;
    private int cellsCount = 0;
    private List<TableCellAttributes> colsAttribute;
    private boolean hasHeader = false;
    private boolean cellBlockIsOpen = false;

    public TableBlock() {
        super(Pattern.compile("^(\\||,|:)===\\s*"));
    }

    @Override
    protected void processBlockStart() {
        String options;
        String separator;
        if (this.startDelimiter.startsWith(",")) {
            this.format = TableFormat.COMMA_SEPARATED_VALUES;
            this.hasHeader = true;
        } else if (this.startDelimiter.startsWith(":")) {
            this.format = TableFormat.DELIMITER_SEPARATED_VALUES;
            this.hasHeader = true;
        } else {
            this.format = TableFormat.PREFIX_SEPARATED_VALUES;
            this.separator = "|";
        }
        Map<String, String> lastProperties = this.getAsciiDocState().getLastProperties(Collections.emptyList());
        this.colsAttribute = LanguageSupport.computeColumnsAttributeList(lastProperties.get("cols"));
        String formatProperty = lastProperties.get("format");
        if (formatProperty != null) {
            switch (formatProperty) {
                case "dsv": {
                    this.format = TableFormat.DELIMITER_SEPARATED_VALUES;
                    break;
                }
                case "csv": {
                    this.format = TableFormat.COMMA_SEPARATED_VALUES;
                }
            }
        }
        if ((separator = lastProperties.get("separator")) != null) {
            this.separator = separator;
        }
        if ((options = lastProperties.get("options")) != null) {
            this.hasHeader = options.contains("header");
        }
        TableAttributes tableAttributes = new TableAttributes();
        tableAttributes.setWidth(lastProperties.get("width"));
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE, (Attributes)tableAttributes);
    }

    @Override
    protected void processBlockContent(String line) {
        if (!line.trim().isEmpty()) {
            if (this.colsAttribute.isEmpty() && !this.cellBlockIsOpen) {
                TableRowAttributes tableRowAttributes = new TableRowAttributes();
                this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, (Attributes)tableRowAttributes);
            }
            boolean firstCellInLine = true;
            for (String cell : this.createRowCellSplitter(line)) {
                String cellContent = cell.trim();
                if (this.format == TableFormat.PREFIX_SEPARATED_VALUES && this.cellBlockIsOpen && !cellContent.isEmpty() && firstCellInLine) {
                    this.markupLanguage.emitMarkupLine(this.parser, this.state, " " + cellContent, 0);
                } else {
                    if (this.colsAttribute.isEmpty() && this.cellBlockIsOpen && firstCellInLine) {
                        this.closeCellBlockIfNeeded();
                        this.builder.endBlock();
                        this.colsAttribute = LanguageSupport.createDefaultColumnsAttributeList(this.cellsCount);
                    }
                    if (!cellContent.isEmpty() || !firstCellInLine) {
                        this.handleCellContent(cellContent);
                    }
                }
                firstCellInLine = false;
            }
        }
    }

    private Iterable<String> createRowCellSplitter(String line) {
        if (this.format == TableFormat.COMMA_SEPARATED_VALUES) {
            return Splitter.on((Pattern)Pattern.compile(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)")).split((CharSequence)line);
        }
        String delimiter = this.getCellSeparator();
        return Splitter.on((Pattern)Pattern.compile("(?<!\\\\)" + Pattern.quote(delimiter))).split((CharSequence)line);
    }

    private String getCellSeparator() {
        switch (this.format) {
            case COMMA_SEPARATED_VALUES: {
                return ",";
            }
            case DELIMITER_SEPARATED_VALUES: {
                return ":";
            }
        }
        return this.separator;
    }

    private void handleCellContent(String cellContent) {
        String blockContent;
        this.closeCellBlockIfNeeded();
        if (this.format == TableFormat.COMMA_SEPARATED_VALUES) {
            blockContent = cellContent.startsWith("\"") && cellContent.endsWith("\"") ? cellContent.substring(1, cellContent.length() - 1).replaceAll("\"\"", "\"") : cellContent;
        } else {
            String delimiter = this.getCellSeparator();
            blockContent = cellContent.replaceAll("\\\\" + Pattern.quote(delimiter), delimiter);
        }
        if (!this.colsAttribute.isEmpty() && this.cellsCount % this.colsAttribute.size() == 0) {
            TableRowAttributes tableRowAttributes = new TableRowAttributes();
            this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, (Attributes)tableRowAttributes);
        }
        TableCellAttributes attributes = this.colsAttribute.isEmpty() ? new TableCellAttributes() : this.colsAttribute.get(this.cellsCount % this.colsAttribute.size());
        if (this.hasHeader && (this.colsAttribute.isEmpty() || this.cellsCount < this.colsAttribute.size())) {
            this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_HEADER, (Attributes)attributes);
        } else {
            this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, (Attributes)attributes);
        }
        this.cellBlockIsOpen = true;
        this.markupLanguage.emitMarkupLine(this.parser, this.state, blockContent, 0);
    }

    @Override
    protected void processBlockEnd() {
        this.closeCellBlockIfNeeded();
        if (this.colsAttribute.isEmpty() && this.cellsCount > 0 || !this.colsAttribute.isEmpty() && this.cellsCount % this.colsAttribute.size() != 0) {
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    private void closeCellBlockIfNeeded() {
        if (this.cellBlockIsOpen) {
            this.builder.endBlock();
            this.cellBlockIsOpen = false;
            ++this.cellsCount;
            if (!this.colsAttribute.isEmpty() && this.cellsCount % this.colsAttribute.size() == 0) {
                this.builder.endBlock();
            }
        }
    }

    private static enum TableFormat {
        PREFIX_SEPARATED_VALUES,
        DELIMITER_SEPARATED_VALUES,
        COMMA_SEPARATED_VALUES;

    }
}

