/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmCompoundTypeReference;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmInnerTypeReference;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmSynonymTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.ITypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xtype.XComputedTypeReference;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.util.XtypeReferenceVisitorWithParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ProxyAwareUIStrings
implements XtypeReferenceVisitorWithParameter<StringBuilder, StringBuilder> {
    public StringBuilder visit(JvmTypeReference reference, StringBuilder param) {
        if (reference == null) {
            return null;
        }
        return (StringBuilder)reference.accept((ITypeReferenceVisitorWithParameter)this, (Object)param);
    }

    public StringBuilder appendTypeSignature(JvmType type, StringBuilder result) {
        EList typeParameters;
        result.append(type.getSimpleName());
        if (type instanceof JvmTypeParameterDeclarator && !(typeParameters = ((JvmTypeParameterDeclarator)type).getTypeParameters()).isEmpty()) {
            result.append("<");
            int i = 0;
            int size = typeParameters.size();
            while (i < size) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(((JvmTypeParameter)typeParameters.get(i)).getName());
                ++i;
            }
            result.append(">");
        }
        return result;
    }

    public StringBuilder appendTypeArguments(JvmParameterizedTypeReference typeRef, StringBuilder result) {
        EList typeArguments = typeRef.getArguments();
        if (typeArguments.isEmpty()) {
            throw new IllegalArgumentException("typeRef is not parameterized");
        }
        result.append("<");
        int i = 0;
        int size = typeArguments.size();
        while (i < size) {
            if (i != 0) {
                result.append(", ");
            }
            if ((result = this.visit((JvmTypeReference)typeArguments.get(i), result)) == null) {
                return null;
            }
            ++i;
        }
        result.append(">");
        return result;
    }

    public StringBuilder doVisitAnyTypeReference(JvmAnyTypeReference reference, StringBuilder param) {
        return this.doVisitTypeReference((JvmTypeReference)reference, param);
    }

    public StringBuilder doVisitDelegateTypeReference(JvmDelegateTypeReference reference, StringBuilder param) {
        return this.visit(reference.getDelegate(), param);
    }

    public StringBuilder doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference, StringBuilder param) {
        param = this.visit(reference.getComponentType(), param);
        if (param != null) {
            param.append("[]");
        }
        return param;
    }

    public StringBuilder doVisitCompoundTypeReference(JvmCompoundTypeReference reference, StringBuilder param) {
        throw new IllegalStateException("Should never be called");
    }

    protected StringBuilder doVisitCompoundTypeReference(JvmCompoundTypeReference reference, StringBuilder param, String delim) {
        EList references = reference.getReferences();
        int i = 0;
        while (i < references.size()) {
            if (i != 0) {
                param.append(delim);
            }
            if ((param = this.visit((JvmTypeReference)references.get(i), param)) == null) {
                return null;
            }
            ++i;
        }
        return param;
    }

    public StringBuilder doVisitMultiTypeReference(JvmMultiTypeReference reference, StringBuilder param) {
        return this.doVisitCompoundTypeReference((JvmCompoundTypeReference)reference, param, " & ");
    }

    public StringBuilder doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference, StringBuilder param) {
        JvmType type = reference.getType();
        if (type == null || type.eIsProxy()) {
            return null;
        }
        param.append(type.getSimpleName());
        EList typeArguments = reference.getArguments();
        if (typeArguments.isEmpty()) {
            return param;
        }
        param.append("<");
        int i = 0;
        int size = typeArguments.size();
        while (i < size) {
            if (i != 0) {
                param.append(", ");
            }
            if ((param = this.visit((JvmTypeReference)typeArguments.get(i), param)) == null) {
                return null;
            }
            ++i;
        }
        param.append(">");
        return param;
    }

    public StringBuilder doVisitInnerTypeReference(JvmInnerTypeReference reference, StringBuilder param) {
        JvmType type = reference.getType();
        if (type == null || type.eIsProxy()) {
            return null;
        }
        param = (StringBuilder)reference.getOuter().accept((ITypeReferenceVisitorWithParameter)this, (Object)param);
        if (param == null) {
            return null;
        }
        param.append(".");
        return this.doVisitParameterizedTypeReference((JvmParameterizedTypeReference)reference, param);
    }

    public StringBuilder doVisitSpecializedTypeReference(JvmSpecializedTypeReference reference, StringBuilder param) {
        return this.visit(reference.getEquivalent(), param);
    }

    public StringBuilder doVisitSynonymTypeReference(JvmSynonymTypeReference reference, StringBuilder param) {
        return this.doVisitCompoundTypeReference((JvmCompoundTypeReference)reference, param, " | ");
    }

    public StringBuilder doVisitUnknownTypeReference(JvmUnknownTypeReference reference, StringBuilder param) {
        return this.doVisitTypeReference((JvmTypeReference)reference, param);
    }

    public StringBuilder doVisitWildcardTypeReference(JvmWildcardTypeReference reference, StringBuilder param) {
        param.append("? ");
        EList constraints = reference.getConstraints();
        int size = constraints.size();
        int i = 0;
        while (i < size) {
            JvmTypeConstraint constraint = (JvmTypeConstraint)constraints.get(i);
            if (constraint.eClass() == TypesPackage.Literals.JVM_LOWER_BOUND) {
                param.append("super ");
                return this.visit(constraint.getTypeReference(), param);
            }
            ++i;
        }
        boolean first = true;
        int i2 = 0;
        while (i2 < size) {
            JvmTypeConstraint constraint = (JvmTypeConstraint)constraints.get(i2);
            if (constraint.eClass() == TypesPackage.Literals.JVM_UPPER_BOUND) {
                if (first) {
                    param.append("extends ");
                } else {
                    param.append(" & ");
                }
                param = this.visit(constraint.getTypeReference(), param);
                if (param == null) {
                    return null;
                }
            }
            ++i2;
        }
        return param;
    }

    @Override
    public StringBuilder doVisitComputedTypeReference(XComputedTypeReference reference, StringBuilder param) {
        return this.doVisitSpecializedTypeReference((JvmSpecializedTypeReference)reference, param);
    }

    @Override
    public StringBuilder doVisitFunctionTypeReference(XFunctionTypeRef reference, StringBuilder param) {
        param.append("(");
        EList<JvmTypeReference> paramTypes = reference.getParamTypes();
        int i = 0;
        int size = paramTypes.size();
        while (i < size) {
            if (i != 0) {
                param.append(", ");
            }
            if ((param = this.visit((JvmTypeReference)paramTypes.get(i), param)) == null) {
                return null;
            }
            ++i;
        }
        param.append(")=>");
        return this.visit(reference.getReturnType(), param);
    }

    public StringBuilder doVisitTypeReference(JvmTypeReference reference, StringBuilder param) {
        param.append(reference.getSimpleName());
        return param;
    }
}

