/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.impl;

import com.google.inject.Inject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.label.AbstractLabelProvider;

public class OutlineNodeLabelProvider
extends DelegatingStyledCellLabelProvider
implements ILabelProvider {
    @Inject
    public OutlineNodeLabelProvider(Delegate delegate) {
        super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)delegate);
    }

    public String getText(Object element) {
        StyledString styledText = this.getStyledText(element);
        return styledText != null ? styledText.toString() : null;
    }

    public static class Delegate
    extends AbstractLabelProvider {
        @Inject
        private IImageHelper imageHelper;

        protected Object doGetText(Object element) {
            if (element instanceof IOutlineNode) {
                return ((IOutlineNode)element).getText();
            }
            return super.doGetText(element);
        }

        protected Object doGetImage(Object element) {
            Image image;
            ImageDescriptor imageDescriptor;
            if (element instanceof IOutlineNode.Extension && (imageDescriptor = ((IOutlineNode.Extension)element).getImageDescriptor()) != null) {
                return imageDescriptor;
            }
            if (element instanceof IOutlineNode && (image = ((IOutlineNode)element).getImage()) != null) {
                return image;
            }
            return super.doGetImage(element);
        }

        protected Object getDefaultImage() {
            return this.imageHelper.getImage("defaultoutlinenode.gif");
        }

        protected String getDefaultText() {
            return "<null>";
        }

        public Image getImage(Object element) {
            return super.getImage(element);
        }

        public String getText(Object element) {
            return super.getText(element);
        }
    }
}

