/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model.edit;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.ITextEditComposer;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReconcilingUnitOfWork<T>
implements IUnitOfWork<T, XtextResource> {
    private final IUnitOfWork<T, XtextResource> work;
    private final IXtextDocument document;
    private final ITextEditComposer composer;

    public ReconcilingUnitOfWork(IUnitOfWork<T, XtextResource> work, IXtextDocument document, ITextEditComposer composer) {
        this.work = work;
        this.document = document;
        this.composer = composer;
    }

    public T exec(XtextResource state) throws Exception {
        Object result;
        String original = this.document.get();
        DocumentChangeListener documentChangeListener = new DocumentChangeListener();
        try {
            try {
                this.document.addDocumentListener(documentChangeListener);
                EcoreUtil2.resolveAll((Resource)state, (CancelIndicator)CancelIndicator.NullImpl);
                this.composer.beginRecording((Resource)state);
                result = this.work.exec((Object)state);
                TextEdit edit = this.composer.endRecording();
                if (edit != null) {
                    if (documentChangeListener.hasDocumentChanged()) {
                        throw new IllegalStateException("Cannot modify document textually and semantically within the same unit of work");
                    }
                    edit.apply((IDocument)this.document);
                }
            }
            catch (RuntimeException e) {
                this.document.set(original);
                throw e;
            }
            catch (Exception e) {
                this.document.set(original);
                throw new RuntimeException(e);
            }
        }
        finally {
            this.document.removeDocumentListener(documentChangeListener);
        }
        return (T)result;
    }

    protected static class DocumentChangeListener
    implements IDocumentListener {
        private boolean documentChanged = false;

        protected DocumentChangeListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.documentChanged = true;
        }

        public boolean hasDocumentChanged() {
            return this.documentChanged;
        }
    }
}

