/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.xbase.XAbstractWhileExpression;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;

public class ExtendedEarlyExitComputer {
    public boolean isIntentionalEarlyExit(@Nullable XExpression expression) {
        if (expression == null) {
            return true;
        }
        if (expression instanceof XBlockExpression) {
            XBlockExpression block = (XBlockExpression)expression;
            EList<XExpression> children = block.getExpressions();
            for (XExpression child : children) {
                if (!this.isIntentionalEarlyExit(child)) continue;
                return true;
            }
        } else {
            if (expression instanceof XIfExpression) {
                return this.isIntentionalEarlyExit(((XIfExpression)expression).getThen()) && this.isIntentionalEarlyExit(((XIfExpression)expression).getElse());
            }
            if (expression instanceof XTryCatchFinallyExpression) {
                XTryCatchFinallyExpression tryCatchFinally = (XTryCatchFinallyExpression)expression;
                if (this.isIntentionalEarlyExit(tryCatchFinally.getExpression())) {
                    for (XCatchClause catchClause : tryCatchFinally.getCatchClauses()) {
                        if (this.isIntentionalEarlyExit(catchClause.getExpression())) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (expression instanceof XAbstractWhileExpression) {
                return this.isIntentionalEarlyExit(((XAbstractWhileExpression)expression).getBody());
            }
            if (expression instanceof XForLoopExpression) {
                return this.isIntentionalEarlyExit(((XForLoopExpression)expression).getEachExpression());
            }
        }
        return expression instanceof XReturnExpression || expression instanceof XThrowExpression;
    }

    public boolean isDefiniteEarlyExit(XExpression expression) {
        if (expression instanceof XIfExpression) {
            XIfExpression ifExpression = (XIfExpression)expression;
            return this.isDefiniteEarlyExit(ifExpression.getThen()) && this.isDefiniteEarlyExit(ifExpression.getElse());
        }
        if (expression instanceof XSwitchExpression) {
            XSwitchExpression switchExpression = (XSwitchExpression)expression;
            if (this.isDefiniteEarlyExit(switchExpression.getDefault())) {
                for (XCasePart caseExpression : switchExpression.getCases()) {
                    if (this.isDefiniteEarlyExit(caseExpression.getThen())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (expression instanceof XTryCatchFinallyExpression) {
            XTryCatchFinallyExpression tryExpression = (XTryCatchFinallyExpression)expression;
            if (this.isDefiniteEarlyExit(tryExpression.getFinallyExpression())) {
                return true;
            }
            if (this.isDefiniteEarlyExit(tryExpression.getExpression())) {
                for (XCatchClause catchClause : tryExpression.getCatchClauses()) {
                    if (this.isDefiniteEarlyExit(catchClause.getExpression())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (expression instanceof XBlockExpression) {
            EList<XExpression> expressions = ((XBlockExpression)expression).getExpressions();
            int i = expressions.size() - 1;
            while (i >= 0) {
                if (this.isDefiniteEarlyExit((XExpression)expressions.get(i))) {
                    return true;
                }
                --i;
            }
        }
        return expression instanceof XReturnExpression || expression instanceof XThrowExpression;
    }
}

