/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.resource.ISynchronizable;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.DefaultBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.ForwardingResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.IReentrantTypeResolver;

public class CachingBatchTypeResolver
implements IBatchTypeResolver {
    @Inject
    private OnChangeEvictingCache cache;
    @Inject
    private DefaultBatchTypeResolver delegate;

    @NonNull
    public IResolvedTypes resolveTypes(final @Nullable EObject object) {
        if (object == null || object.eIsProxy()) {
            return IResolvedTypes.NULL;
        }
        EObject nonArtificialObject = object;
        if (object.eResource() == null && object instanceof XAbstractFeatureCall) {
            nonArtificialObject = ((XAbstractFeatureCall)object).getFeature();
        }
        final Resource resource = nonArtificialObject.eResource();
        final LazyResolvedTypes result = (LazyResolvedTypes)this.cache.get(CachingBatchTypeResolver.class, resource, (Provider)new Provider<LazyResolvedTypes>(){

            public LazyResolvedTypes get() {
                IReentrantTypeResolver resolver = CachingBatchTypeResolver.this.delegate.getTypeResolver(object);
                return new LazyResolvedTypes(resolver, resource);
            }
        });
        this.cache.execWithoutCacheClear(resource, (IUnitOfWork)new IUnitOfWork.Void<Resource>(){

            public void process(Resource state) throws Exception {
                result.delegate();
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public IScope getFeatureScope(@Nullable XAbstractFeatureCall featureCall) {
        if (featureCall != null) {
            Resource resource = featureCall.eResource();
            if (resource instanceof ISynchronizable) {
                Object object = ((ISynchronizable)resource).getLock();
                synchronized (object) {
                    return this.delegate.getFeatureScope(featureCall);
                }
            }
            return this.delegate.getFeatureScope(featureCall);
        }
        return IScope.NULLSCOPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public IResolvedTypes getResolvedTypesInContextOf(@Nullable EObject context) {
        if (context != null) {
            Resource resource = context.eResource();
            if (resource instanceof ISynchronizable) {
                Object object = ((ISynchronizable)resource).getLock();
                synchronized (object) {
                    return this.delegate.getResolvedTypesInContextOf(context);
                }
            }
            return this.delegate.getResolvedTypesInContextOf(context);
        }
        return IResolvedTypes.NULL;
    }

    @NonNullByDefault
    protected static class LazyResolvedTypes
    extends ForwardingResolvedTypes {
        private final IReentrantTypeResolver resolver;
        private final Resource resource;
        private volatile IResolvedTypes delegate;

        public LazyResolvedTypes(IReentrantTypeResolver resolver, Resource resource) {
            this.resolver = resolver;
            this.resource = resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IResolvedTypes delegate() {
            if (this.delegate == null) {
                Object object = this.getLock();
                synchronized (object) {
                    if (this.delegate == null) {
                        IResolvedTypes result;
                        this.delegate = result = this.resolver.reentrantResolve();
                        return result;
                    }
                }
            }
            return this.delegate;
        }

        protected Object getLock() {
            if (this.resource instanceof ISynchronizable) {
                return ((ISynchronizable)this.resource).getLock();
            }
            return this.resource;
        }
    }
}

