/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.file;

import com.google.common.base.Objects;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.xbase.file.AbstractFileSystemSupport;
import org.eclipse.xtext.xbase.file.WorkspaceConfig;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaIOFileSystemSupport
extends AbstractFileSystemSupport {
    @Inject
    private Provider<WorkspaceConfig> _projectInformationProvider;

    public Provider<WorkspaceConfig> getProjectInformationProvider() {
        return this._projectInformationProvider;
    }

    public void setProjectInformationProvider(Provider<WorkspaceConfig> projectInformationProvider) {
        this._projectInformationProvider = projectInformationProvider;
    }

    public Iterable<? extends Path> getChildren(final Path path) {
        boolean _not;
        List _xblockexpression = null;
        boolean _exists = this.exists(path);
        boolean bl = _not = !_exists;
        if (_not) {
            return CollectionLiterals.emptyList();
        }
        boolean _isFile = this.isFile(path);
        if (_isFile) {
            return CollectionLiterals.emptyList();
        }
        File _javaIOFile = this.getJavaIOFile(path);
        String[] _list = _javaIOFile.list();
        Functions.Function1<String, Path> _function = new Functions.Function1<String, Path>(){

            public Path apply(String it) {
                return path.getAbsolutePath(it);
            }
        };
        _xblockexpression = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_list)), (Functions.Function1)_function);
        return _xblockexpression;
    }

    protected File getJavaIOFile(Path path) {
        Provider<WorkspaceConfig> _projectInformationProvider = this.getProjectInformationProvider();
        WorkspaceConfig _get = (WorkspaceConfig)_projectInformationProvider.get();
        String _absoluteFileSystemPath = _get.getAbsoluteFileSystemPath();
        String _string = path.toString();
        return new File(_absoluteFileSystemPath, _string);
    }

    public boolean exists(Path path) {
        File _javaIOFile = this.getJavaIOFile(path);
        return _javaIOFile.exists();
    }

    public boolean isFolder(Path path) {
        File _javaIOFile = this.getJavaIOFile(path);
        return _javaIOFile.isDirectory();
    }

    public boolean isFile(Path path) {
        File _javaIOFile = this.getJavaIOFile(path);
        return _javaIOFile.isFile();
    }

    public long getLastModification(Path path) {
        File _javaIOFile = this.getJavaIOFile(path);
        return _javaIOFile.lastModified();
    }

    public String getCharset(Path path) {
        IEncodingProvider _encodingProvider = this.getEncodingProvider();
        File _javaIOFile = this.getJavaIOFile(path);
        String _absolutePath = _javaIOFile.getAbsolutePath();
        URI _createFileURI = URI.createFileURI((String)_absolutePath);
        return _encodingProvider.getEncoding(_createFileURI);
    }

    public InputStream getContentsAsStream(Path path) {
        try {
            File _javaIOFile = this.getJavaIOFile(path);
            FileInputStream _fileInputStream = new FileInputStream(_javaIOFile);
            return new BufferedInputStream(_fileInputStream);
        }
        catch (Throwable _t) {
            if (_t instanceof FileNotFoundException) {
                FileNotFoundException exc = (FileNotFoundException)_t;
                String _message = exc.getMessage();
                throw new IllegalArgumentException(_message, exc);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public boolean mkdir(Path path) {
        boolean _notEquals;
        boolean _exists = this.exists(path);
        if (_exists) {
            return false;
        }
        Path parent = path.getParent();
        boolean bl = _notEquals = !Objects.equal((Object)parent, null);
        if (_notEquals) {
            this.mkdir(parent);
        }
        File _javaIOFile = this.getJavaIOFile(path);
        _javaIOFile.mkdir();
        return true;
    }

    public boolean delete(Path path) {
        boolean _not;
        boolean _exists = this.exists(path);
        boolean bl = _not = !_exists;
        if (_not) {
            return false;
        }
        File _javaIOFile = this.getJavaIOFile(path);
        boolean _isDirectory = _javaIOFile.isDirectory();
        if (_isDirectory) {
            try {
                File _javaIOFile_1 = this.getJavaIOFile(path);
                Files.sweepFolder((File)_javaIOFile_1);
            }
            catch (Throwable _t) {
                if (_t instanceof FileNotFoundException) {
                    FileNotFoundException exc = (FileNotFoundException)_t;
                    String _message = exc.getMessage();
                    throw new IllegalArgumentException(_message, exc);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        File _javaIOFile_2 = this.getJavaIOFile(path);
        _javaIOFile_2.delete();
        return true;
    }

    public void setContentsAsStream(final Path path, final InputStream stream) {
        Path _parent = path.getParent();
        this.mkdir(_parent);
        try {
            InputSupplier<InputStream> _function = new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return stream;
                }
            };
            OutputSupplier<BufferedOutputStream> _function_1 = new OutputSupplier<BufferedOutputStream>(){

                public BufferedOutputStream getOutput() throws IOException {
                    File _javaIOFile = JavaIOFileSystemSupport.this.getJavaIOFile(path);
                    FileOutputStream _fileOutputStream = new FileOutputStream(_javaIOFile);
                    return new BufferedOutputStream(_fileOutputStream);
                }
            };
            ByteStreams.copy((InputSupplier)_function, (OutputSupplier)_function_1);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException exc = (IOException)_t;
                String _message = exc.getMessage();
                throw new IllegalArgumentException(_message, exc);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public java.net.URI toURI(Path path) {
        File _javaIOFile = this.getJavaIOFile(path);
        return _javaIOFile.toURI();
    }

    @Override
    public Path getPath(Resource res) {
        URI _uRI;
        ResourceSet _resourceSet = res.getResourceSet();
        URIConverter _uRIConverter = _resourceSet.getURIConverter();
        URI uri = _uRIConverter.normalize(_uRI = res.getURI());
        boolean _isFile = uri.isFile();
        if (_isFile) {
            boolean _not;
            Provider<WorkspaceConfig> _projectInformationProvider = this.getProjectInformationProvider();
            WorkspaceConfig _get = (WorkspaceConfig)_projectInformationProvider.get();
            String _absoluteFileSystemPath = _get.getAbsoluteFileSystemPath();
            File _file = new File(_absoluteFileSystemPath);
            java.net.URI _uRI_1 = _file.toURI();
            String workspacePath = _uRI_1.getPath();
            String _fileString = uri.toFileString();
            File _file_1 = new File(_fileString);
            java.net.URI _uRI_2 = _file_1.toURI();
            String absolutefilePath = _uRI_2.getPath();
            boolean _startsWith = absolutefilePath.startsWith(workspacePath);
            boolean bl = _not = !_startsWith;
            if (_not) {
                throw new IllegalStateException("Couldn't determine file path. The file ('" + absolutefilePath + "') doesn't seem to be contained in the workspace ('" + workspacePath + "')");
            }
            int _length = workspacePath.length();
            String filePath = absolutefilePath.substring(_length);
            String _string = filePath.toString();
            String _plus = "/" + _string;
            return new Path(_plus);
        }
        return null;
    }
}

