/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.scoping.impl.IDelegatingScopeProvider;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopes;
import org.eclipse.xtext.xbase.scoping.batch.IBatchScopeProvider;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.ImplicitlyImportedTypes;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class XbaseBatchScopeProvider
implements IBatchScopeProvider,
IDelegatingScopeProvider {
    @Inject
    private IFeatureScopeSession rootSession;
    @Inject
    private ImplicitlyImportedTypes implicitlyImportedTypes;
    @Inject
    private FeatureScopes featureScopes;
    @Inject
    @Named(value="org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider.delegate")
    private IScopeProvider delegate;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private IImportsConfiguration importsConfig;

    protected IScope delegateGetScope(EObject context, EReference reference) {
        return this.getDelegate().getScope(context, reference);
    }

    public void setDelegate(IScopeProvider delegate) {
        this.delegate = delegate;
    }

    public IScopeProvider getDelegate() {
        return this.delegate;
    }

    public IScope getScope(EObject context, EReference reference) {
        if (context == null || context.eResource() == null || context.eResource().getResourceSet() == null) {
            return IScope.NULLSCOPE;
        }
        if (this.isFeatureCallScope(reference)) {
            if (context instanceof XAbstractFeatureCall) {
                IScope result = this.typeResolver.getFeatureScope((XAbstractFeatureCall)context);
                return result;
            }
            return IScope.NULLSCOPE;
        }
        return this.delegateGetScope(context, reference);
    }

    public IFeatureScopeSession newSession(Resource context) {
        List<JvmType> literalClasses = this.implicitlyImportedTypes.getStaticImportClasses(context);
        List<JvmType> extensionClasses = this.implicitlyImportedTypes.getExtensionClasses(context);
        IFeatureScopeSession result = this.rootSession.addTypesToStaticScope(literalClasses, extensionClasses);
        if (context.getContents().isEmpty() || !(context instanceof XtextResource)) {
            return result;
        }
        XImportSection importSection = this.importsConfig.getImportSection((XtextResource)context);
        if (importSection != null) {
            EList<XImportDeclaration> imports = importSection.getImportDeclarations();
            ArrayList staticFeatureProviders = Lists.newArrayListWithCapacity((int)(imports.size() / 2));
            ArrayList staticExtensionFeatureProviders = Lists.newArrayListWithCapacity((int)(imports.size() / 2));
            ArrayList bogusStaticExtensionFeatureProviders = Lists.newArrayListWithCapacity((int)(imports.size() / 2));
            for (XImportDeclaration _import : imports) {
                if (!_import.isWildcard() || !_import.isStatic()) continue;
                if (_import.isExtension()) {
                    staticExtensionFeatureProviders.add(_import.getImportedType());
                    bogusStaticExtensionFeatureProviders.add(_import.getImportedType());
                    continue;
                }
                staticFeatureProviders.add(_import.getImportedType());
            }
            if (!bogusStaticExtensionFeatureProviders.isEmpty()) {
                result = result.addTypesToStaticScope(bogusStaticExtensionFeatureProviders, Collections.emptyList());
            }
            if (!staticFeatureProviders.isEmpty() || !staticExtensionFeatureProviders.isEmpty()) {
                result = result.addTypesToStaticScope(staticFeatureProviders, staticExtensionFeatureProviders);
            }
        }
        return result;
    }

    protected boolean isTypeScope(EReference reference) {
        return TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(reference.getEReferenceType());
    }

    protected boolean isConstructorCallScope(EReference reference) {
        return reference.getEReferenceType() == TypesPackage.Literals.JVM_CONSTRUCTOR;
    }

    public boolean isFeatureCallScope(EReference reference) {
        return this.featureScopes.isFeatureCallScope(reference);
    }

    protected FeatureScopes getFeatureScopes() {
        return this.featureScopes;
    }

    public boolean isBatchScopeable(EReference reference) {
        return this.isConstructorCallScope(reference) || this.isFeatureCallScope(reference);
    }
}

