/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.scoping.batch.FeatureNames;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.internal.ConstructorBodyComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.DefaultReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.FieldTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.OperationBodyComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.util.AbstractReentrantTypeReferenceProvider;
import org.eclipse.xtext.xbase.typing.IJvmTypeReferenceProvider;
import org.eclipse.xtext.xtype.XComputedTypeReference;

public class LogicalContainerAwareReentrantTypeResolver
extends DefaultReentrantTypeResolver {
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;

    public void initializeFrom(@NonNull EObject root) {
        if (!(root instanceof JvmType)) {
            throw new IllegalArgumentException("only JvmTypes are supported as root by this resolver");
        }
        super.initializeFrom(root);
    }

    protected JvmType getRoot() {
        return (JvmType)super.getRoot();
    }

    protected JvmTypeReference getComputedType(JvmMember member) {
        throw new UnsupportedOperationException("member: " + member);
    }

    protected void prepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession) {
        this.doPrepare(resolvedTypes, featureScopeSession, (JvmIdentifiableElement)this.getRoot());
    }

    protected void doPrepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmIdentifiableElement element) {
        if (element instanceof JvmDeclaredType) {
            this._doPrepare(resolvedTypes, featureScopeSession, (JvmDeclaredType)element);
        } else if (element instanceof JvmConstructor) {
            this._doPrepare(resolvedTypes, (JvmConstructor)element);
        } else if (element instanceof JvmField) {
            this._doPrepare(resolvedTypes, featureScopeSession, (JvmField)element);
        } else if (element instanceof JvmOperation) {
            this._doPrepare(resolvedTypes, featureScopeSession, (JvmOperation)element);
        }
    }

    protected void _doPrepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmDeclaredType type) {
        IFeatureScopeSession childSession = this.addThisAndSuper(featureScopeSession, type);
        EList members = type.getMembers();
        int i = 0;
        while (i < members.size()) {
            this.doPrepare(resolvedTypes, childSession, (JvmIdentifiableElement)members.get(i));
            ++i;
        }
    }

    protected void _doPrepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmField field) {
        if (field.getType() != null) {
            resolvedTypes.setType((JvmIdentifiableElement)field, field.getType());
        } else {
            JvmTypeReference reference = this.createComputedTypeReference(resolvedTypes, featureScopeSession, (JvmMember)field);
            field.setType(reference);
        }
    }

    protected void _doPrepare(ResolvedTypes resolvedTypes, JvmConstructor constructor) {
        JvmDeclaredType producedType = constructor.getDeclaringType();
        JvmParameterizedTypeReference asReference = this.getServices().getTypeReferences().createTypeRef((JvmType)producedType, new JvmTypeReference[0]);
        resolvedTypes.setType((JvmIdentifiableElement)constructor, (JvmTypeReference)asReference);
    }

    protected void _doPrepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmOperation operation) {
        if (operation.getReturnType() != null) {
            resolvedTypes.setType((JvmIdentifiableElement)operation, operation.getReturnType());
        } else {
            JvmTypeReference reference = this.createComputedTypeReference(resolvedTypes, featureScopeSession, (JvmMember)operation);
            operation.setReturnType(reference);
        }
    }

    protected JvmTypeReference createComputedTypeReference(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmMember member) {
        XComputedTypeReference result = this.getServices().getXtypeFactory().createXComputedTypeReference();
        result.setTypeProvider(this.createTypeProvider(resolvedTypes, featureScopeSession, member));
        resolvedTypes.setType((JvmIdentifiableElement)member, (JvmTypeReference)result);
        return result;
    }

    protected IJvmTypeReferenceProvider createTypeProvider(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmMember member) {
        return new DemandTypeReferenceProvider(member, resolvedTypes, featureScopeSession, this);
    }

    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession session) {
        this.prepare(resolvedTypes, session);
        super.computeTypes(resolvedTypes, session);
        this.processResult(resolvedTypes);
    }

    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, EObject element) {
        if (element instanceof JvmConstructor) {
            this._computeTypes(resolvedTypes, featureScopeSession, (JvmConstructor)element);
        } else if (element instanceof JvmField) {
            this._computeTypes(resolvedTypes, featureScopeSession, (JvmField)element);
        } else if (element instanceof JvmOperation) {
            this._computeTypes(resolvedTypes, featureScopeSession, (JvmOperation)element);
        } else if (element instanceof JvmDeclaredType) {
            this._computeTypes(resolvedTypes, featureScopeSession, (JvmDeclaredType)element);
        } else {
            super.computeTypes(resolvedTypes, featureScopeSession, element);
        }
    }

    protected void _computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmField field) {
        FieldTypeComputationState state = new FieldTypeComputationState(resolvedTypes, featureScopeSession, field, this);
        state.computeTypes();
        this.computeAnnotationTypes(resolvedTypes, featureScopeSession, (JvmAnnotationTarget)field);
    }

    protected void _computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmConstructor constructor) {
        ConstructorBodyComputationState state = new ConstructorBodyComputationState(resolvedTypes, featureScopeSession, constructor, this);
        state.computeTypes();
        this.computeAnnotationTypes(resolvedTypes, featureScopeSession, (JvmAnnotationTarget)constructor);
    }

    protected void _computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmOperation operation) {
        OperationBodyComputationState state = new OperationBodyComputationState(resolvedTypes, featureScopeSession, operation, this);
        state.computeTypes();
        this.computeAnnotationTypes(resolvedTypes, featureScopeSession, (JvmAnnotationTarget)operation);
    }

    protected void computeAnnotationTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmAnnotationTarget annotable) {
        if (!annotable.getAnnotations().isEmpty()) {
            throw new UnsupportedOperationException(resolvedTypes + " " + annotable + " " + featureScopeSession);
        }
    }

    protected void _computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmDeclaredType type) {
        StackedResolvedTypes childResolvedTypes = new StackedResolvedTypes(resolvedTypes);
        JvmTypeReference superType = this.getExtendedClass(type);
        IFeatureScopeSession childSession = this.addThisAndSuper(featureScopeSession, type, superType);
        if (superType != null) {
            childResolvedTypes.reassignType((JvmIdentifiableElement)superType.getType(), superType);
        }
        childResolvedTypes.reassignType((JvmIdentifiableElement)type, superType);
        EList members = type.getMembers();
        int i = 0;
        while (i < members.size()) {
            this.computeTypes(childResolvedTypes, childSession, (EObject)members.get(i));
            ++i;
        }
        this.computeAnnotationTypes(childResolvedTypes, featureScopeSession, (JvmAnnotationTarget)type);
        childResolvedTypes.mergeIntoParent();
    }

    protected IFeatureScopeSession addThisAndSuper(IFeatureScopeSession session, JvmDeclaredType type) {
        JvmTypeReference superType = this.getExtendedClass(type);
        return this.addThisAndSuper(session, type, superType);
    }

    protected IFeatureScopeSession addThisAndSuper(IFeatureScopeSession session, JvmDeclaredType thisType, JvmTypeReference superType) {
        IFeatureScopeSession childSession = session;
        if (superType != null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)FeatureNames.THIS, (Object)thisType);
            builder.put((Object)FeatureNames.SUPER, (Object)superType.getType());
            childSession = session.addLocalElements((Map<QualifiedName, JvmIdentifiableElement>)builder.build());
        } else {
            childSession = session.addLocalElement(FeatureNames.THIS, (JvmIdentifiableElement)thisType);
        }
        return childSession;
    }

    public JvmTypeReference getExtendedClass(JvmDeclaredType type) {
        for (JvmTypeReference candidate : type.getSuperTypes()) {
            if (!(candidate.getType() instanceof JvmGenericType) || ((JvmGenericType)candidate.getType()).isInterface()) continue;
            return candidate;
        }
        return null;
    }

    protected void processResult(ResolvedTypes resolvedTypes) {
    }

    protected ILogicalContainerProvider getLogicalContainerProvider() {
        return this.logicalContainerProvider;
    }

    public static class DemandTypeReferenceProvider
    extends AbstractReentrantTypeReferenceProvider {
        private final JvmMember member;
        private final ResolvedTypes resolvedTypes;
        private final LogicalContainerAwareReentrantTypeResolver resolver;
        private final IFeatureScopeSession featureScopeSession;

        public DemandTypeReferenceProvider(JvmMember member, ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, LogicalContainerAwareReentrantTypeResolver resolver) {
            this.member = member;
            this.resolvedTypes = resolvedTypes;
            this.featureScopeSession = featureScopeSession;
            this.resolver = resolver;
        }

        protected JvmTypeReference doGetTypeReference() {
            this.resolver.computeTypes(this.resolvedTypes, this.featureScopeSession, (EObject)this.member);
            return this.resolver.getComputedType(this.member);
        }
    }
}

