/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.smap;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.debug.IStratumBreakpointSupport;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StratumBreakpointAdapterFactory
implements IAdapterFactory,
IToggleBreakpointsTargetExtension {
    private static final Logger log = Logger.getLogger(StratumBreakpointAdapterFactory.class);
    @Inject
    private IResourceServiceProvider.Registry providerRegistry;
    @Inject
    private IStorage2UriMapper uriMapper;

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof XtextEditor) {
            return this;
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IToggleBreakpointsTargetExtension.class};
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (!(part instanceof XtextEditor) || !(selection instanceof ITextSelection)) {
            return;
        }
        try {
            XtextEditor xtextEditor = (XtextEditor)part;
            IResource res = xtextEditor.getResource();
            int offset = ((TextSelection)selection).getOffset();
            final int line = xtextEditor.getDocument().getLineOfOffset(offset) + 1;
            IJavaStratumLineBreakpoint existingBreakpoint = this.findExistingBreakpoint(res, line);
            if (existingBreakpoint != null) {
                existingBreakpoint.delete();
                return;
            }
            URI uri = this.uriMapper.getUri((IStorage)res);
            IResourceServiceProvider serviceProvider = this.providerRegistry.getResourceServiceProvider(uri);
            if (serviceProvider == null) {
                return;
            }
            final IStratumBreakpointSupport breakpointSupport = (IStratumBreakpointSupport)serviceProvider.get(IStratumBreakpointSupport.class);
            if (breakpointSupport == null) {
                return;
            }
            boolean isBreakpointLocation = (Boolean)xtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

                public Boolean exec(XtextResource state) throws Exception {
                    return breakpointSupport.isValidLineForBreakPoint(state, line);
                }
            });
            if (!isBreakpointLocation) {
                return;
            }
            String types = (String)xtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<String, XtextResource>(){

                public String exec(XtextResource state) throws Exception {
                    return StratumBreakpointAdapterFactory.this.getClassNamePattern(state);
                }
            });
            if (types == null) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Types the breakpoint listens for : " + types));
            }
            IRegion information = xtextEditor.getDocument().getLineInformation(line - 1);
            int charStart = information.getOffset();
            int charEnd = information.getOffset() + information.getLength();
            String shortName = ((LanguageInfo)serviceProvider.get(LanguageInfo.class)).getShortName();
            final IJavaStratumLineBreakpoint breakpoint = JDIDebugModel.createStratumBreakpoint((IResource)res, (String)shortName, null, null, (String)types, (int)line, (int)charStart, (int)charEnd, (int)0, (boolean)true, null);
            final IMarker marker = breakpoint.getMarker();
            final IWorkspace ws = marker.getResource().getWorkspace();
            IResourceChangeListener listener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    IResourceDelta delta;
                    if (!marker.exists()) {
                        ws.removeResourceChangeListener((IResourceChangeListener)this);
                    }
                    if ((delta = event.getDelta()) == null) {
                        return;
                    }
                    IResourceDelta findMember = event.getDelta().findMember(marker.getResource().getFullPath());
                    if (findMember == null) {
                        return;
                    }
                    IResource res = findMember.getResource();
                    if (res == null || !res.exists()) {
                        return;
                    }
                    if (event.getType() == 4) {
                        ws.removeResourceChangeListener((IResourceChangeListener)this);
                    } else if (event.getType() == 1 && (findMember.getFlags() & 0x100) != 0) {
                        String classNamePattern = StratumBreakpointAdapterFactory.this.getClassNamePattern(event.getResource());
                        try {
                            breakpoint.getMarker().setAttribute("org.eclipse.jdt.debug.pattern", (Object)classNamePattern);
                        }
                        catch (CoreException e) {
                            log.info((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            };
            ws.addResourceChangeListener(listener, 5);
        }
        catch (BadLocationException e) {
            log.info((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected IJavaStratumLineBreakpoint findExistingBreakpoint(IResource res, int line) throws CoreException {
        IBreakpoint[] breakpoints;
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = breakpoints = manager.getBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaStratumLineBreakpoint stratumBreakpoint;
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof IJavaStratumLineBreakpoint && breakpoint.getMarker().getResource().equals((Object)res) && (stratumBreakpoint = (IJavaStratumLineBreakpoint)breakpoint).getLineNumber() == line) {
                return stratumBreakpoint;
            }
            ++n2;
        }
        return null;
    }

    protected String getClassNamePattern(IResource res) {
        if (!(res instanceof IStorage)) {
            return null;
        }
        URI uri = this.uriMapper.getUri((IStorage)res);
        IResourceServiceProvider provider = this.providerRegistry.getResourceServiceProvider(uri);
        IResourceSetProvider resourceSetProvider = (IResourceSetProvider)provider.get(IResourceSetProvider.class);
        ResourceSet set = resourceSetProvider.get(res.getProject());
        Resource resource = set.getResource(uri, true);
        if (resource instanceof XtextResource) {
            return this.getClassNamePattern((XtextResource)resource);
        }
        return null;
    }

    protected String getClassNamePattern(XtextResource state) {
        TreeIterator contents = EcoreUtil.getAllContents((Resource)state, (boolean)false);
        StringBuilder sb = new StringBuilder();
        while (contents.hasNext()) {
            Object next = contents.next();
            if (!(next instanceof JvmDeclaredType)) continue;
            JvmDeclaredType type = (JvmDeclaredType)next;
            sb.append(type.getQualifiedName()).append("*");
            sb.append(",");
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.substring(0, sb.length() - 1);
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }
}

