/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.contentassist;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendImport;
import org.eclipse.xtext.common.types.xtext.ui.JdtTypesProposalProvider;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.xbase.conversion.XbaseQualifiedNameValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportingTypesProposalProvider
extends JdtTypesProposalProvider {
    @Inject
    private XbaseQualifiedNameValueConverter qualifiedNameValueConverter;

    protected ConfigurableCompletionProposal.IReplacementTextApplier createTextApplier(ContentAssistContext context, IScope typeScope, IQualifiedNameConverter qualifiedNameConverter, IValueConverter<String> valueConverter) {
        if (context.getCurrentModel() instanceof XtendImport) {
            return super.createTextApplier(context, typeScope, qualifiedNameConverter, valueConverter);
        }
        return new FQNImporter((Resource)context.getResource(), context.getViewer(), typeScope, qualifiedNameConverter, valueConverter, this.qualifiedNameValueConverter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FQNImporter
    extends JdtTypesProposalProvider.FQNShortener {
        private final ITextViewer viewer;
        private final XbaseQualifiedNameValueConverter importConverter;

        public FQNImporter(Resource context, ITextViewer viewer, IScope scope, IQualifiedNameConverter qualifiedNameConverter, IValueConverter<String> valueConverter, XbaseQualifiedNameValueConverter importConverter) {
            super(context, scope, qualifiedNameConverter, valueConverter);
            this.viewer = viewer;
            this.importConverter = importConverter;
        }

        public void apply(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
            XtendFile file;
            String replacementString;
            String proposalReplacementString;
            String typeName = proposalReplacementString = proposal.getReplacementString();
            if (this.valueConverter != null) {
                typeName = (String)this.valueConverter.toValue(proposalReplacementString, null);
            }
            if (!proposalReplacementString.equals(replacementString = this.getActualReplacementString(proposal))) {
                QualifiedName shortQualifiedName;
                String shortTypeName = replacementString;
                if (this.valueConverter != null) {
                    shortTypeName = (String)this.valueConverter.toValue(replacementString, null);
                }
                if ((shortQualifiedName = this.qualifiedNameConverter.toQualifiedName(shortTypeName)).getSegmentCount() == 1) {
                    proposal.setCursorPosition(replacementString.length());
                    document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), replacementString);
                    return;
                }
            }
            XtendClass clazz = (file = (XtendFile)this.context.getContents().get(0)).getXtendClasses().isEmpty() ? null : (XtendClass)file.getXtendClasses().get(0);
            QualifiedName qualifiedName = this.qualifiedNameConverter.toQualifiedName(typeName);
            if (qualifiedName.getSegmentCount() == 1) {
                proposal.setCursorPosition(proposalReplacementString.length());
                document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), proposalReplacementString);
                return;
            }
            IEObjectDescription description = this.scope.getSingleElement(qualifiedName.skipFirst(qualifiedName.getSegmentCount() - 1));
            if (description != null) {
                proposal.setCursorPosition(proposalReplacementString.length());
                document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), proposalReplacementString);
                return;
            }
            String shortName = qualifiedName.getLastSegment();
            int topPixel = -1;
            StyledText widget = this.viewer.getTextWidget();
            if (widget != null) {
                topPixel = widget.getTopPixel();
            }
            ITextViewerExtension viewerExtension = null;
            if (this.viewer instanceof ITextViewerExtension) {
                viewerExtension = (ITextViewerExtension)this.viewer;
                viewerExtension.setRedraw(false);
            }
            DocumentRewriteSession rewriteSession = null;
            String lineSeparator = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            try {
                ICompositeNode node;
                if (document instanceof IDocumentExtension4) {
                    rewriteSession = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
                }
                int offset = 0;
                boolean startWithLineBreak = true;
                boolean endWithLineBreak = false;
                if (file.getImports().isEmpty()) {
                    startWithLineBreak = false;
                    if (clazz == null) {
                        offset = document.getLength();
                    } else {
                        node = NodeModelUtils.getNode((EObject)clazz);
                        if (node == null) {
                            throw new IllegalStateException("node may not be null");
                        }
                        offset = node.getOffset();
                        endWithLineBreak = true;
                    }
                } else {
                    node = NodeModelUtils.getNode((EObject)((EObject)file.getImports().get(file.getImports().size() - 1)));
                    if (node == null) {
                        throw new IllegalStateException("node may not be null");
                    }
                    offset = node.getOffset() + node.getLength();
                }
                offset = Math.min(proposal.getReplacementOffset(), offset);
                String escapedShortname = shortName;
                if (this.valueConverter != null) {
                    escapedShortname = this.valueConverter.toString((Object)shortName);
                }
                proposal.setCursorPosition(escapedShortname.length());
                document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), escapedShortname);
                String importStatement = String.valueOf(startWithLineBreak ? String.valueOf(lineSeparator) + "import " : "import ") + this.importConverter.toString(typeName);
                if (endWithLineBreak) {
                    importStatement = String.valueOf(importStatement) + lineSeparator;
                    importStatement = String.valueOf(importStatement) + lineSeparator;
                }
                document.replace(offset, 0, importStatement.toString());
                proposal.setCursorPosition(proposal.getCursorPosition() + importStatement.length());
                if (widget != null) {
                    int additionalTopPixel = 0;
                    if (startWithLineBreak) {
                        additionalTopPixel += widget.getLineHeight();
                    }
                    if (endWithLineBreak) {
                        additionalTopPixel += 2 * widget.getLineHeight();
                    }
                    widget.setTopPixel(topPixel + additionalTopPixel);
                }
            }
            finally {
                if (rewriteSession != null) {
                    ((IDocumentExtension4)document).stopRewriteSession(rewriteSession);
                }
                if (viewerExtension != null) {
                    viewerExtension.setRedraw(true);
                }
            }
        }
    }
}

