/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.quickfix;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.editor.quickfix.ReplaceModification;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xtend2.ui.edit.OrganizeImportsHandler;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtend2.xtend2.XtendImport;

public class Xtend2QuickfixProvider
extends DefaultQuickfixProvider {
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private OrganizeImportsHandler organizeImports;

    public void createLinkingIssueResolutions(final Issue issue, final IssueResolutionAcceptor issueResolutionAcceptor) {
        IModificationContext modificationContext = this.getModificationContextFactory().createModificationContext(issue);
        final IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        if (xtextDocument != null) {
            xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource state) throws Exception {
                    EObject target = state.getEObject(issue.getUriToProblem().fragment());
                    EReference reference = Xtend2QuickfixProvider.this.getUnresolvedEReference(issue, target);
                    if (reference == null) {
                        return;
                    }
                    String issueString = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
                    IScope scope = Xtend2QuickfixProvider.this.getScopeProvider().getScope(target, reference);
                    boolean useJavaSearch = false;
                    if (TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(reference.getEReferenceType())) {
                        useJavaSearch = true;
                    }
                    if (TypesPackage.Literals.JVM_CONSTRUCTOR.isSuperTypeOf(reference.getEReferenceType())) {
                        useJavaSearch = true;
                    }
                    if (useJavaSearch) {
                        scope = Xtend2QuickfixProvider.this.getImportedTypesScope(target, issueString, scope);
                    }
                    ArrayList discardedDescriptions = Lists.newArrayList();
                    HashSet qualifiedNames = Sets.newHashSet();
                    int addedDescriptions = 0;
                    int checkedDescriptions = 0;
                    for (IEObjectDescription referableElement : Xtend2QuickfixProvider.this.queryScope(scope)) {
                        String referableElementQualifiedName = Xtend2QuickfixProvider.this.getQualifiedNameConverter().toString(referableElement.getQualifiedName());
                        if (useJavaSearch || Xtend2QuickfixProvider.this.getSimilarityMatcher().isSimilar(issueString, Xtend2QuickfixProvider.this.getQualifiedNameConverter().toString(referableElement.getName()))) {
                            ++addedDescriptions;
                            this.createResolution(issueString, referableElement);
                            qualifiedNames.add(referableElementQualifiedName);
                        } else if (qualifiedNames.add(referableElementQualifiedName)) {
                            discardedDescriptions.add(referableElement);
                        }
                        if (++checkedDescriptions > 100) break;
                    }
                    if (discardedDescriptions.size() + addedDescriptions <= 5) {
                        for (IEObjectDescription referableElement : discardedDescriptions) {
                            this.createResolution(issueString, referableElement);
                        }
                    }
                }

                public void createResolution(String issueString, IEObjectDescription solution) {
                    String replacement = Xtend2QuickfixProvider.this.getQualifiedNameConverter().toString(solution.getName());
                    String replaceLabel = Xtend2QuickfixProvider.this.fixCrossReferenceLabel(issueString, replacement);
                    issueResolutionAcceptor.accept(issue, replaceLabel, replaceLabel, Xtend2QuickfixProvider.this.fixCrossReferenceImage(issueString, replacement), (IModification)new ReplaceModification(issue, replacement));
                }
            });
        }
    }

    protected IScope getImportedTypesScope(EObject model, String misspelled, IScope actualScope) {
        if (model == null || model.eResource() == null || model.eResource().getResourceSet() == null) {
            return IScope.NULLSCOPE;
        }
        try {
            IJavaProject javaProject = this.projectProvider.getJavaProject(model.eResource().getResourceSet());
            IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
            return this.getImportedTypesScope(searchScope, model, misspelled, actualScope);
        }
        catch (JavaModelException e) {
            return IScope.NULLSCOPE;
        }
    }

    protected IScope getImportedTypesScope(IJavaSearchScope scope, EObject model, final String misspelled, final IScope actualScope) throws JavaModelException {
        XtendFile xtendFile = (XtendFile)EcoreUtil2.getContainerOfType((EObject)model, XtendFile.class);
        HashSet visiblePackages = Sets.newHashSet((Object[])new String[]{"java.lang"});
        visiblePackages.add("");
        if (xtendFile.getPackage() != null) {
            visiblePackages.add(xtendFile.getPackage());
        }
        HashSet importedTypes = Sets.newHashSet();
        final HashSet seen = Sets.newHashSet();
        for (XtendImport importedNamespace : xtendFile.getImports()) {
            if (importedNamespace.getImportedNamespace() == null) continue;
            String importedAsString = importedNamespace.getImportedNamespace();
            if (importedNamespace.isWildcard()) {
                importedAsString = importedAsString.substring(0, importedAsString.length() - 2);
                if (!importedNamespace.isStatic()) {
                    visiblePackages.add(importedAsString);
                    continue;
                }
                importedTypes.add(importedAsString);
                continue;
            }
            importedTypes.add(importedAsString);
        }
        SearchEngine searchEngine = new SearchEngine();
        final ArrayList validProposals = Lists.newArrayList();
        for (String importedType : importedTypes) {
            QualifiedName qualifiedName;
            Iterator iterator;
            if (validProposals.size() > 5 || !seen.add(importedType)) continue;
            int dot = importedType.lastIndexOf(46);
            if (dot != -1) {
                importedType = importedType.substring(dot + 1);
            }
            if (!this.isSimilarTypeName(misspelled, importedType) || !(iterator = actualScope.getElements(qualifiedName = this.getQualifiedNameConverter().toQualifiedName(importedType)).iterator()).hasNext()) continue;
            IEObjectDescription element = (IEObjectDescription)iterator.next();
            validProposals.add(new AliasedEObjectDescription(qualifiedName, element));
        }
        for (String visiblePackage : visiblePackages) {
            if (validProposals.size() > 5) continue;
            searchEngine.searchAllTypeNames(visiblePackage.toCharArray(), 0, null, 0, 0, scope, new TypeNameRequestor(){

                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                    StringBuilder typeNameBuilder = new StringBuilder(simpleTypeName.length);
                    char[][] cArray = enclosingTypeNames;
                    int n = enclosingTypeNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char[] enclosingType = cArray[n2];
                        typeNameBuilder.append(enclosingType);
                        typeNameBuilder.append('$');
                        ++n2;
                    }
                    typeNameBuilder.append(simpleTypeName);
                    String typeName = typeNameBuilder.toString();
                    if (Xtend2QuickfixProvider.this.isSimilarTypeName(misspelled, typeName)) {
                        QualifiedName qualifiedName;
                        StringBuilder fqName = new StringBuilder(packageName.length + simpleTypeName.length + 1);
                        if (packageName.length != 0) {
                            fqName.append(packageName);
                            fqName.append('.');
                        }
                        Object object = enclosingTypeNames;
                        int n3 = enclosingTypeNames.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            char[] enclosingType = object[n4];
                            fqName.append(enclosingType);
                            fqName.append('$');
                            ++n4;
                        }
                        fqName.append(simpleTypeName);
                        String fqNameAsString = fqName.toString();
                        if (seen.add(fqNameAsString) && (object = (Object)actualScope.getElements(qualifiedName = Xtend2QuickfixProvider.this.getQualifiedNameConverter().toQualifiedName(typeName)).iterator()).hasNext()) {
                            IEObjectDescription element = (IEObjectDescription)object.next();
                            validProposals.add(new AliasedEObjectDescription(qualifiedName, element));
                        }
                    }
                }
            }, 3, (IProgressMonitor)new NullProgressMonitor(){

                public boolean isCanceled() {
                    return validProposals.size() > 5;
                }
            });
        }
        return new SimpleScope((Iterable)validProposals);
    }

    protected boolean isSimilarTypeName(String s0, String s1) {
        double levenshteinDistance = StringUtils.getLevenshteinDistance((String)s0, (String)s1);
        return levenshteinDistance <= 3.0;
    }

    @Fix(value="org.eclipse.xtext.xtend2.validation.IssueCodes.inconsistent_indentation")
    public void fixIndentation(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Correct indentation", "Correctly indents this line in this rich string", "fix_indent.gif", new IModification(){

            public void apply(IModificationContext context) throws Exception {
                context.getXtextDocument().replace(issue.getOffset().intValue(), issue.getLength().intValue(), issue.getData()[0]);
            }
        });
    }

    @Fix(value="org.eclipse.xtext.xtend2.validation.IssueCodes.import_duplicate")
    public void fixDuplicateImport(Issue issue, IssueResolutionAcceptor acceptor) {
        this.organizeImports(issue, acceptor);
    }

    @Fix(value="org.eclipse.xtext.xtend2.validation.IssueCodes.import_wildcard_deprecated")
    public void fixDuplicateWildcardUse(Issue issue, IssueResolutionAcceptor acceptor) {
        this.organizeImports(issue, acceptor);
    }

    @Fix(value="org.eclipse.xtext.xtend2.validation.IssueCodes.import_unsued")
    public void fixUnusedImport(Issue issue, IssueResolutionAcceptor acceptor) {
        this.organizeImports(issue, acceptor);
    }

    protected void organizeImports(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Organize Imports.", "Organizes the whole import section. Removes wildcard imports as well as duplicates and unused ones.", "fix_indent.gif", new IModification(){

            public void apply(IModificationContext context) throws Exception {
                Xtend2QuickfixProvider.this.organizeImports.doOrganizeImports(context.getXtextDocument());
            }
        });
    }
}

