/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.grammaranalysis.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.serializer.analysis.Context2NameFunction;
import org.eclipse.xtext.util.XtextSwitch;

public class GrammarElementTitleSwitch
extends XtextSwitch<String>
implements Function<AbstractElement, String> {
    protected boolean showActionAsRuleCall = false;
    protected boolean showAssignment = false;
    protected boolean showCardinality = true;
    protected boolean showQualified = false;
    protected boolean showRule = false;
    protected String valueForNull = "(null)";

    protected String addAssignemnt(String result, AbstractElement ele) {
        if (!this.showAssignment) {
            return result;
        }
        Assignment ass = GrammarUtil.containingAssignment(ele);
        result = ass != null ? String.valueOf(ass.getFeature()) + ass.getOperator() + result : result;
        return this.addQualified(result, ele);
    }

    protected String addCrossRef(String result, AbstractElement ele) {
        if (!this.showAssignment) {
            return result;
        }
        CrossReference cr = GrammarUtil.containingCrossReference(ele);
        if (cr == null) {
            return result;
        }
        String name = cr.getType() != null && cr.getType().getClassifier() != null ? cr.getType().getClassifier().getName() : "null";
        return "[" + name + "|" + result + "]";
    }

    protected String addCrossRefOrAssignemnt(String result, AbstractElement ele) {
        return this.addAssignemnt(this.addCrossRef(result, ele), ele);
    }

    protected String addQualified(String result, AbstractElement ele) {
        if (!this.showQualified && !this.showRule) {
            return result;
        }
        AbstractRule rule = GrammarUtil.containingRule(ele);
        if (!this.showQualified) {
            return String.valueOf(result) + ":" + rule.getName();
        }
        GrammarElementTitleSwitch others = this.copy();
        others.showQualified = false;
        others.showRule = false;
        ArrayList elementsWithSameName = Lists.newArrayList();
        for (AbstractElement candidate : EcoreUtil2.getAllContentsOfType(rule, ele.getClass())) {
            if (candidate != ele && !result.equals(others.doSwitch(candidate))) continue;
            elementsWithSameName.add(candidate);
        }
        if (elementsWithSameName.size() < 2) {
            if (this.showRule) {
                return String.valueOf(rule.getName()) + ":" + result;
            }
            return result;
        }
        HashMap nodes = Maps.newHashMap();
        for (AbstractElement collision : elementsWithSameName) {
            CompoundElement current = EcoreUtil2.getContainerOfType(collision, CompoundElement.class);
            Node node = new Node(null, collision == ele ? result : "");
            while (current instanceof CompoundElement) {
                CompoundElement container = current;
                Node cntNode = (Node)nodes.get(container);
                if (cntNode == null) {
                    cntNode = new Node(container, null);
                    nodes.put(container, cntNode);
                }
                if (!cntNode.children.contains(node)) {
                    cntNode.children.add(node);
                }
                node = cntNode;
                current = current.eContainer();
            }
        }
        if (this.showRule) {
            return String.valueOf(rule.getName()) + ":" + nodes.get(rule.getAlternatives());
        }
        return ((Node)nodes.get(rule.getAlternatives())).toString();
    }

    public String apply(AbstractElement from) {
        return this.doSwitch(from);
    }

    protected String card(AbstractElement ele) {
        if (!this.showCardinality) {
            return "";
        }
        return ele.getCardinality() == null ? "" : ele.getCardinality();
    }

    @Override
    public String caseAbstractElement(AbstractElement object) {
        return String.valueOf(object.eClass().getName()) + this.card(object);
    }

    @Override
    public String caseAbstractRule(AbstractRule object) {
        String classifier = object.getType().getClassifier().getName();
        if (object.getName().equals(classifier)) {
            return String.valueOf(object.getName()) + ":";
        }
        return String.valueOf(object.getName()) + " returns " + classifier + ":";
    }

    @Override
    public String caseAction(Action object) {
        String result;
        String f = object.getFeature();
        String o = object.getOperator();
        String string = o = o == null ? "" : o;
        if (this.showActionAsRuleCall && f != null) {
            result = String.valueOf(f) + o + new Context2NameFunction().apply(object) + this.card(object);
        } else {
            String t = object.getType() != null && object.getType().getClassifier() != null ? object.getType().getClassifier().getName() : "null";
            t = t == null ? "" : t;
            f = f == null ? "" : "." + f;
            result = "{" + t + f + o + "}" + this.card(object);
        }
        return this.addQualified(result, object);
    }

    @Override
    public String caseAlternatives(Alternatives object) {
        return "\\|" + this.card(object);
    }

    @Override
    public String caseAssignment(Assignment object) {
        String result = String.valueOf(object.getFeature()) + object.getOperator() + " " + this.card(object);
        return this.addQualified(result, object);
    }

    @Override
    public String caseCrossReference(CrossReference object) {
        String cr = "[" + object.getType().getClassifier().getName() + "]";
        return String.valueOf(this.addAssignemnt(cr, object)) + this.card(object);
    }

    @Override
    public String caseGroup(Group object) {
        return "( )" + this.card(object);
    }

    @Override
    public String caseKeyword(Keyword object) {
        return String.valueOf(this.addCrossRefOrAssignemnt("'" + object.getValue() + "'", object)) + this.card(object);
    }

    @Override
    public String caseRuleCall(RuleCall object) {
        return String.valueOf(this.addCrossRefOrAssignemnt(object.getRule().getName(), object)) + this.card(object);
    }

    @Override
    public String caseUnorderedGroup(UnorderedGroup object) {
        return "\\&" + this.card(object);
    }

    protected GrammarElementTitleSwitch copy() {
        GrammarElementTitleSwitch result = new GrammarElementTitleSwitch();
        result.showActionAsRuleCall = this.showActionAsRuleCall;
        result.showAssignment = this.showAssignment;
        result.showCardinality = this.showCardinality;
        result.showQualified = this.showQualified;
        result.showRule = this.showRule;
        return result;
    }

    @Override
    public String defaultCase(EObject object) {
        return object.eClass().getName();
    }

    public String doSwitch(EObject theEObject) {
        if (theEObject == null) {
            return this.valueForNull;
        }
        return (String)super.doSwitch(theEObject);
    }

    public GrammarElementTitleSwitch hideCardinality() {
        this.showCardinality = false;
        return this;
    }

    public GrammarElementTitleSwitch setValueForNull(String value) {
        this.valueForNull = value;
        return this;
    }

    public GrammarElementTitleSwitch showActionsAsRuleCalls() {
        this.showActionAsRuleCall = true;
        return this;
    }

    public GrammarElementTitleSwitch showAssignments() {
        this.showAssignment = true;
        return this;
    }

    public GrammarElementTitleSwitch showQualified() {
        this.showQualified = true;
        return this;
    }

    public GrammarElementTitleSwitch showRule() {
        this.showRule = true;
        return this;
    }

    protected static class Node {
        protected List<Node> children = Lists.newArrayList();
        protected CompoundElement compound;
        protected String text;

        public Node(CompoundElement compound, String text) {
            this.compound = compound;
            this.text = text;
        }

        public String toString() {
            if (this.text != null) {
                return this.text;
            }
            if (this.children.size() == 1) {
                return this.children.get(0).toString();
            }
            if (this.compound instanceof Group) {
                return "(" + Joiner.on((String)" ").join(this.children) + ")";
            }
            if (this.compound instanceof UnorderedGroup) {
                return "(" + Joiner.on((String)"&").join(this.children) + ")";
            }
            if (this.compound instanceof Alternatives) {
                return "(" + Joiner.on((String)"|").join(this.children) + ")";
            }
            return "";
        }
    }
}

