/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.graph;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xtext.ui.graph.RailroadView;
import org.eclipse.xtext.xtext.ui.graph.actions.RailroadSelectionLinker;
import org.eclipse.xtext.xtext.ui.graph.trafo.Xtext2RailroadTransformer;

@Singleton
public class RailroadSynchronizer
implements IPartListener,
IXtextModelListener {
    @Inject
    private RailroadView view;
    @Inject
    private Xtext2RailroadTransformer transformer;
    @Inject
    private RailroadSelectionLinker selectionLinker;
    private IXtextDocument lastActiveDocument;

    public void start(IWorkbenchPartSite site) {
        this.updateView((IWorkbenchPart)site.getPage().getActiveEditor());
        site.getWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
    }

    public void stop(IWorkbenchPartSite site) {
        site.getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
        this.lastActiveDocument = null;
    }

    public void partActivated(IWorkbenchPart part) {
        this.updateView(part);
    }

    private void updateView(IWorkbenchPart part) {
        XtextEditor xtextEditor;
        IXtextDocument xtextDocument;
        if (part instanceof XtextEditor && (xtextDocument = (xtextEditor = (XtextEditor)part).getDocument()) != this.lastActiveDocument) {
            this.selectionLinker.setXtextEditor(xtextEditor);
            IFigure contents = (IFigure)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<IFigure, XtextResource>(){

                public IFigure exec(XtextResource resource) throws Exception {
                    return RailroadSynchronizer.this.createFigure(resource);
                }
            });
            if (contents != null) {
                this.view.setContents(contents);
                if (this.lastActiveDocument != null) {
                    this.lastActiveDocument.removeModelListener((IXtextModelListener)this);
                }
                this.lastActiveDocument = xtextDocument;
                this.lastActiveDocument.addModelListener((IXtextModelListener)this);
            }
        }
    }

    private IFigure createFigure(XtextResource state) {
        EList contents = state.getContents();
        if (!contents.isEmpty()) {
            EObject rootObject = (EObject)contents.get(0);
            return this.transformer.transform(rootObject);
        }
        return null;
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void modelChanged(XtextResource resource) {
        this.view.setContents(this.createFigure(resource));
    }

    @Deprecated
    public Font getFont() {
        return null;
    }
}

