/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.AbstractTypeReferencePairWalker;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameterPreservingSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class DeferredTypeParameterHintCollector
extends AbstractTypeReferencePairWalker {
    public DeferredTypeParameterHintCollector(ITypeReferenceOwner owner) {
        super(owner);
    }

    @Override
    protected TypeParameterSubstitutor<?> createTypeParameterSubstitutor(Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping) {
        return new UnboundTypeParameterPreservingSubstitutor(mapping, this.getOwner());
    }

    protected LightweightTypeReference copy(UnboundTypeReference reference) {
        return reference.copyInto(this.getOwner());
    }

    @Override
    protected AbstractTypeReferencePairWalker.UnboundTypeReferenceTraverser createUnboundTypeReferenceTraverser() {
        return new UnboundTypeParameterHintCollector();
    }

    @Override
    protected AbstractTypeReferencePairWalker.CompoundTypeReferenceTraverser createCompoundTypeReferenceTraverser() {
        return new AbstractTypeReferencePairWalker.CompoundTypeReferenceTraverser(this){

            protected void doVisitUnboundTypeReference(UnboundTypeReference reference, CompoundTypeReference declaration) {
                if (declaration.isSynonym()) {
                    super.doVisitUnboundTypeReference(reference, declaration);
                } else {
                    DeferredTypeParameterHintCollector.this.addHint(reference, declaration);
                }
            }
        };
    }

    @Override
    protected AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser createParameterizedTypeReferenceTraverser() {
        return new AbstractTypeReferencePairWalker.ParameterizedTypeReferenceTraverser(this){

            @Override
            public void doVisitUnboundTypeReference(UnboundTypeReference reference, ParameterizedTypeReference declaration) {
                DeferredTypeParameterHintCollector.this.addHint(reference, declaration);
            }

            @Override
            protected boolean shouldProcessInContextOf(JvmTypeParameter declaredTypeParameter, Set<JvmTypeParameter> boundParameters, Set<JvmTypeParameter> visited) {
                return !boundParameters.contains(declaredTypeParameter) || visited.add(declaredTypeParameter);
            }
        };
    }

    @Override
    protected JvmTypeParameter findMappedParameter(JvmTypeParameter parameter, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> mapping, Collection<JvmTypeParameter> visited) {
        return UnboundTypeReferences.findMappedParameter(parameter, mapping, visited);
    }

    protected void addHint(UnboundTypeReference typeParameter, LightweightTypeReference reference) {
        LightweightTypeReference wrapped = this.getStricterConstraint(typeParameter, reference.getWrapperTypeIfPrimitive());
        typeParameter.acceptHint(wrapped, this.getTypeArgumentSource(), this.getOrigin(), this.getExpectedVariance(), this.getActualVariance());
    }

    protected BoundTypeArgumentSource getTypeArgumentSource() {
        return BoundTypeArgumentSource.INFERRED_LATER;
    }

    protected LightweightTypeReference getStricterConstraint(UnboundTypeReference typeParameter, LightweightTypeReference hint) {
        JvmTypeParameter parameter = typeParameter.getTypeParameter();
        EList constraints = parameter.getConstraints();
        for (JvmTypeConstraint constraint : constraints) {
            LightweightTypeReference lightweightReference;
            JvmTypeReference constraintReference = constraint.getTypeReference();
            if (constraintReference == null || !hint.isAssignableFrom(lightweightReference = new OwnedConverter(hint.getOwner()).toLightweightReference(constraintReference))) continue;
            hint = lightweightReference;
        }
        return hint;
    }

    protected class UnboundTypeParameterHintCollector
    extends AbstractTypeReferencePairWalker.UnboundTypeReferenceTraverser {
        protected UnboundTypeParameterHintCollector() {
        }

        protected void doVisitTypeReference(LightweightTypeReference reference, UnboundTypeReference declaration) {
            if (declaration.internalIsResolved() || DeferredTypeParameterHintCollector.this.getOwner().isResolved(declaration.getHandle())) {
                declaration.tryResolve();
                DeferredTypeParameterHintCollector.this.outerVisit(declaration, reference, declaration, DeferredTypeParameterHintCollector.this.getExpectedVariance(), DeferredTypeParameterHintCollector.this.getActualVariance());
            } else if (reference.isValidHint()) {
                DeferredTypeParameterHintCollector.this.addHint(declaration, reference);
            }
        }

        protected void doVisitCompoundTypeReference(CompoundTypeReference reference, UnboundTypeReference param) {
            this.doVisitTypeReference((LightweightTypeReference)reference, param);
        }
    }
}

