/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.services.XtextGrammarAccess;
import org.eclipse.xtext.ui.contentassist.AbstractXtextProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.AbstractJavaBasedContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultHighlightingConfiguration;
import org.eclipse.xtext.ui.label.StylerFactory;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.UsedRulesFinder;
import org.eclipse.xtext.xtext.ui.editor.syntaxcoloring.SemanticHighlightingCalculator;
import org.eclipse.xtext.xtext.ui.editor.syntaxcoloring.SemanticHighlightingConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextProposalProvider
extends AbstractXtextProposalProvider {
    @Inject
    private DefaultHighlightingConfiguration defaultLexicalHighlightingConfiguration;
    @Inject
    private SemanticHighlightingConfiguration semanticHighlightingConfiguration;
    @Inject
    private StylerFactory stylerFactory;
    @Inject
    private XtextGrammarAccess grammarAccess;
    @Inject
    private IQualifiedNameConverter.DefaultImpl grammarIdQualifiedNameConverter;

    @Override
    public void completeGrammar_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Resource resource = model.eResource();
        URI uri = resource.getURI();
        if (uri.isPlatformResource()) {
            Path path = new Path(uri.toPlatformString(true));
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            IProject project = file.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                try {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
                    int n = iPackageFragmentRootArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                        IPath packageFragmentRootPath = packageFragmentRoot.getPath();
                        if (packageFragmentRootPath.isPrefixOf((IPath)path)) {
                            IPath relativePath = path.makeRelativeTo(packageFragmentRootPath);
                            relativePath = relativePath.removeFileExtension();
                            String result = relativePath.toString();
                            result = result.replace('/', '.');
                            acceptor.accept(this.createCompletionProposal(result, context));
                            return;
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void completeReferencedMetamodel_EPackage(EObject model, Assignment assignment, final ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeReferencedMetamodel_EPackage(model, assignment, context.copy().setMatcher(new PrefixMatcher(){

            public boolean isCandidateMatchingPrefix(String name, String prefix) {
                if (prefix.startsWith("\"")) {
                    if (prefix.length() == 1) {
                        prefix = "";
                    } else if ((prefix = prefix.substring(1)).endsWith("\"")) {
                        prefix = prefix.substring(0, prefix.length() - 1);
                    }
                }
                name = XtextProposalProvider.this.getValueConverter().toValue(name, "STRING", null).toString();
                if (context.getMatcher().isCandidateMatchingPrefix(name, prefix)) {
                    return true;
                }
                try {
                    URI uri = URI.createURI((String)name);
                    if (context.getMatcher().isCandidateMatchingPrefix(uri.lastSegment(), prefix)) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }).toContext(), acceptor);
    }

    @Override
    public void completeGeneratedMetamodel_Alias(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof GeneratedMetamodel) {
            EPackage ePackage = ((GeneratedMetamodel)model).getEPackage();
            String name = ((GeneratedMetamodel)model).getName();
            this.createAliasProposal(context, acceptor, ePackage, name);
        }
        super.completeGeneratedMetamodel_Alias(model, assignment, context, acceptor);
    }

    private void createAliasProposal(ContentAssistContext context, ICompletionProposalAcceptor acceptor, EPackage ePackage, String proposal) {
        ConfigurableCompletionProposal completionProposal;
        if (!Strings.isEmpty((String)proposal) && (completionProposal = (ConfigurableCompletionProposal)this.createCompletionProposal(proposal, String.valueOf(proposal) + " - alias", ePackage != null ? this.getImage((EObject)ePackage) : null, context)) != null) {
            completionProposal.setPriority(completionProposal.getPriority() * 2);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    @Override
    public void completeReferencedMetamodel_Alias(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EPackage ePackage;
        if (model instanceof AbstractMetamodelDeclaration && (ePackage = ((AbstractMetamodelDeclaration)model).getEPackage()) != null) {
            this.createAliasProposal(context, acceptor, ePackage, ePackage.getName());
            this.createAliasProposal(context, acceptor, ePackage, ePackage.getNsPrefix());
        }
        super.completeReferencedMetamodel_Alias(model, assignment, context, acceptor);
    }

    protected StyledString getKeywordDisplayString(Keyword keyword) {
        return this.stylerFactory.createFromXtextStyle(keyword.getValue(), this.defaultLexicalHighlightingConfiguration.keywordTextStyle());
    }

    protected StyledString getStyledDisplayString(EObject element, String qualifiedName, String shortName) {
        StyledString styledDisplayString = super.getStyledDisplayString(element, qualifiedName, shortName);
        if (element instanceof ParserRule && GrammarUtil.isDatatypeRule((ParserRule)((ParserRule)element))) {
            styledDisplayString = this.stylerFactory.createFromXtextStyle(styledDisplayString.getString(), this.semanticHighlightingConfiguration.dataTypeRule());
        }
        return styledDisplayString;
    }

    protected StyledString getStyledDisplayString(IEObjectDescription description) {
        if (EcorePackage.Literals.EPACKAGE == description.getEClass() && "true".equals(description.getUserData("nsURI"))) {
            String name = description.getUserData("name");
            if (name == null) {
                return new StyledString(description.getName().toString());
            }
            String string = String.valueOf(name) + " - " + description.getName();
            return new StyledString(string);
        }
        return super.getStyledDisplayString(description);
    }

    protected String getDisplayString(EObject element, String proposal, String shortName) {
        if (element instanceof AbstractMetamodelDeclaration) {
            AbstractMetamodelDeclaration decl = (AbstractMetamodelDeclaration)element;
            if (!Strings.isEmpty((String)decl.getAlias())) {
                return decl.getAlias();
            }
        } else if (element instanceof EPackage) {
            EPackage pack = (EPackage)element;
            return String.valueOf(pack.getName()) + " - " + pack.getNsURI();
        }
        return super.getDisplayString(element, proposal, shortName);
    }

    @Override
    public void completeAssignment_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        AbstractRule rule = (AbstractRule)EcoreUtil2.getContainerOfType((EObject)model, AbstractRule.class);
        EClassifier type = rule.getType().getClassifier();
        if (type instanceof EClass) {
            EList features = ((EClass)type).getEAllStructuralFeatures();
            Function<IEObjectDescription, ICompletionProposal> factory = this.getProposalFactory("ID", context);
            Set<String> processedFeatures = this.completeStructuralFeatures(context, factory, acceptor, (Iterable<? extends EStructuralFeature>)features);
            if (rule.getType().getMetamodel() instanceof GeneratedMetamodel) {
                if (Strings.notNull((Object)rule.getName()).toLowerCase().startsWith("import")) {
                    this.completeSpecialAttributeAssignment("importedNamespace", 2, processedFeatures, factory, context, acceptor);
                    this.completeSpecialAttributeAssignment("importURI", 1, processedFeatures, factory, context, acceptor);
                } else {
                    this.completeSpecialAttributeAssignment("name", 3, processedFeatures, factory, context, acceptor);
                }
            }
        }
        super.completeAssignment_Feature(model, assignment, context, acceptor);
    }

    protected void completeSpecialAttributeAssignment(String specialAttribute, int priorityFactor, Iterable<String> processedFeatures, Function<IEObjectDescription, ICompletionProposal> factory, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!Iterables.contains(processedFeatures, (Object)specialAttribute)) {
            EAttribute dummyAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            dummyAttribute.setName(specialAttribute);
            dummyAttribute.setEType((EClassifier)EcorePackage.Literals.ESTRING);
            acceptor.accept(this.createFeatureProposal((EStructuralFeature)dummyAttribute, priorityFactor, factory, context));
        }
    }

    protected Set<String> completeStructuralFeatures(ContentAssistContext context, Function<IEObjectDescription, ICompletionProposal> factory, ICompletionProposalAcceptor acceptor, Iterable<? extends EStructuralFeature> features) {
        if (features != null) {
            HashSet processedFeatures = Sets.newHashSet();
            for (EStructuralFeature eStructuralFeature : features) {
                acceptor.accept(this.createFeatureProposal(eStructuralFeature, 4, factory, context));
                processedFeatures.add(eStructuralFeature.getName());
            }
            return processedFeatures;
        }
        return null;
    }

    protected ICompletionProposal createFeatureProposal(EStructuralFeature feature, int priorityFactor, Function<IEObjectDescription, ICompletionProposal> factory, ContentAssistContext context) {
        IEObjectDescription description = EObjectDescription.create((QualifiedName)QualifiedName.create((String)feature.getName()), (EObject)feature);
        ConfigurableCompletionProposal proposal = (ConfigurableCompletionProposal)factory.apply((Object)description);
        if (proposal != null) {
            proposal.setPriority(proposal.getPriority() * priorityFactor);
            if (SemanticHighlightingCalculator.SPECIAL_ATTRIBUTES.contains(feature.getName())) {
                StyledString displayString = this.stylerFactory.createFromXtextStyle(feature.getName(), this.semanticHighlightingConfiguration.specialAttribute()).append(" - Assignment of special attribute ").append(this.stylerFactory.createFromXtextStyle(feature.getName(), this.semanticHighlightingConfiguration.specialAttribute()));
                proposal.setDisplayString(displayString);
            } else {
                proposal.setDisplayString(new StyledString(String.valueOf(feature.getName()) + " - Assignment of feature " + feature.getName()));
            }
            if (feature.isMany()) {
                proposal.setReplacementString(String.valueOf(feature.getName()) + "+=");
                proposal.setCursorPosition(proposal.getCursorPosition() + 2);
            } else if (feature.getEType() == EcorePackage.Literals.EBOOLEAN) {
                proposal.setReplacementString(String.valueOf(feature.getName()) + "?=");
                proposal.setCursorPosition(proposal.getCursorPosition() + 2);
            } else {
                proposal.setReplacementString(String.valueOf(feature.getName()) + "=");
                proposal.setCursorPosition(proposal.getCursorPosition() + 1);
            }
        }
        return proposal;
    }

    @Override
    public void completeAction_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EClassifier classifier;
        Action action = (Action)EcoreUtil2.getContainerOfType((EObject)model, Action.class);
        if (action != null && action.getType() != null && (classifier = action.getType().getClassifier()) instanceof EClass) {
            EList containments = ((EClass)classifier).getEAllContainments();
            Function<IEObjectDescription, ICompletionProposal> factory = this.getProposalFactory("ID", context);
            this.completeStructuralFeatures(context, factory, acceptor, (Iterable<? extends EStructuralFeature>)containments);
        }
        super.completeAction_Feature(model, assignment, context, acceptor);
    }

    @Override
    public void completeTypeRef_Classifier(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompositeNode node;
        Grammar grammar = GrammarUtil.getGrammar((EObject)model);
        ContentAssistContext.Builder myContextBuilder = context.copy();
        myContextBuilder.setMatcher((PrefixMatcher)new ClassifierPrefixMatcher(context.getMatcher(), this.getQualifiedNameConverter()));
        if (model instanceof TypeRef && (node = NodeModelUtils.getNode((EObject)model)) != null) {
            int offset = node.getOffset();
            Region replaceRegion = new Region(offset, context.getReplaceRegion().getLength() + context.getReplaceRegion().getOffset() - offset);
            myContextBuilder.setReplaceRegion(replaceRegion);
            myContextBuilder.setLastCompleteNode((INode)node);
            StringBuilder availablePrefix = new StringBuilder(4);
            for (ILeafNode leaf : node.getLeafNodes()) {
                if (leaf.getGrammarElement() != null && !leaf.isHidden()) {
                    if (leaf.getTotalLength() + leaf.getTotalOffset() < context.getOffset()) {
                        availablePrefix.append(leaf.getText());
                    } else {
                        availablePrefix.append(leaf.getText().substring(0, context.getOffset() - leaf.getTotalOffset()));
                    }
                }
                if (leaf.getTotalOffset() >= context.getOffset()) break;
            }
            myContextBuilder.setPrefix(availablePrefix.toString());
        }
        ContentAssistContext myContext = myContextBuilder.toContext();
        for (AbstractMetamodelDeclaration declaration : grammar.getMetamodelDeclarations()) {
            if (declaration.getEPackage() == null) continue;
            this.createClassifierProposals(declaration, model, myContext, acceptor);
        }
    }

    private void createClassifierProposals(AbstractMetamodelDeclaration declaration, EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String alias = declaration.getAlias();
        QualifiedName prefix = !Strings.isEmpty((String)alias) ? QualifiedName.create((String)this.getValueConverter().toString((Object)alias, "ID")) : null;
        boolean createDatatypeProposals = !(model instanceof AbstractElement) && this.modelOrContainerIs(model, AbstractRule.class);
        boolean createEnumProposals = !(model instanceof AbstractElement) && this.modelOrContainerIs(model, EnumRule.class);
        boolean createClassProposals = this.modelOrContainerIs(model, ParserRule.class, CrossReference.class, Action.class);
        Function<IEObjectDescription, ICompletionProposal> factory = this.getProposalFactory(null, context);
        for (EClassifier classifier : declaration.getEPackage().getEClassifiers()) {
            if (!(classifier instanceof EDataType && createDatatypeProposals || classifier instanceof EEnum && createEnumProposals) && (!(classifier instanceof EClass) || !createClassProposals)) continue;
            String classifierName = this.getValueConverter().toString((Object)classifier.getName(), "ID");
            QualifiedName proposalQualifiedName = prefix != null ? prefix.append(classifierName) : QualifiedName.create((String)classifierName);
            IEObjectDescription description = EObjectDescription.create((QualifiedName)proposalQualifiedName, (EObject)classifier);
            ConfigurableCompletionProposal proposal = (ConfigurableCompletionProposal)factory.apply((Object)description);
            if (proposal != null) {
                if (prefix != null) {
                    proposal.setDisplayString(String.valueOf(classifier.getName()) + " - " + alias);
                }
                proposal.setPriority(proposal.getPriority() * 2);
            }
            acceptor.accept((ICompletionProposal)proposal);
        }
    }

    private boolean modelOrContainerIs(EObject model, Class<?> ... types) {
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            if (type.isInstance(model) || type.isInstance(model.eContainer())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void complete_ParserRule(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeParserRule(model, context, acceptor);
        this.completeInheritedRules(model, context, acceptor);
        super.complete_ParserRule(model, ruleCall, context, acceptor);
    }

    private void completeInheritedRules(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Grammar grammar = GrammarUtil.getGrammar((EObject)model);
        Set<AbstractRule> allRules = this.collectOverrideCandidates(grammar);
        Map<String, AbstractRule> existingRules = this.collectExistingRules(grammar);
        for (AbstractRule newRule : allRules) {
            if (existingRules.put(newRule.getName(), newRule) != null) continue;
            this.createOverrideProposal(newRule, grammar, context, acceptor);
        }
    }

    protected void createOverrideProposal(final AbstractRule overrideMe, final Grammar grammar, final ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StringBuilder proposal = new StringBuilder();
        if (overrideMe instanceof TerminalRule) {
            proposal.append("terminal ");
            if (((TerminalRule)overrideMe).isFragment()) {
                proposal.append("fragment ");
            }
        }
        if (overrideMe instanceof EnumRule) {
            proposal.append("enum ");
        }
        proposal.append(overrideMe.getName());
        boolean foundPack = this.appendReturnType(overrideMe, grammar, proposal);
        proposal = proposal.append(":\n\t\n;");
        ConfigurableCompletionProposal completionProposal = (ConfigurableCompletionProposal)this.createCompletionProposal(proposal.toString(), String.valueOf(overrideMe.getName()) + " - override rule " + overrideMe.getName(), this.getImage((EObject)overrideMe), context.copy().setMatcher(new PrefixMatcher(){

            public boolean isCandidateMatchingPrefix(String name, String prefix) {
                return context.getMatcher().isCandidateMatchingPrefix(overrideMe.getName(), prefix);
            }
        }).toContext());
        if (completionProposal != null) {
            completionProposal.setCursorPosition(proposal.length() - 3);
            if (!foundPack) {
                completionProposal.setTextApplier(new ConfigurableCompletionProposal.IReplacementTextApplier(){

                    public void apply(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
                        ICompositeNode node;
                        int offset = 0;
                        boolean startWithLB = true;
                        if (grammar.getMetamodelDeclarations().isEmpty()) {
                            startWithLB = false;
                            if (grammar.getRules().isEmpty()) {
                                offset = document.getLength();
                            } else {
                                node = NodeModelUtils.getNode((EObject)((EObject)grammar.getRules().get(0)));
                                if (node != null) {
                                    offset = node.getOffset();
                                }
                            }
                        } else {
                            node = NodeModelUtils.getNode((EObject)((EObject)grammar.getMetamodelDeclarations().get(grammar.getMetamodelDeclarations().size() - 1)));
                            if (node != null) {
                                offset = node.getEndOffset();
                            }
                        }
                        offset = Math.min(proposal.getReplacementOffset(), offset);
                        String replacementString = proposal.getReplacementString();
                        proposal.setCursorPosition(replacementString.length());
                        document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), replacementString);
                        EPackage classifierPackage = overrideMe.getType().getClassifier().getEPackage();
                        StringBuilder insertMe = new StringBuilder("import ").append(XtextProposalProvider.this.getValueConverter().toString((Object)classifierPackage.getNsURI(), "STRING"));
                        if (startWithLB) {
                            insertMe.insert(0, '\n');
                        }
                        insertMe.append(" as ").append(XtextProposalProvider.this.getValueConverter().toString((Object)classifierPackage.getName(), "ID"));
                        insertMe.append('\n');
                        document.replace(offset, 0, insertMe.toString());
                        proposal.setCursorPosition(proposal.getCursorPosition() + insertMe.length() - 3);
                    }
                });
            }
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    protected boolean appendReturnType(AbstractRule overrideMe, Grammar grammar, StringBuilder newRuleFragment) {
        EClassifier classifier = overrideMe.getType().getClassifier();
        EPackage classifierPackage = classifier.getEPackage();
        boolean foundPack = false;
        for (AbstractMetamodelDeclaration metamodel : grammar.getMetamodelDeclarations()) {
            EPackage available = metamodel.getEPackage();
            if (classifierPackage != available) continue;
            EDataType eString = GrammarUtil.findEString((Grammar)grammar);
            if (eString == null) {
                eString = EcorePackage.Literals.ESTRING;
            }
            if (!(classifier == eString || Strings.isEmpty((String)metamodel.getAlias()) && classifier.getName().equals(overrideMe.getName()))) {
                newRuleFragment.append(" returns ");
                if (!Strings.isEmpty((String)metamodel.getAlias())) {
                    newRuleFragment.append(metamodel.getAlias()).append("::");
                }
                newRuleFragment.append(classifier.getName());
            }
            foundPack = true;
            break;
        }
        if (!foundPack) {
            EDataType eString = GrammarUtil.findEString((Grammar)grammar);
            if (eString == null) {
                eString = EcorePackage.Literals.ESTRING;
            }
            if (classifier == eString) {
                for (AbstractMetamodelDeclaration mm : GrammarUtil.allMetamodelDeclarations((Grammar)grammar)) {
                    if (mm.getEPackage() != classifierPackage) continue;
                    foundPack = true;
                    break;
                }
            }
            if (!foundPack) {
                newRuleFragment.append(" returns ");
                newRuleFragment.append(classifierPackage.getName());
                newRuleFragment.append("::");
                newRuleFragment.append(classifier.getName());
            }
        }
        return foundPack;
    }

    protected Set<AbstractRule> collectOverrideCandidates(Grammar grammar) {
        HashSet allRules = Sets.newHashSet();
        List usedGrammars = GrammarUtil.allUsedGrammars((Grammar)grammar);
        UsedRulesFinder usedRulesFinder = new UsedRulesFinder((Collection)allRules);
        for (Grammar usedGrammar : usedGrammars) {
            usedRulesFinder.compute(usedGrammar);
        }
        if (allRules.isEmpty()) {
            for (Grammar usedGrammar : usedGrammars) {
                allRules.addAll(usedGrammar.getRules());
            }
        }
        return allRules;
    }

    protected Map<String, AbstractRule> collectExistingRules(Grammar grammar) {
        HashMap existingRules = Maps.newHashMap();
        for (AbstractRule rule : grammar.getRules()) {
            existingRules.put(rule.getName(), rule);
        }
        return existingRules;
    }

    @Override
    public void completeParserRule_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeParserRule(model, context, acceptor);
        super.completeParserRule_Name(model, assignment, context, acceptor);
    }

    private void completeParserRule(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Grammar grammar = GrammarUtil.getGrammar((EObject)model);
        for (AbstractMetamodelDeclaration metamodelDeclaration : grammar.getMetamodelDeclarations()) {
            ReferencedMetamodel referencedMetamodel;
            EPackage ePackage;
            if (!(metamodelDeclaration instanceof ReferencedMetamodel) || (ePackage = (referencedMetamodel = (ReferencedMetamodel)metamodelDeclaration).getEPackage()) == null) continue;
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                ConfigurableCompletionProposal completionProposal;
                if (!this.isProposeParserRule(eClassifier, grammar)) continue;
                String proposal = eClassifier.getName();
                String metamodelAlias = referencedMetamodel.getAlias();
                if (metamodelAlias != null) {
                    proposal = String.valueOf(proposal) + " returns " + metamodelAlias + "::" + eClassifier.getName();
                }
                if ((completionProposal = (ConfigurableCompletionProposal)this.createCompletionProposal(proposal = String.valueOf(proposal) + ": \n;\n", String.valueOf(eClassifier.getName()) + " - parser rule", this.getImage((EObject)XtextFactory.eINSTANCE.createParserRule()), context)) == null) continue;
                completionProposal.setCursorPosition(proposal.length() - 3);
                acceptor.accept((ICompletionProposal)completionProposal);
            }
        }
    }

    private boolean isProposeParserRule(EClassifier eClassifier, Grammar grammar) {
        if (eClassifier instanceof EDataType && !((EDataType)eClassifier).isSerializable()) {
            return false;
        }
        Iterable allRuleNames = Iterables.transform((Iterable)GrammarUtil.allParserRules((Grammar)grammar), (Function)new Function<ParserRule, EClassifier>(){

            public EClassifier apply(ParserRule from) {
                return from.getType().getClassifier();
            }
        });
        return !Iterables.contains((Iterable)allRuleNames, (Object)eClassifier);
    }

    @Override
    public void completeParserRule_HiddenTokens(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeHiddenTokens(assignment, context, acceptor);
    }

    @Override
    public void completeGrammar_HiddenTokens(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeHiddenTokens(assignment, context, acceptor);
    }

    protected void completeHiddenTokens(Assignment assignment, final ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        CrossReference crossReference = (CrossReference)assignment.getTerminal();
        this.lookupCrossReference(crossReference, context, acceptor, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                if (input.getEClass() == XtextPackage.Literals.TERMINAL_RULE) {
                    EObject object = input.getEObjectOrProxy();
                    if (object.eIsProxy()) {
                        object = context.getResource().getResourceSet().getEObject(input.getEObjectURI(), true);
                    }
                    if (object instanceof TerminalRule) {
                        return !((TerminalRule)object).isFragment();
                    }
                }
                return false;
            }
        });
    }

    @Override
    public void completeRuleCall_Rule(EObject model, Assignment assignment, final ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        AbstractRule containingRule = (AbstractRule)EcoreUtil2.getContainerOfType((EObject)model, AbstractRule.class);
        CrossReference crossReference = (CrossReference)assignment.getTerminal();
        if (containingRule instanceof TerminalRule) {
            this.lookupCrossReference(crossReference, context, acceptor, (Predicate)new Predicate<IEObjectDescription>(){

                public boolean apply(IEObjectDescription input) {
                    return input.getEClass() == XtextPackage.Literals.TERMINAL_RULE;
                }
            });
        } else {
            this.lookupCrossReference(crossReference, context, acceptor, (Predicate)new Predicate<IEObjectDescription>(){

                public boolean apply(IEObjectDescription input) {
                    if (input.getEClass() == XtextPackage.Literals.TERMINAL_RULE) {
                        EObject object = input.getEObjectOrProxy();
                        if (object.eIsProxy()) {
                            object = context.getResource().getResourceSet().getEObject(input.getEObjectURI(), true);
                        }
                        if (object instanceof TerminalRule) {
                            return !((TerminalRule)object).isFragment();
                        }
                    }
                    return true;
                }
            });
        }
    }

    protected Function<IEObjectDescription, ICompletionProposal> getProposalFactory(String ruleName, ContentAssistContext contentAssistContext) {
        if (this.grammarAccess.getGrammarIDRule().getName().equals(ruleName)) {
            return new AbstractJavaBasedContentProposalProvider.DefaultProposalCreator((AbstractJavaBasedContentProposalProvider)this, contentAssistContext, ruleName, (IQualifiedNameConverter)this.grammarIdQualifiedNameConverter);
        }
        return new AbstractJavaBasedContentProposalProvider.DefaultProposalCreator((AbstractJavaBasedContentProposalProvider)this, contentAssistContext, ruleName, this.getQualifiedNameConverter());
    }

    public static class ClassifierPrefixMatcher
    extends PrefixMatcher {
        private PrefixMatcher delegate;
        private IQualifiedNameConverter qualifiedNameConverter;

        public ClassifierPrefixMatcher(PrefixMatcher delegate, IQualifiedNameConverter qualifiedNameConverter) {
            this.delegate = delegate;
            this.qualifiedNameConverter = qualifiedNameConverter;
        }

        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            if (this.delegate.isCandidateMatchingPrefix(name, prefix)) {
                return true;
            }
            QualifiedName qualifiedName = this.qualifiedNameConverter.toQualifiedName(name);
            QualifiedName qualifiedPrefix = this.qualifiedNameConverter.toQualifiedName(prefix);
            if (qualifiedName.getSegmentCount() > 1) {
                if (qualifiedPrefix.getSegmentCount() == 1) {
                    return this.delegate.isCandidateMatchingPrefix(qualifiedName.getSegment(1), qualifiedPrefix.getFirstSegment());
                }
                if (!this.delegate.isCandidateMatchingPrefix(qualifiedName.getFirstSegment(), qualifiedPrefix.getFirstSegment())) {
                    return false;
                }
                return this.delegate.isCandidateMatchingPrefix(qualifiedName.getSegment(1), qualifiedPrefix.getSegment(1));
            }
            return false;
        }
    }
}

