/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.file;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.file.AbstractFileSystemSupport;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseFileSystemSupportImpl
extends AbstractFileSystemSupport {
    @Inject
    private IWorkspaceRoot _workspaceRoot;

    public IWorkspaceRoot getWorkspaceRoot() {
        return this._workspaceRoot;
    }

    public void setWorkspaceRoot(IWorkspaceRoot workspaceRoot) {
        this._workspaceRoot = workspaceRoot;
    }

    protected IFile getEclipseFile(Path path) {
        IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot();
        String _string = path.toString();
        org.eclipse.core.runtime.Path _path = new org.eclipse.core.runtime.Path(_string);
        IFile _file = _workspaceRoot.getFile((IPath)_path);
        return _file;
    }

    protected IFolder getEclipseFolder(Path path) {
        IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot();
        String _string = path.toString();
        org.eclipse.core.runtime.Path _path = new org.eclipse.core.runtime.Path(_string);
        IFolder _folder = _workspaceRoot.getFolder((IPath)_path);
        return _folder;
    }

    protected IContainer getEclipseContainer(Path path) {
        List _segments;
        IWorkspaceRoot _xblockexpression = null;
        boolean _isAbsolute = path.isAbsolute();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"The given path has to be absolute: '");
        _builder.append((Object)path, "");
        _builder.append((Object)"'.");
        Preconditions.checkState((boolean)_isAbsolute, (Object)_builder);
        IWorkspaceRoot _switchResult = null;
        List segments = _segments = path.getSegments();
        boolean _matched = false;
        if (!_matched) {
            boolean _equals;
            int _size = segments.size();
            boolean bl = _equals = _size == 0;
            if (_equals) {
                IWorkspaceRoot _workspaceRoot;
                _matched = true;
                _switchResult = _workspaceRoot = this.getWorkspaceRoot();
            }
        }
        if (!_matched) {
            boolean _equals_1;
            int _size_1 = segments.size();
            boolean bl = _equals_1 = _size_1 == 1;
            if (_equals_1) {
                _matched = true;
                IWorkspaceRoot _workspaceRoot_1 = this.getWorkspaceRoot();
                List _segments_1 = path.getSegments();
                String _head = (String)IterableExtensions.head((Iterable)_segments_1);
                IProject _project = _workspaceRoot_1.getProject(_head);
                _switchResult = _project;
            }
        }
        if (!_matched) {
            IWorkspaceRoot _workspaceRoot_2 = this.getWorkspaceRoot();
            String _string = path.toString();
            org.eclipse.core.runtime.Path _path = new org.eclipse.core.runtime.Path(_string);
            IFolder _folder = _workspaceRoot_2.getFolder((IPath)_path);
            _switchResult = _folder;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected IResource findResource(Path path) {
        IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot();
        String _string = path.toString();
        org.eclipse.core.runtime.Path _path = new org.eclipse.core.runtime.Path(_string);
        IResource _findMember = _workspaceRoot.findMember((IPath)_path);
        return _findMember;
    }

    protected org.eclipse.core.runtime.Path toEclipsePath(Path path) {
        String _string = path.toString();
        org.eclipse.core.runtime.Path _path = new org.eclipse.core.runtime.Path(_string);
        return _path;
    }

    public Iterable<? extends Path> getChildren(Path path) {
        try {
            List _map;
            boolean _not;
            List _xblockexpression = null;
            IContainer container = this.getEclipseContainer(path);
            boolean _exists = container.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                return CollectionLiterals.emptyList();
            }
            IResource[] _members = container.members();
            Functions.Function1<IResource, Path> _function = new Functions.Function1<IResource, Path>(){

                public Path apply(IResource it) {
                    IPath _fullPath = it.getFullPath();
                    String _string = _fullPath.toString();
                    Path _path = new Path(_string);
                    return _path;
                }
            };
            _xblockexpression = _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_members)), (Functions.Function1)_function);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean exists(Path path) {
        IResource _findResource = this.findResource(path);
        boolean _notEquals = !Objects.equal((Object)_findResource, null);
        return _notEquals;
    }

    public boolean isFolder(Path path) {
        IResource _findResource = this.findResource(path);
        return _findResource instanceof IContainer;
    }

    public boolean isFile(Path path) {
        IResource _findResource = this.findResource(path);
        return _findResource instanceof IFile;
    }

    public long getLastModification(Path path) {
        IResource _findResource = this.findResource(path);
        long _modificationStamp = _findResource.getModificationStamp();
        return _modificationStamp;
    }

    public String getCharset(Path path) {
        try {
            boolean _isFile = this.isFile(path);
            if (_isFile) {
                IFile _eclipseFile = this.getEclipseFile(path);
                return _eclipseFile.getCharset();
            }
            boolean _isFolder = this.isFolder(path);
            if (_isFolder) {
                IContainer _eclipseContainer = this.getEclipseContainer(path);
                return _eclipseContainer.getDefaultCharset();
            }
            Path _parent = path.getParent();
            return this.getCharset(_parent);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public InputStream getContentsAsStream(Path path) {
        try {
            IFile _eclipseFile = this.getEclipseFile(path);
            InputStream _contents = _eclipseFile.getContents();
            return _contents;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean delete(Path path) {
        try {
            boolean _exists = this.exists(path);
            if (_exists) {
                IResource _findResource = this.findResource(path);
                _findResource.delete(true, null);
                return true;
            }
            return false;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean mkdir(Path path) {
        boolean _xblockexpression_1;
        IContainer _eclipseContainer;
        boolean _not;
        boolean _xblockexpression;
        block7: {
            try {
                _xblockexpression = false;
                boolean _exists = this.exists(path);
                if (!_exists) break block7;
                return false;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        Path _parent = path.getParent();
        boolean _exists_1 = this.exists(_parent);
        boolean bl = _not = !_exists_1;
        if (_not) {
            Path _parent_1 = path.getParent();
            this.mkdir(_parent_1);
        }
        boolean _switchResult = false;
        IContainer container = _eclipseContainer = this.getEclipseContainer(path);
        boolean _matched = false;
        if (!_matched && container instanceof IFolder) {
            _matched = true;
            _xblockexpression_1 = false;
            ((IFolder)container).create(true, true, null);
            _switchResult = _xblockexpression_1 = true;
        }
        if (!_matched && container instanceof IProject) {
            _matched = true;
            _xblockexpression_1 = false;
            ((IProject)container).create(null);
            _switchResult = _xblockexpression_1 = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public void setContentsAsStream(Path path, InputStream stream) {
        try {
            boolean _exists = this.exists(path);
            if (_exists) {
                IFile _eclipseFile = this.getEclipseFile(path);
                _eclipseFile.setContents(stream, true, true, null);
            } else {
                Path _parent = path.getParent();
                this.mkdir(_parent);
                IFile _eclipseFile_1 = this.getEclipseFile(path);
                _eclipseFile_1.create(stream, true, null);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public java.net.URI toURI(Path path) {
        IWorkspaceRoot _workspaceRoot = this.getWorkspaceRoot();
        IPath _location = _workspaceRoot.getLocation();
        String _string = path.toString();
        IPath _append = _location.append(_string);
        java.net.URI _uRI = URIUtil.toURI((IPath)_append);
        return _uRI;
    }

    public Path getPath(Resource res) {
        boolean _not;
        URI _uRI = res.getURI();
        boolean _isPlatform = _uRI.isPlatform();
        boolean bl = _not = !_isPlatform;
        if (_not) {
            URI _uRI_1 = res.getURI();
            String _plus = "Expecting platform URI but was : " + _uRI_1;
            IllegalStateException _illegalStateException = new IllegalStateException(_plus);
            throw _illegalStateException;
        }
        URI _uRI_2 = res.getURI();
        String _platformString = _uRI_2.toPlatformString(false);
        Path _path = new Path(_platformString);
        return _path;
    }
}

