/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.shared.internal;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.xtext.common.types.ui.notification.TypeResourceUnloader;
import org.eclipse.xtext.ui.shared.internal.EagerContributionInitializer;
import org.eclipse.xtext.ui.shared.internal.SharedModule;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    private static final Logger log = Logger.getLogger(Activator.class);
    private static Activator plugin;
    public static final String PLUGIN_ID = "org.eclipse.xtext.ui.shared";
    private Injector injector;
    @Inject
    private IWorkspace workspace;
    @Inject
    private EagerContributionInitializer initializer;

    public static Activator getDefault() {
        return plugin;
    }

    public Injector getInjector() {
        return this.injector;
    }

    protected void initializeInjector(BundleContext context) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.xtext.ui.shared.overridingGuiceModule");
        IExtension[] extensions = point.getExtensions();
        SharedModule module = new SharedModule(context);
        if (extensions.length != 0) {
            int numberOfMixedInModules = 0;
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension iExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = iExtension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement e = iConfigurationElementArray[n4];
                    try {
                        Module m = (Module)e.createExecutableExtension("class");
                        module = Modules.override((Module[])new Module[]{module}).with(new Module[]{m});
                        if (++numberOfMixedInModules == 2) {
                            log.warn((Object)"Multiple overriding guice modules. Will use them in unspecified order.");
                        }
                    }
                    catch (CoreException e1) {
                        log.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        this.injector = Guice.createInjector((Module[])new Module[]{module});
        this.injector.createChildInjector(new Module[]{new Module(){

            public void configure(Binder binder) {
                binder.bind(EagerContributionInitializer.class);
            }
        }}).injectMembers((Object)this);
    }

    public static boolean isJavaEnabled() {
        try {
            JavaCore.class.getName();
            JavaUI.class.getName();
            TypeResourceUnloader.class.getName();
            return true;
        }
        catch (Throwable e) {
            log.warn((Object)("Disabling JDT use. : " + e.getMessage()));
            log.debug((Object)e.getMessage(), e);
            return false;
        }
    }

    public void start(BundleContext context) throws Exception {
        try {
            super.start(context);
            plugin = this;
            this.initializeInjector(context);
            this.initializer.initialize();
        }
        catch (Exception e) {
            log.error((Object)("Error initializing org.eclipse.xtext.ui.shared:" + e.getMessage()), (Throwable)e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.injector = null;
        this.initializer.discard();
        this.initializer = null;
        this.workspace = null;
        super.stop(context);
    }
}

