/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl.javasupport;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.xtext.builder.impl.IQueuedBuildDataContribution;
import org.eclipse.xtext.builder.impl.javasupport.UnconfirmedStructuralChangesDelta;
import org.eclipse.xtext.common.types.ui.notification.JavaBuilderState;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class JdtQueuedBuildData
implements IQueuedBuildDataContribution {
    private Map<String, JavaBuilderState> javaBuildState;
    private Collection<UnconfirmedStructuralChangesDelta> unconfirmedDeltas;

    @Override
    public void reset() {
        ArrayList _newArrayList;
        HashMap _newHashMap;
        this.javaBuildState = _newHashMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        this.unconfirmedDeltas = _newArrayList = CollectionLiterals.newArrayList((Object[])new UnconfirmedStructuralChangesDelta[0]);
    }

    public Collection<UnconfirmedStructuralChangesDelta> getUnconfirmedDeltas() {
        Collection<UnconfirmedStructuralChangesDelta> _unmodifiableCollection = Collections.unmodifiableCollection(this.unconfirmedDeltas);
        return _unmodifiableCollection;
    }

    @Override
    public boolean queueChange(IResourceDescription.Delta delta) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (!_matched && delta instanceof UnconfirmedStructuralChangesDelta) {
            _matched = true;
            boolean _xblockexpression = false;
            IProject project = ((UnconfirmedStructuralChangesDelta)delta).getProject();
            JavaBuilderState state = this.javaBuildState.get(project);
            boolean _equals = Objects.equal((Object)state, null);
            if (_equals) {
                JavaBuilderState _lastBuiltState;
                String _name = project.getName();
                JavaBuilderState _state = state = (_lastBuiltState = JavaBuilderState.getLastBuiltState((IProject)project));
                this.javaBuildState.put(_name, _state);
            }
            Integer _buildNumber = state.getBuildNumber();
            ((UnconfirmedStructuralChangesDelta)delta).setBuildNumber(_buildNumber);
            this.unconfirmedDeltas.add((UnconfirmedStructuralChangesDelta)delta);
            _switchResult = _xblockexpression = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    @Override
    public boolean needsRebuild(IProject it, final Collection<IResourceDescription.Delta> deltas) {
        boolean _doNeedRebuild;
        Procedures.Procedure1<IResourceDescription.Delta> _function;
        boolean _xblockexpression = false;
        String _name = it.getName();
        JavaBuilderState oldState = this.javaBuildState.get(_name);
        final JavaBuilderState newState = JavaBuilderState.getLastBuiltState((IProject)it);
        Procedures.Procedure1<IResourceDescription.Delta> _xifexpression = null;
        boolean _or = false;
        boolean _equals = Objects.equal((Object)oldState, null);
        if (_equals) {
            _or = true;
        } else {
            Long _lastStructuralBuildTime_1;
            Long _lastStructuralBuildTime = oldState.getLastStructuralBuildTime();
            boolean _notEquals = !Objects.equal((Object)_lastStructuralBuildTime, (Object)(_lastStructuralBuildTime_1 = newState.getLastStructuralBuildTime()));
            _or = _equals || _notEquals;
        }
        _xifexpression = _or ? (_function = new Procedures.Procedure1<IResourceDescription.Delta>(){

            public void apply(IResourceDescription.Delta it) {
                Set structurallyChangedTypes = newState.getStructurallyChangedTypes();
                boolean _or = false;
                IResourceDescription _new = it.getNew();
                boolean _namesIntersect = JdtQueuedBuildData.this.namesIntersect(_new, structurallyChangedTypes);
                if (_namesIntersect) {
                    _or = true;
                } else {
                    IResourceDescription _old = it.getOld();
                    boolean _namesIntersect_1 = JdtQueuedBuildData.this.namesIntersect(_old, structurallyChangedTypes);
                    boolean bl = _or = _namesIntersect || _namesIntersect_1;
                }
                if (_or) {
                    deltas.add(it);
                }
            }
        }) : null;
        _xblockexpression = _doNeedRebuild = this.doNeedRebuild(newState, _xifexpression);
        return _xblockexpression;
    }

    protected boolean doNeedRebuild(JavaBuilderState it, Procedures.Procedure1<? super UnconfirmedStructuralChangesDelta> processor) {
        boolean _notEquals;
        boolean _hasNext;
        boolean _xblockexpression = false;
        Iterator<UnconfirmedStructuralChangesDelta> i = this.unconfirmedDeltas.iterator();
        boolean _while = _hasNext = i.hasNext();
        while (_while) {
            boolean _hasNext_1;
            Integer _buildNumber_1;
            boolean _lessThan;
            UnconfirmedStructuralChangesDelta unconfirmed = i.next();
            boolean _and = false;
            int _buildNumber = unconfirmed.getBuildNumber();
            boolean bl = _lessThan = _buildNumber < (_buildNumber_1 = it.getBuildNumber());
            if (!_lessThan) {
                _and = false;
            } else {
                IProject _project = unconfirmed.getProject();
                IProject _project_1 = it.getProject();
                boolean _equals = _project.equals((Object)_project_1);
                boolean bl2 = _and = _lessThan && _equals;
            }
            if (_and) {
                boolean _notEquals2;
                i.remove();
                boolean bl3 = _notEquals2 = !Objects.equal(processor, null);
                if (_notEquals2) {
                    processor.apply((Object)unconfirmed);
                }
            }
            _while = _hasNext_1 = i.hasNext();
        }
        int _size = this.unconfirmedDeltas.size();
        _xblockexpression = _notEquals = _size != 0;
        return _xblockexpression;
    }

    protected boolean namesIntersect(IResourceDescription resourceDescription, Set<QualifiedName> names) {
        boolean _xblockexpression = false;
        boolean _equals = Objects.equal((Object)resourceDescription, null);
        if (_equals) {
            return false;
        }
        Iterable _exportedObjects = resourceDescription.getExportedObjects();
        for (IEObjectDescription objectDescription : _exportedObjects) {
            QualifiedName _qualifiedName = objectDescription.getQualifiedName();
            boolean _contains = names.contains(_qualifiedName);
            if (!_contains) continue;
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }
}

