/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.serializer;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.scoping.impl.SingletonScope;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.scoping.batch.ConstructorTypeScopeWrapper;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.batch.XbaseBatchScopeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class SerializerScopeProvider
extends XbaseBatchScopeProvider
implements IFeatureNames {
    @Inject
    private OperatorMapping operatorMapping;
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IImportsConfiguration importsConfiguration;

    public IScope getScope(EObject context, EReference reference) {
        if (this.isFeatureCallScope(reference)) {
            IScope result = this.createFeatureCallSerializationScope(context);
            return result;
        }
        if (this.isConstructorCallScope(reference)) {
            IScope result = this.createConstructorCallSerializationScope(context);
            return result;
        }
        return super.getScope(context, reference);
    }

    public IScope createConstructorCallSerializationScope(EObject context) {
        if (!(context instanceof XConstructorCall)) {
            return IScope.NULLSCOPE;
        }
        XConstructorCall constructorCall = (XConstructorCall)context;
        JvmConstructor constructor = constructorCall.getConstructor();
        if (constructor.eIsProxy()) {
            return IScope.NULLSCOPE;
        }
        IScope typeScope = this.getScope(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
        ConstructorTypeScopeWrapper result = new ConstructorTypeScopeWrapper(context, IVisibilityHelper.ALL, typeScope);
        return result;
    }

    public IScope createFeatureCallSerializationScope(EObject context) {
        if (!(context instanceof XAbstractFeatureCall)) {
            return IScope.NULLSCOPE;
        }
        XAbstractFeatureCall call = (XAbstractFeatureCall)context;
        JvmIdentifiableElement feature = call.getFeature();
        if (feature instanceof JvmType) {
            return this.getTypeScope(call, (JvmType)feature);
        }
        if (feature instanceof JvmConstructor) {
            return this.getThisOrSuperScope(call, (JvmConstructor)feature);
        }
        if (feature instanceof JvmExecutable) {
            return this.getExecutableScope(call, feature);
        }
        if (feature instanceof JvmFormalParameter || feature instanceof JvmField || feature instanceof XVariableDeclaration || feature instanceof XSwitchExpression) {
            return new SingletonScope(EObjectDescription.create((String)feature.getSimpleName(), (EObject)feature), IScope.NULLSCOPE);
        }
        return IScope.NULLSCOPE;
    }

    protected IScope getExecutableScope(XAbstractFeatureCall call, JvmIdentifiableElement feature) {
        QualifiedName name = QualifiedName.create((String)feature.getSimpleName());
        if (call instanceof XBinaryOperation || call instanceof XUnaryOperation) {
            QualifiedName operator = this.operatorMapping.getOperator(name);
            if (operator == null) {
                return IScope.NULLSCOPE;
            }
            return new SingletonScope(EObjectDescription.create((QualifiedName)operator, (EObject)feature), IScope.NULLSCOPE);
        }
        if (call instanceof XAssignment) {
            String propertyName = Strings.toFirstLower((String)feature.getSimpleName().substring(3));
            return new SingletonScope(EObjectDescription.create((String)propertyName, (EObject)feature), IScope.NULLSCOPE);
        }
        if (call.isExplicitOperationCallOrBuilderSyntax() || ((JvmExecutable)feature).getParameters().size() > 1 || !call.isExtension() && ((JvmExecutable)feature).getParameters().size() == 1) {
            return new SingletonScope(EObjectDescription.create((QualifiedName)name, (EObject)feature), IScope.NULLSCOPE);
        }
        if (feature.getSimpleName().startsWith("get") || feature.getSimpleName().startsWith("is")) {
            ArrayList result = Lists.newArrayListWithCapacity((int)2);
            result.add(EObjectDescription.create((QualifiedName)name, (EObject)feature));
            if (feature.getSimpleName().startsWith("get")) {
                String propertyName = Strings.toFirstLower((String)feature.getSimpleName().substring(3));
                result.add(EObjectDescription.create((String)propertyName, (EObject)feature));
            } else {
                String propertyName = Strings.toFirstLower((String)feature.getSimpleName().substring(2));
                result.add(EObjectDescription.create((String)propertyName, (EObject)feature));
            }
            return new SimpleScope((Iterable)result);
        }
        return new SingletonScope(EObjectDescription.create((QualifiedName)name, (EObject)feature), IScope.NULLSCOPE);
    }

    protected IScope getThisOrSuperScope(XAbstractFeatureCall call, JvmConstructor constructor) {
        JvmDeclaredType thisType;
        QualifiedName name = THIS;
        JvmIdentifiableElement logicalContainer = this.logicalContainerProvider.getNearestLogicalContainer(call);
        if (logicalContainer instanceof JvmConstructor && (thisType = ((JvmConstructor)logicalContainer).getDeclaringType()) != constructor.getDeclaringType()) {
            name = SUPER;
        }
        return new SingletonScope(EObjectDescription.create((QualifiedName)name, (EObject)constructor), IScope.NULLSCOPE);
    }

    protected IScope getTypeScope(XAbstractFeatureCall call, JvmType type) {
        if (call.isTypeLiteral() || call.isPackageFragment()) {
            return this.doGetTypeScope(call, type);
        }
        return this.getThisOrSuperScope(call, type);
    }

    protected IScope doGetTypeScope(XAbstractFeatureCall call, JvmType type) {
        if (call instanceof XFeatureCall) {
            return this.doGetTypeScope((XFeatureCall)call, type);
        }
        if (call instanceof XMemberFeatureCall) {
            return this.doGetTypeScope((XMemberFeatureCall)call, type);
        }
        return IScope.NULLSCOPE;
    }

    protected IScope doGetTypeScope(XFeatureCall call, JvmType type) {
        if (call.isPackageFragment()) {
            if (type instanceof JvmDeclaredType) {
                String packageName = ((JvmDeclaredType)type).getPackageName();
                int dot = packageName.indexOf(46);
                if (dot == -1) {
                    return new SingletonScope(EObjectDescription.create((String)packageName, (EObject)type), IScope.NULLSCOPE);
                }
                String firstSegment = packageName.substring(0, dot);
                return new SingletonScope(EObjectDescription.create((String)firstSegment, (EObject)type), IScope.NULLSCOPE);
            }
            return IScope.NULLSCOPE;
        }
        if (type instanceof JvmDeclaredType && ((JvmDeclaredType)type).getDeclaringType() != null) {
            XImportSection importSection;
            Resource resource = call.eResource();
            if (resource instanceof XtextResource && (importSection = this.importsConfiguration.getImportSection((XtextResource)resource)) != null) {
                EList<XImportDeclaration> importDeclarations = importSection.getImportDeclarations();
                ArrayList descriptions = Lists.newArrayList();
                for (XImportDeclaration importDeclaration : importDeclarations) {
                    String syntax;
                    if (importDeclaration.isStatic() || importDeclaration.isWildcard() || importDeclaration.isExtension()) continue;
                    JvmDeclaredType importedType = importDeclaration.getImportedType();
                    if (importedType == type && (syntax = this.importsConfiguration.getLegacyImportSyntax(importDeclaration)) != null && syntax.equals(type.getQualifiedName())) {
                        String packageName = importedType.getPackageName();
                        descriptions.add(EObjectDescription.create((String)syntax.substring(packageName.length() + 1), (EObject)type));
                    }
                    if (!EcoreUtil.isAncestor((EObject)importedType, (EObject)type)) continue;
                    String name = type.getSimpleName();
                    JvmType worker = type;
                    while (worker != importedType) {
                        worker = (JvmType)worker.eContainer();
                        name = String.valueOf(worker.getSimpleName()) + "$" + name;
                    }
                    descriptions.add(EObjectDescription.create((String)name, (EObject)type));
                }
                return new SimpleScope((Iterable)descriptions);
            }
            return new SingletonScope(EObjectDescription.create((String)type.getSimpleName(), (EObject)type), IScope.NULLSCOPE);
        }
        return new SingletonScope(EObjectDescription.create((String)type.getSimpleName(), (EObject)type), IScope.NULLSCOPE);
    }

    protected IScope doGetTypeScope(XMemberFeatureCall call, JvmType type) {
        if (call.isPackageFragment()) {
            if (type instanceof JvmDeclaredType) {
                int segmentIndex = this.countSegments(call);
                String packageName = ((JvmDeclaredType)type).getPackageName();
                List splitted = Strings.split((String)packageName, (char)'.');
                String segment = (String)splitted.get(segmentIndex);
                return new SingletonScope(EObjectDescription.create((String)segment, (EObject)type), IScope.NULLSCOPE);
            }
            return IScope.NULLSCOPE;
        }
        if (type instanceof JvmDeclaredType && ((JvmDeclaredType)type).getDeclaringType() == null) {
            return new SingletonScope(EObjectDescription.create((String)type.getSimpleName(), (EObject)type), IScope.NULLSCOPE);
        }
        XAbstractFeatureCall target = (XAbstractFeatureCall)call.getMemberCallTarget();
        if (target.isPackageFragment()) {
            String qualifiedName = type.getQualifiedName();
            int dot = qualifiedName.lastIndexOf(46);
            String simpleName = qualifiedName.substring(dot + 1);
            return new SingletonScope(EObjectDescription.create((String)simpleName, (EObject)type), IScope.NULLSCOPE);
        }
        return new SingletonScope(EObjectDescription.create((String)type.getSimpleName(), (EObject)type), IScope.NULLSCOPE);
    }

    private int countSegments(XMemberFeatureCall call) {
        int result = 1;
        while (call.getMemberCallTarget() instanceof XMemberFeatureCall) {
            call = (XMemberFeatureCall)call.getMemberCallTarget();
            ++result;
        }
        return result;
    }

    protected IScope getThisOrSuperScope(XAbstractFeatureCall call, JvmType thisOrSuper) {
        JvmDeclaredType thisType;
        QualifiedName name = THIS;
        JvmIdentifiableElement logicalContainer = this.logicalContainerProvider.getNearestLogicalContainer(call);
        if (logicalContainer instanceof JvmMember && (thisType = ((JvmMember)logicalContainer).getDeclaringType()) != thisOrSuper) {
            name = SUPER;
        }
        return new SingletonScope(EObjectDescription.create((QualifiedName)name, (EObject)thisOrSuper), IScope.NULLSCOPE);
    }
}

