/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.file;

import com.google.common.base.Objects;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.xbase.file.AbstractFileSystemSupport;
import org.eclipse.xtext.xbase.file.WorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaIOFileSystemSupport
extends AbstractFileSystemSupport {
    @Inject
    private Provider<WorkspaceConfig> _projectInformationProvider;

    public Provider<WorkspaceConfig> getProjectInformationProvider() {
        return this._projectInformationProvider;
    }

    public void setProjectInformationProvider(Provider<WorkspaceConfig> projectInformationProvider) {
        this._projectInformationProvider = projectInformationProvider;
    }

    public Iterable<? extends Path> getChildren(final Path path) {
        File _file = this.getFile(path);
        String[] _list = _file.list();
        Functions.Function1<String, Path> _function = new Functions.Function1<String, Path>(){

            public Path apply(String it) {
                Path _absolutePath = path.getAbsolutePath(it);
                return _absolutePath;
            }
        };
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_list)), (Functions.Function1)_function);
        return _map;
    }

    protected File getFile(Path path) {
        Provider<WorkspaceConfig> _projectInformationProvider = this.getProjectInformationProvider();
        WorkspaceConfig _get = (WorkspaceConfig)_projectInformationProvider.get();
        String _absoluteFileSystemPath = _get.getAbsoluteFileSystemPath();
        String _string = path.toString();
        File _file = new File(_absoluteFileSystemPath, _string);
        return _file;
    }

    public boolean exists(Path path) {
        File _file = this.getFile(path);
        boolean _exists = _file.exists();
        return _exists;
    }

    public boolean isFolder(Path path) {
        File _file = this.getFile(path);
        boolean _isDirectory = _file.isDirectory();
        return _isDirectory;
    }

    public boolean isFile(Path path) {
        File _file = this.getFile(path);
        boolean _isFile = _file.isFile();
        return _isFile;
    }

    public long getLastModification(Path path) {
        File _file = this.getFile(path);
        long _lastModified = _file.lastModified();
        return _lastModified;
    }

    public String getCharset(Path path) {
        IEncodingProvider _encodingProvider = this.getEncodingProvider();
        File _file = this.getFile(path);
        String _absolutePath = _file.getAbsolutePath();
        URI _createFileURI = URI.createFileURI((String)_absolutePath);
        return _encodingProvider.getEncoding(_createFileURI);
    }

    public InputStream getContentsAsStream(Path path) {
        try {
            File _file = this.getFile(path);
            FileInputStream _fileInputStream = new FileInputStream(_file);
            return _fileInputStream;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean mkdir(Path path) {
        boolean _notEquals;
        boolean _exists = this.exists(path);
        if (_exists) {
            return false;
        }
        Path parent = path.getParent();
        boolean bl = _notEquals = !Objects.equal((Object)parent, null);
        if (_notEquals) {
            this.mkdir(parent);
        }
        File _file = this.getFile(path);
        _file.mkdir();
        return true;
    }

    public boolean delete(Path path) {
        block4: {
            try {
                boolean _not;
                boolean _exists = this.exists(path);
                boolean bl = _not = !_exists;
                if (!_not) break block4;
                return false;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        File _file = this.getFile(path);
        boolean _isDirectory = _file.isDirectory();
        if (_isDirectory) {
            File _file_1 = this.getFile(path);
            Files.sweepFolder((File)_file_1);
        }
        File _file_2 = this.getFile(path);
        _file_2.delete();
        return true;
    }

    public void setContentsAsStream(Path path, InputStream stream) {
        try {
            Path _parent = path.getParent();
            this.mkdir(_parent);
            File _file = this.getFile(path);
            FileOutputStream _fileOutputStream = new FileOutputStream(_file);
            ByteStreams.copy((InputStream)stream, (OutputStream)_fileOutputStream);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

