/**
 * Copyright (c) 2012 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.xtext.generator.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.generator.IInheriting.Util;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * @author Jan Koehnlein
 * @since 2.4
 */
@SuppressWarnings("all")
public class ValidatorNaming extends Naming {
  @Inject
  private Grammar grammar;
  
  public String getValidatorName(final Grammar g) {
    StringConcatenation _builder = new StringConcatenation();
    String _basePackageRuntime = this.basePackageRuntime(g);
    _builder.append(_basePackageRuntime, "");
    _builder.append(".validation.");
    String _name = GrammarUtil.getName(g);
    _builder.append(_name, "");
    _builder.append("Validator");
    String _string = _builder.toString();
    return _string;
  }
  
  public String getAbstractValidatorName() {
    StringConcatenation _builder = new StringConcatenation();
    String _basePackageRuntime = this.basePackageRuntime(this.grammar);
    _builder.append(_basePackageRuntime, "");
    _builder.append(".validation.Abstract");
    String _name = GrammarUtil.getName(this.grammar);
    _builder.append(_name, "");
    _builder.append("Validator");
    String _string = _builder.toString();
    return _string;
  }
  
  public String getValidatorSuperClassName(final boolean isInheritImplementation) {
    String _xblockexpression = null;
    {
      final Grammar superGrammar = Util.getNonTerminalsSuperGrammar(this.grammar);
      String _xifexpression = null;
      boolean _and = false;
      if (!isInheritImplementation) {
        _and = false;
      } else {
        boolean _notEquals = (!Objects.equal(superGrammar, null));
        _and = (isInheritImplementation && _notEquals);
      }
      if (_and) {
        String _validatorName = this.getValidatorName(superGrammar);
        _xifexpression = _validatorName;
      } else {
        _xifexpression = "org.eclipse.xtext.validation.AbstractDeclarativeValidator";
      }
      _xblockexpression = (_xifexpression);
    }
    return _xblockexpression;
  }
  
  public String getGeneratedEPackageName(final EPackage pack) {
    StringConcatenation _builder = new StringConcatenation();
    String _basePackageRuntime = this.basePackageRuntime(this.grammar);
    _builder.append(_basePackageRuntime, "");
    _builder.append(".");
    String _name = pack.getName();
    _builder.append(_name, "");
    _builder.append(".");
    String _name_1 = pack.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name_1);
    _builder.append(_firstUpper, "");
    _builder.append("Package");
    return _builder.toString();
  }
  
  public String fileHeader() {
    return "* generated by Xtext";
  }
}
