/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.refactoring;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.refactoring.impl.DisplayChangeWrapper;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.ui.refactoring.ExpressionUtil;
import org.eclipse.xtext.xbase.ui.refactoring.IndentationUtil;
import org.eclipse.xtext.xbase.ui.refactoring.NewFeatureNameUtil;
import org.eclipse.xtext.xbase.ui.refactoring.TypeSerializationUtil;

public class ExtractVariableRefactoring
extends Refactoring {
    public static final Logger LOG = Logger.getLogger(ExtractVariableRefactoring.class);
    private IDocument document;
    private XExpression expression;
    private String variableName;
    private boolean isFinal = true;
    @Inject
    private Provider<StatusWrapper> statusProvider;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private ExpressionUtil expressionUtil;
    @Inject
    private NewFeatureNameUtil nameUtil;
    @Inject
    private IndentationUtil indentationUtil;
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private TypeSerializationUtil serializer;
    private URI resourceURI;
    private boolean isNeedsNewBlock;
    private XExpression successor;
    private MultiTextEdit textEdit;

    public boolean initialize(IXtextDocument document, XExpression expression) {
        this.document = document;
        this.expression = expression;
        this.resourceURI = EcoreUtil2.getNormalizedResourceURI((EObject)expression);
        this.successor = this.expressionUtil.findSuccessorExpressionForVariableDeclaration((EObject)expression);
        if (this.successor == null) {
            return false;
        }
        this.isNeedsNewBlock = !(this.successor.eContainer() instanceof XBlockExpression);
        this.indentationUtil.initialize((IDocument)document, this.resourceURI);
        this.nameUtil.setFeatureScopeContext(this.successor);
        this.variableName = this.nameUtil.getDefaultName(expression);
        return true;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public RefactoringStatus validateNewVariableName(String newVariableName) {
        RefactoringStatus status = new RefactoringStatus();
        this.nameUtil.checkNewFeatureName(newVariableName, true, status);
        return status;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public String getName() {
        return "Extract Local Variable Refactoring";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        StatusWrapper status = (StatusWrapper)this.statusProvider.get();
        return status.getRefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        StatusWrapper status = (StatusWrapper)this.statusProvider.get();
        try {
            String expressionExpanded;
            status.merge(this.validateNewVariableName(this.variableName));
            ITextRegion expressionRegion = this.locationInFileProvider.getFullTextRegion((EObject)this.expression);
            String expressionAsString = this.createInsertExpression(expressionRegion);
            ITextRegion successorRegion = this.locationInFileProvider.getFullTextRegion((EObject)this.successor);
            int indentationLevel = this.indentationUtil.getIndentationLevelAtOffset(successorRegion.getOffset());
            this.textEdit = new MultiTextEdit();
            if (this.isNeedsNewBlock) {
                this.createInsertNewBlockEdits(expressionAsString, successorRegion, indentationLevel);
            } else {
                this.createInsertInBlockEdits(expressionAsString, successorRegion, indentationLevel);
            }
            String callerText = this.variableName;
            if (!(!(this.expression.eContainer() instanceof XMemberFeatureCall) || ((XMemberFeatureCall)this.expression.eContainer()).getMemberCallArguments().size() != 1 || (expressionExpanded = this.document.get(expressionRegion.getOffset() - 1, expressionRegion.getLength() + 2)).startsWith("(") && expressionExpanded.endsWith(")"))) {
                callerText = "(" + callerText + ")";
            }
            this.textEdit.addChild((TextEdit)new ReplaceEdit(expressionRegion.getOffset(), expressionRegion.getLength(), callerText));
        }
        catch (Exception exc) {
            this.handleException(exc, status);
        }
        return status.getRefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        DocumentChange change = new DocumentChange("Extract local variable", this.document);
        change.setEdit((TextEdit)this.textEdit);
        change.setTextType(this.resourceURI.fileExtension());
        return new DisplayChangeWrapper((Change)change);
    }

    protected void handleException(Exception exc, StatusWrapper status) {
        status.add(4, "Error during refactoring: {0}", exc, LOG);
    }

    protected void createInsertInBlockEdits(String expressionAsString, ITextRegion successorRegion, int indentationLevel) {
        StringBuilder declaration = new StringBuilder();
        declaration.append(this.createDeclarationString(expressionAsString)).append(this.indentationUtil.getLineSeparator()).append(this.indentationUtil.indent(indentationLevel));
        this.textEdit.addChild((TextEdit)new InsertEdit(successorRegion.getOffset(), declaration.toString()));
    }

    protected void createInsertNewBlockEdits(String expressionAsString, ITextRegion successorRegion, int indentationLevel) throws BadLocationException {
        StringBuilder declaration = new StringBuilder();
        IRegion lineInformation = this.document.getLineInformationOfOffset(successorRegion.getOffset());
        int previousLineEnd = lineInformation.getOffset() - this.indentationUtil.getLineSeparator().length();
        if (previousLineEnd > 0 && !Character.isWhitespace(this.document.getChar(previousLineEnd - 1))) {
            declaration.append(" ");
        }
        declaration.append("{").append(this.indentationUtil.getLineSeparator()).append(this.indentationUtil.indent(indentationLevel)).append(this.createDeclarationString(expressionAsString));
        this.textEdit.addChild((TextEdit)new InsertEdit(Math.max(0, previousLineEnd), declaration.toString()));
        StringBuilder blockClosing = new StringBuilder();
        blockClosing.append(this.indentationUtil.getLineSeparator()).append(this.indentationUtil.indent(indentationLevel - 1)).append("}");
        this.textEdit.addChild((TextEdit)new InsertEdit(successorRegion.getOffset() + successorRegion.getLength(), blockClosing.toString()));
    }

    protected String createInsertExpression(ITextRegion expressionRegion) throws BadLocationException {
        String expressionAsString = this.document.get(expressionRegion.getOffset(), expressionRegion.getLength());
        if (this.expression instanceof XClosure) {
            XClosure closure = (XClosure)this.expression;
            StringBuilder builder = new StringBuilder();
            if (expressionAsString.startsWith("[") && expressionAsString.endsWith("]")) {
                expressionAsString = expressionAsString.substring(1, expressionAsString.length() - 1);
            }
            builder.append("[");
            boolean isFirst = true;
            for (JvmFormalParameter parameter : closure.getFormalParameters()) {
                if (!isFirst) {
                    builder.append(", ");
                }
                isFirst = false;
                builder.append(this.serializer.serialize(this.typeProvider.getTypeForIdentifiable((JvmIdentifiableElement)parameter), (EObject)this.expression)).append(" ").append(parameter.getIdentifier());
            }
            builder.append(" | ");
            if (!closure.getDeclaredFormalParameters().isEmpty()) {
                builder.append(expressionAsString.substring(expressionAsString.indexOf("|") + 1));
            } else {
                builder.append(expressionAsString);
            }
            builder.append("]");
            return builder.toString();
        }
        return expressionAsString;
    }

    protected String createDeclarationString(String expressionAsString) {
        StringBuilder builder = new StringBuilder();
        if (this.isFinal) {
            builder.append("val ");
        } else {
            builder.append("var ");
        }
        builder.append(this.variableName).append(" = ").append(expressionAsString);
        return builder.toString();
    }
}

