/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import com.google.inject.Inject;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.builder.trace.AbstractTrace;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperJdtExtensions;
import org.eclipse.xtext.util.Pair;

@NonNullByDefault
public class StorageAwareTrace
extends AbstractTrace {
    private static final Logger log = Logger.getLogger(StorageAwareTrace.class);
    private IStorage localStorage;
    private String projectName;
    @Inject
    private IStorage2UriMapper storage2UriMapper;

    public IStorage getLocalStorage() {
        return this.localStorage;
    }

    public URI getLocalURI() {
        IStorage localStorage = this.getLocalStorage();
        return this.getURIForStorage(localStorage);
    }

    public IProject getLocalProject() {
        return this.findProject(this.projectName);
    }

    protected URI resolvePath(URI path) {
        if (!path.isRelative()) {
            return path;
        }
        if (this.localStorage instanceof IFile) {
            IProject project = ((IFile)this.localStorage).getProject();
            if (project != null) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                if (javaProject != null && javaProject.exists()) {
                    return this.resolvePath(javaProject, path);
                }
                return this.resolvePath(project, path);
            }
        } else if (this.localStorage instanceof IJarEntryResource) {
            return this.resolvePath((IJarEntryResource)this.localStorage, path);
        }
        return path;
    }

    protected URI resolvePath(IJarEntryResource jarEntry, URI path) {
        IPackageFragmentRoot packageFragmentRoot = jarEntry.getPackageFragmentRoot();
        try {
            URI first;
            IStorage2UriMapperJdtExtensions uriMapperJdtExtensions = (IStorage2UriMapperJdtExtensions)this.storage2UriMapper;
            Pair pair = uriMapperJdtExtensions.getURIMapping(packageFragmentRoot);
            if (pair != null && (first = (URI)pair.getFirst()) != null) {
                return URI.createURI((String)(first + "/" + path));
            }
        }
        catch (JavaModelException e) {
            log.error((Object)e);
        }
        return path;
    }

    protected URI resolvePath(IJavaProject javaProject, URI path) {
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFolder folder;
                IResource candidate;
                IResource resource;
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getKind() == 1 && (resource = root.getResource()) instanceof IFolder && (candidate = (folder = (IFolder)resource).findMember(path.toString())) != null && candidate.exists()) {
                    return URI.createPlatformResourceURI((String)(resource.getFullPath() + "/" + path), (boolean)true);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            log.error((Object)e);
        }
        return this.resolvePath(javaProject.getProject(), path);
    }

    protected URI resolvePath(IProject project, URI path) {
        IResource candidate = project.findMember(path.toString());
        if (candidate != null && candidate.exists()) {
            return URI.createPlatformResourceURI((String)(project.getFullPath() + "/" + path), (boolean)true);
        }
        return path;
    }

    protected void setLocalStorage(IStorage derivedResource) {
        this.localStorage = derivedResource;
        if (derivedResource instanceof IResource) {
            this.projectName = ((IResource)derivedResource).getProject().getName();
        }
    }

    protected IStorage findStorage(URI uri, IProject project) {
        Iterable allStorages = this.getStorage2uriMapper().getStorages(this.resolvePath(uri));
        for (Pair storage : allStorages) {
            if (!project.equals(storage.getSecond())) continue;
            return (IStorage)storage.getFirst();
        }
        throw new IllegalStateException("No storage found for given path: " + uri);
    }

    protected InputStream getContents(URI uri, IProject project) throws CoreException {
        return this.findStorage(uri, project).getContents();
    }
}

