/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.smap;

import com.google.inject.Inject;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.xtext.builder.trace.ITraceForTypeRootProvider;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;

public class XbaseBreakpointUtil {
    private static final Logger logger = Logger.getLogger(XbaseBreakpointUtil.class);
    @Inject
    private ITraceForTypeRootProvider traceForTypeRootProvider;

    protected IResource getBreakpointResource(IMember member) {
        IResource res;
        ICompilationUnit cu = member.getCompilationUnit();
        if (cu != null && cu.isWorkingCopy()) {
            member = (IMember)member.getPrimaryElement();
        }
        if ((res = member.getResource()) == null) {
            res = ResourcesPlugin.getWorkspace().getRoot();
        } else if (!res.getProject().exists()) {
            res = ResourcesPlugin.getWorkspace().getRoot();
        }
        return res;
    }

    public IResource getBreakpointResource(IEditorInput input) throws CoreException {
        Object adapter = input.getAdapter(IResource.class);
        if (adapter != null) {
            return (IResource)adapter;
        }
        if (input instanceof IStorageEditorInput) {
            IStorage storage = ((IStorageEditorInput)input).getStorage();
            if (storage instanceof IResource) {
                return (IResource)storage;
            }
            if (storage instanceof IJarEntryResource) {
                return ((IJarEntryResource)storage).getPackageFragmentRoot().getUnderlyingResource();
            }
        } else if (input instanceof IClassFileEditorInput) {
            IClassFile classFile = ((IClassFileEditorInput)input).getClassFile();
            return this.getBreakpointResource((IMember)classFile.findPrimaryType());
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public URI getBreakpointURI(IEditorInput input) {
        block11: {
            Object adapter = input.getAdapter(IResource.class);
            if (adapter != null) {
                return null;
            }
            if (input instanceof IStorageEditorInput) {
                IJarEntryResource jarEntryResource;
                IStorage storage;
                block12: {
                    block10: {
                        try {
                            storage = ((IStorageEditorInput)input).getStorage();
                            if (!(storage instanceof IResource)) break block10;
                            return null;
                        }
                        catch (CoreException e) {
                            logger.error((Object)e);
                            return null;
                        }
                    }
                    if (!(storage instanceof IJarEntryResource)) break block11;
                    jarEntryResource = (IJarEntryResource)storage;
                    if (jarEntryResource.getPackageFragmentRoot().isArchive()) break block12;
                    return null;
                }
                Object parent = jarEntryResource.getParent();
                if (parent instanceof IPackageFragment) {
                    String path = ((IPackageFragment)parent).getElementName().replace('.', '/');
                    return URI.createURI((String)(String.valueOf(path) + "/" + storage.getName()));
                }
                if (parent instanceof IPackageFragmentRoot) {
                    return URI.createURI((String)storage.getName());
                }
                break block11;
            }
            if (input instanceof IClassFileEditorInput) {
                IClassFile classFile = ((IClassFileEditorInput)input).getClassFile();
                ITrace traceToSource = this.traceForTypeRootProvider.getTraceToSource((ITypeRoot)classFile);
                Iterator iterator = traceToSource.getAllAssociatedLocations().iterator();
                if (iterator.hasNext()) {
                    ILocationInResource loc = (ILocationInResource)iterator.next();
                    return loc.getSrcRelativeResourceURI();
                }
                return null;
            }
        }
        return null;
    }
}

