/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.arguments.IFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractPendingLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkHelper;
import org.eclipse.xtext.xbase.typesystem.internal.ImplicitFirstArgument;
import org.eclipse.xtext.xbase.typesystem.internal.ImplicitReceiver;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeExpectation;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.DeferredTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class FeatureLinkingCandidate
extends AbstractPendingLinkingCandidate<XAbstractFeatureCall>
implements IFeatureLinkingCandidate,
IFeatureNames {
    public FeatureLinkingCandidate(XAbstractFeatureCall featureCall, IIdentifiableElementDescription description, ExpressionTypeComputationState state) {
        super(featureCall, description, state);
    }

    @Override
    protected boolean isRawTypeContext() {
        LightweightTypeReference receiverType = this.getReceiverType();
        return receiverType != null && receiverType.isRawType();
    }

    @Override
    protected IFeatureLinkingCandidate getThis() {
        return this;
    }

    @Override
    protected void initializeMapping(JvmTypeParameter typeParameter, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> result) {
        ITypeReferenceOwner owner = this.getState().getReferenceOwner();
        if (typeParameter.getDeclarator() instanceof JvmType && owner.getDeclaredTypeParameters().contains(typeParameter)) {
            ParameterizedTypeReference typeReference = new ParameterizedTypeReference(owner, (JvmType)typeParameter);
            result.put(typeParameter, new LightweightMergedBoundTypeArgument(typeReference, VarianceInfo.INVARIANT));
        } else {
            super.initializeMapping(typeParameter, result);
        }
    }

    @Override
    protected List<XExpression> getArguments() {
        List<XExpression> syntacticArguments = this.getSyntacticArguments();
        XExpression firstArgument = this.getFirstArgument();
        if (firstArgument != null) {
            return this.createArgumentList(firstArgument, syntacticArguments);
        }
        return syntacticArguments;
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        if (this.isStatic() && !this.isExtension() && this.isInstanceAccessSyntax()) {
            String message = String.format("The static %1$s %2$s%3$s should be accessed in a static way", this.getFeatureTypeName(), this.getFeature().getSimpleName(), this.getFeatureParameterTypesAsString());
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member", message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        if (!this.isStatic() && this.isStaticAccessSyntax()) {
            EObject featureOwner = this.getFeature().eContainer();
            String message = String.format("Cannot make a static reference to the non-static %1$s %2$s%3$s", this.getFeatureTypeName(), this.getFeature().getSimpleName(), this.getFeatureParameterTypesAsString());
            if (featureOwner instanceof JvmDeclaredType) {
                message = String.valueOf(message) + " from the type " + ((JvmDeclaredType)featureOwner).getSimpleName();
            }
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member", message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        if (super.validate(result)) {
            XClosure containingClosure;
            JvmIdentifiableElement feature;
            if (this.isExplicitOperationCallOrBuilderSyntax() && !(this.getFeature() instanceof JvmExecutable)) {
                String typeName = this.getFeatureTypeName();
                String code = "org.eclipse.xtext.xbase.validation.IssueCodes.field_access_with_parentheses";
                if (!(this.getFeature() instanceof JvmField)) {
                    code = "org.eclipse.xtext.xbase.validation.IssueCodes.local_var_access_with_parentheses";
                }
                String message = "Cannot access the " + typeName + " " + this.getFeature().getSimpleName() + " with parentheses";
                EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, code, message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                result.accept((Object)diagnostic);
                return false;
            }
            if (this.getFeature() instanceof JvmType && !this.getState().isInstanceContext()) {
                String featureName = this.getFeatureCall().getConcreteSyntaxFeatureName();
                if (!SELF.getFirstSegment().equals(featureName)) {
                    String message = String.format("Cannot use %s in a static context", this.getFeatureCall().getConcreteSyntaxFeatureName());
                    EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member", message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                    result.accept((Object)diagnostic);
                    return false;
                }
            }
            if ((feature = this.getFeature()) instanceof XVariableDeclaration && ((XVariableDeclaration)feature).isWriteable() && (containingClosure = (XClosure)EcoreUtil2.getContainerOfType(this.getExpression(), XClosure.class)) != null && !EcoreUtil.isAncestor((EObject)containingClosure, (EObject)feature)) {
                String message = String.format("Cannot refer to the non-final variable %s inside a lambda expression", feature.getSimpleName());
                EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_mutable_variable_access", message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                result.accept((Object)diagnostic);
                return false;
            }
        }
        return true;
    }

    protected boolean isExplicitOperationCallOrBuilderSyntax() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XBinaryOperation || featureCall instanceof XAssignment) {
            return false;
        }
        return featureCall.isExplicitOperationCallOrBuilderSyntax();
    }

    @Override
    protected String getFeatureTypeName() {
        JvmIdentifiableElement feature = this.getFeature();
        if (feature instanceof JvmFormalParameter) {
            return "parameter";
        }
        if (feature instanceof XVariableDeclaration) {
            return "local variable";
        }
        if (feature instanceof JvmField) {
            return "field";
        }
        if (feature instanceof JvmOperation) {
            return "method";
        }
        if (feature instanceof JvmConstructor) {
            return "constructor";
        }
        if (feature instanceof JvmType) {
            return "type";
        }
        throw new IllegalStateException();
    }

    protected boolean isStaticAccessSyntax() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XFeatureCall) {
            return ((XFeatureCall)featureCall).getDeclaringType() != null;
        }
        return false;
    }

    protected boolean isInstanceAccessSyntax() {
        if (this.getImplicitReceiverType() != null) {
            return true;
        }
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XAssignment) {
            return ((XAssignment)featureCall).getAssignable() != null;
        }
        return featureCall instanceof XMemberFeatureCall;
    }

    protected List<XExpression> createArgumentList(XExpression head, List<XExpression> tail) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)(tail.size() + 1));
        result.add(head);
        for (XExpression expression : tail) {
            result.add(expression);
        }
        return result;
    }

    @Override
    public int getArityMismatch() {
        int result = super.getArityMismatch();
        if (this.isStatic() && (this.getImplicitReceiver() != null || this.getSyntacticReceiver() != null && !this.isExtension())) {
            result = result < 0 ? --result : ++result;
        }
        return result;
    }

    @Override
    protected List<XExpression> getSyntacticArguments() {
        return new FeatureLinkHelper().getSyntacticArguments(this.getFeatureCall());
    }

    @Override
    public boolean isExtension() {
        return this.description.isExtension();
    }

    @Override
    protected boolean hasReceiver() {
        return !this.isStatic();
    }

    @Override
    public boolean isStatic() {
        return this.description.isStatic();
    }

    @Override
    protected EnumSet<ConformanceHint> getConformanceHints(int idx, boolean recompute) {
        if (idx == 0 && this.getReceiver() != null) {
            EnumSet<ConformanceHint> result = this.getReceiverConformanceHints();
            return result;
        }
        return super.getConformanceHints(idx, recompute);
    }

    @Override
    @Nullable
    protected LightweightTypeReference getSubstitutedExpectedType(int idx) {
        if (idx == 0 && this.getReceiver() != null) {
            return null;
        }
        return super.getSubstitutedExpectedType(idx);
    }

    protected boolean isExplicitOperationCall() {
        return this.getFeatureCall().isExplicitOperationCallOrBuilderSyntax();
    }

    @Override
    protected int compareByArityWith(AbstractPendingLinkingCandidate<?> right) {
        boolean isExecutable;
        int result = super.compareByArityWith(right);
        if (result == 0 && (isExecutable = this.getFeature() instanceof JvmExecutable) != right.getFeature() instanceof JvmExecutable && this.isVisible() == right.isVisible()) {
            if (this.getExpression() instanceof XAssignment) {
                if (isExecutable) {
                    return 1;
                }
                return -1;
            }
            if (this.isExplicitOperationCall()) {
                if (isExecutable) {
                    return -1;
                }
                return 1;
            }
            if (isExecutable) {
                return 1;
            }
            return -1;
        }
        return result;
    }

    @Override
    protected int compareByArgumentTypes(AbstractPendingLinkingCandidate<?> right, int argumentIndex, EnumSet<ConformanceHint> leftConformance, EnumSet<ConformanceHint> rightConformance) {
        boolean rightFirstArgumentMismatch;
        int result = super.compareByArgumentTypes(right, argumentIndex, leftConformance, rightConformance);
        if (result != 0 || leftConformance.contains((Object)ConformanceHint.SUCCESS) || !(right instanceof FeatureLinkingCandidate)) {
            return result;
        }
        boolean firstArgumentMismatch = this.isFirstArgument(argumentIndex);
        if (firstArgumentMismatch != (rightFirstArgumentMismatch = ((FeatureLinkingCandidate)right).isFirstArgument(argumentIndex))) {
            if (firstArgumentMismatch) {
                return 1;
            }
            return -1;
        }
        return result;
    }

    protected boolean isFirstArgument(int argumentIndex) {
        if (argumentIndex > 1 || this.getFirstArgument() == null) {
            return false;
        }
        if (this.isStatic()) {
            return argumentIndex == 0;
        }
        return argumentIndex == 1;
    }

    @Override
    protected int compareByArgumentTypes(AbstractPendingLinkingCandidate<?> right, int leftBoxing, int rightBoxing, int leftDemand, int rightDemand) {
        if (leftDemand != rightDemand) {
            if (leftDemand < rightDemand) {
                return -1;
            }
            return 1;
        }
        if (right instanceof FeatureLinkingCandidate) {
            FeatureLinkingCandidate casted = (FeatureLinkingCandidate)right;
            if (this.isExtension() != casted.isExtension()) {
                if (this.isExtension()) {
                    return 1;
                }
                return -1;
            }
            if (this.isStatic() != casted.isStatic()) {
                if (this.isStatic()) {
                    return 1;
                }
                return -1;
            }
        }
        if (leftBoxing != rightBoxing) {
            if (leftBoxing < rightBoxing) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    @Override
    protected void preApply() {
        this.applyImplicitReceiver();
        super.preApply();
        XExpression implicitFirstArgument = this.getImplicitFirstArgument();
        if (implicitFirstArgument != null) {
            new ImplicitFirstArgument(this.getFeatureCall(), (XAbstractFeatureCall)implicitFirstArgument, this.getState()).applyToComputationState();
        }
    }

    protected void applyImplicitReceiver() {
        XExpression implicitReceiver;
        if (!this.isStatic() && (implicitReceiver = this.getImplicitReceiver()) != null) {
            ResolvedTypes resolvedTypes = this.getState().getResolvedTypes();
            LightweightTypeReference receiverType = this.getImplicitReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException("Cannot determine the receiver's type");
            }
            LightweightTypeReference expectedReceiverType = new FeatureLinkHelper().getExpectedReceiverType(this.getFeature(), receiverType);
            if (expectedReceiverType != null) {
                expectedReceiverType = expectedReceiverType.copyInto(resolvedTypes.getReferenceOwner());
            }
            TypeExpectation expectation = new TypeExpectation(expectedReceiverType, this.getState(), false);
            resolvedTypes.acceptType(implicitReceiver, expectation, receiverType.copyInto(resolvedTypes.getReferenceOwner()), false, ConformanceHint.UNCHECKED);
            if (implicitReceiver instanceof XAbstractFeatureCall) {
                new ImplicitReceiver(this.getFeatureCall(), (XAbstractFeatureCall)implicitReceiver, this.getState()).applyToComputationState();
            } else {
                throw new IllegalStateException("unexpected implicit receiver, was: " + implicitReceiver);
            }
        }
    }

    @Override
    protected void resolveAgainstActualType(LightweightTypeReference declaredType, LightweightTypeReference actualType, AbstractTypeComputationState state) {
        super.resolveAgainstActualType(declaredType, actualType, state);
        if (!this.isStatic()) {
            DeferredTypeParameterHintCollector collector = new DeferredTypeParameterHintCollector(state.getReferenceOwner());
            collector.processPairedReferences(declaredType, actualType);
        }
    }

    @Override
    public XAbstractFeatureCall getFeatureCall() {
        return (XAbstractFeatureCall)this.getExpression();
    }

    @Override
    protected List<LightweightTypeReference> getSyntacticTypeArguments() {
        return Lists.transform(this.getFeatureCall().getTypeArguments(), (Function)this.getState().getResolvedTypes().getConverter());
    }

    @Override
    protected void resolveArgumentType(XExpression argument, @Nullable LightweightTypeReference declaredType, ITypeComputationState argumentState) {
        if (argument == this.getSyntacticReceiver()) {
            LightweightTypeReference receiverType = this.getSyntacticReceiverType();
            if (receiverType != null) {
                this.resolveKnownArgumentType(argument, receiverType, declaredType, argumentState);
            }
        } else if (argument == this.getImplicitFirstArgument()) {
            LightweightTypeReference argumentType = this.getImplicitFirstArgumentType();
            if (argumentType != null) {
                this.resolveKnownArgumentType(argument, argumentType, declaredType, argumentState);
            }
        } else {
            super.resolveArgumentType(argument, declaredType, argumentState);
        }
    }

    protected void resolveKnownArgumentType(XExpression argument, LightweightTypeReference knownType, @Nullable LightweightTypeReference declaredType, ITypeComputationState argumentState) {
        if (!(argumentState instanceof AbstractTypeComputationState)) {
            throw new IllegalArgumentException("argumentState was " + argumentState);
        }
        AbstractTypeComputationState castedArgumentState = (AbstractTypeComputationState)argumentState;
        ResolvedTypes resolvedTypes = this.getState().getResolvedTypes();
        LightweightTypeReference copiedDeclaredType = declaredType != null ? declaredType.copyInto(resolvedTypes.getReferenceOwner()) : null;
        TypeExpectation expectation = new TypeExpectation(copiedDeclaredType, castedArgumentState, false);
        LightweightTypeReference copiedReceiverType = knownType.copyInto(resolvedTypes.getReferenceOwner());
        resolvedTypes.acceptType(argument, expectation, copiedReceiverType, false, ConformanceHint.UNCHECKED);
        if (copiedDeclaredType != null) {
            this.resolveAgainstActualType(copiedDeclaredType, copiedReceiverType, castedArgumentState);
        }
    }

    @Override
    protected void computeVarArgumentType(IFeatureCallArgumentSlot slot, TypeParameterSubstitutor<?> substitutor) {
        List<XExpression> arguments;
        if (this.isExtension() && (arguments = slot.getArgumentExpressions()).size() == 1 && arguments.get(0) == this.getFirstArgument()) {
            this.computeFixedArityArgumentType(slot, substitutor);
            return;
        }
        super.computeVarArgumentType(slot, substitutor);
    }

    @Override
    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getDeclaratorParameterMapping() {
        if (this.isStatic()) {
            if (this.getFeature() instanceof JvmConstructor) {
                return this.description.getImplicitReceiverTypeParameterMapping();
            }
            return super.getDeclaratorParameterMapping();
        }
        if (this.getImplicitReceiver() != null) {
            return this.description.getImplicitReceiverTypeParameterMapping();
        }
        return this.description.getSyntacticReceiverTypeParameterMapping();
    }

    @Nullable
    protected XExpression getReceiver() {
        if (this.isStatic()) {
            return null;
        }
        XExpression result = this.getImplicitReceiver();
        if (result != null) {
            return result;
        }
        return this.getSyntacticReceiver();
    }

    @Nullable
    protected LightweightTypeReference getReceiverType() {
        if (this.isStatic()) {
            return null;
        }
        LightweightTypeReference result = this.getImplicitReceiver() != null ? this.getImplicitReceiverType() : this.getSyntacticReceiverType();
        return result;
    }

    protected EnumSet<ConformanceHint> getReceiverConformanceHints() {
        if (this.isStatic()) {
            throw new IllegalStateException();
        }
        if (this.getImplicitReceiver() != null) {
            return this.description.getImplicitReceiverConformanceHints();
        }
        if (this.getSyntacticReceiver() != null) {
            return this.description.getSyntacticReceiverConformanceHints();
        }
        throw new IllegalStateException();
    }

    @Nullable
    protected XExpression getFirstArgument() {
        if (!this.isExtension()) {
            return null;
        }
        XExpression firstArgument = this.getImplicitFirstArgument();
        if (firstArgument != null) {
            return firstArgument;
        }
        return this.getSyntacticReceiver();
    }

    @Nullable
    protected LightweightTypeReference getFirstArgumentType() {
        if (!this.isExtension()) {
            return null;
        }
        LightweightTypeReference result = this.getImplicitFirstArgumentType();
        if (result != null) {
            return result;
        }
        return this.getSyntacticReceiverType();
    }

    @Nullable
    protected XExpression getImplicitReceiver() {
        return this.description.getImplicitReceiver();
    }

    @Nullable
    protected LightweightTypeReference getImplicitReceiverType() {
        return this.description.getImplicitReceiverType();
    }

    @Nullable
    protected XExpression getSyntacticReceiver() {
        return this.description.getSyntacticReceiver();
    }

    @Nullable
    protected LightweightTypeReference getSyntacticReceiverType() {
        return this.description.getSyntacticReceiverType();
    }

    @Nullable
    protected XExpression getImplicitFirstArgument() {
        return this.description.getImplicitFirstArgument();
    }

    @Nullable
    protected LightweightTypeReference getImplicitFirstArgumentType() {
        return this.description.getImplicitFirstArgumentType();
    }

    @Override
    protected LightweightTypeReference getDeclaredType(JvmIdentifiableElement feature) {
        JvmOperation getClassOperation;
        if (feature instanceof JvmConstructor) {
            return this.getState().getConverter().toLightweightReference(this.getState().getTypeReferences().getTypeForName(Void.TYPE, (Notifier)feature, new JvmTypeReference[0]));
        }
        if (feature instanceof JvmOperation && feature.getSimpleName().equals("getClass") && (getClassOperation = (JvmOperation)feature).getParameters().isEmpty() && "java.lang.Object".equals(getClassOperation.getDeclaringType().getIdentifier())) {
            LightweightTypeReference receiverType = this.getReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException("Cannot determine the receiver's type");
            }
            List<JvmType> rawTypes = receiverType.getRawTypes();
            if (rawTypes.isEmpty()) {
                return super.getDeclaredType(feature);
            }
            ParameterizedTypeReference result = new ParameterizedTypeReference(receiverType.getOwner(), getClassOperation.getReturnType().getType());
            WildcardTypeReference wildcard = new WildcardTypeReference(receiverType.getOwner());
            wildcard.addUpperBound(new ParameterizedTypeReference(receiverType.getOwner(), rawTypes.get(0)));
            result.addTypeArgument(wildcard);
            return result;
        }
        return super.getDeclaredType(feature);
    }

    @Override
    public void applyToModel() {
        this.resolveLinkingProxy(XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0);
    }
}

