/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.conformance;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.primitives.Booleans;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.xbase.typesystem.conformance.AbstractConformanceVisitor;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.conformance.SuperTypeAcceptor;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceResult;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceStrategySelector;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class TypeConformanceComputer {
    protected AbstractConformanceVisitor<LightweightTypeReference> leftDispatcher = this.createStrategySelector();

    @NonNull
    protected TypeConformanceStrategySelector createStrategySelector() {
        return new TypeConformanceStrategySelector(this);
    }

    public boolean isConformant(LightweightTypeReference left, LightweightTypeReference right) {
        return this.isConformant(left, right, false);
    }

    public boolean isConformant(LightweightTypeReference left, LightweightTypeReference right, boolean ignoreGenerics) {
        if (left == right && left != null) {
            return true;
        }
        TypeConformanceResult result = this.isConformant(left, right, new TypeConformanceComputationArgument(ignoreGenerics, false, true, true, false, false));
        return result.isConformant();
    }

    @NonNull
    public TypeConformanceResult isConformant(LightweightTypeReference left, LightweightTypeReference right, TypeConformanceComputationArgument flags) {
        if (left == right && left != null) {
            return TypeConformanceResult.create(flags, ConformanceHint.SUCCESS);
        }
        return (TypeConformanceResult)left.accept(this.leftDispatcher, TypeConformanceComputationArgument.Internal.create(right, flags.rawType, flags.asTypeArgument, flags.allowPrimitiveConversion, flags.allowPrimitiveWidening, flags.unboundComputationAddsHints, flags.allowSynonyms));
    }

    @Nullable
    public LightweightTypeReference getCommonSuperType(@NonNull List<LightweightTypeReference> types, ITypeReferenceOwner owner) {
        if (types == null || types.isEmpty()) {
            throw new IllegalArgumentException("Types can't be null or empty " + types);
        }
        if (types.size() == 1) {
            return types.get(0);
        }
        boolean allVoid = true;
        for (LightweightTypeReference type : types) {
            if (type.isPrimitiveVoid()) continue;
            allVoid = false;
            break;
        }
        if (allVoid) {
            return types.get(0);
        }
        for (LightweightTypeReference type : types) {
            LightweightTypeReference conformantType = this.conformsToAll(type, types);
            if (conformantType != null) {
                return conformantType;
            }
            if (!type.isPrimitiveVoid()) continue;
            return null;
        }
        if (this.containsPrimitiveOrAnyReferences(types)) {
            List<LightweightTypeReference> withoutPrimitives = this.replacePrimitivesAndRemoveAnyReferences(types);
            if (withoutPrimitives.equals(types)) {
                return null;
            }
            return this.getCommonSuperType(withoutPrimitives, owner);
        }
        LightweightTypeReference firstType = types.get(0);
        List<LightweightTypeReference> tail = types.subList(1, types.size());
        LinkedHashMultimap all = LinkedHashMultimap.create();
        LinkedHashMultiset cumulatedDistance = LinkedHashMultiset.create();
        this.initializeDistance(firstType, (Multimap<JvmType, LightweightTypeReference>)all, (Multiset<JvmType>)cumulatedDistance);
        this.cumulateDistance(tail, (Multimap<JvmType, LightweightTypeReference>)all, (Multiset<JvmType>)cumulatedDistance);
        ArrayList candidates = Lists.newArrayList((Iterable)cumulatedDistance.entrySet());
        if (candidates.size() == 1) {
            JvmType firstRawType = (JvmType)((Multiset.Entry)candidates.get(0)).getElement();
            return this.getFirstForRawType((Multimap<JvmType, LightweightTypeReference>)all, firstRawType);
        }
        this.inplaceSortByDistanceAndName(candidates);
        ArrayList referencesWithSameDistance = Lists.newArrayListWithExpectedSize((int)2);
        int wasDistance = -1;
        boolean classSeen = false;
        block2: for (Multiset.Entry rawTypeCandidate : candidates) {
            JvmType rawType = (JvmType)rawTypeCandidate.getElement();
            LightweightTypeReference result = null;
            if (wasDistance == -1) {
                wasDistance = rawTypeCandidate.getCount();
            } else if (wasDistance != rawTypeCandidate.getCount()) {
                if (classSeen) break;
                result = this.getTypeParametersForSupertype((Multimap<JvmType, LightweightTypeReference>)all, rawType, owner, types);
                for (LightweightTypeReference alreadyCollected : referencesWithSameDistance) {
                    if (!this.isConformant(result, alreadyCollected, true)) continue;
                    classSeen = classSeen || this.isClass(rawType);
                    continue block2;
                }
                wasDistance = rawTypeCandidate.getCount();
            }
            if (result == null) {
                result = this.getTypeParametersForSupertype((Multimap<JvmType, LightweightTypeReference>)all, rawType, owner, types);
            }
            if (result == null) continue;
            boolean isClass = this.isClass(rawType);
            boolean bl = classSeen = classSeen || isClass;
            if (isClass) {
                referencesWithSameDistance.add(0, result);
                continue;
            }
            referencesWithSameDistance.add(result);
        }
        if (referencesWithSameDistance.size() == 1) {
            return (LightweightTypeReference)referencesWithSameDistance.get(0);
        }
        if (referencesWithSameDistance.size() > 1) {
            CompoundTypeReference result = new CompoundTypeReference(owner, false);
            for (LightweightTypeReference reference : referencesWithSameDistance) {
                result.addComponent(reference);
            }
            return result;
        }
        return null;
    }

    protected boolean isClass(JvmType type) {
        if (type instanceof JvmArrayType) {
            return this.isClass((JvmType)((JvmArrayType)type).getComponentType());
        }
        return type instanceof JvmGenericType && !((JvmGenericType)type).isInterface();
    }

    protected List<LightweightTypeReference> replacePrimitivesAndRemoveAnyReferences(List<LightweightTypeReference> types) {
        ArrayList result = Lists.newArrayList();
        for (LightweightTypeReference type : types) {
            if (type instanceof AnyTypeReference) continue;
            result.add(type.getWrapperTypeIfPrimitive());
        }
        return result;
    }

    protected boolean containsPrimitiveOrAnyReferences(List<LightweightTypeReference> types) {
        for (LightweightTypeReference type : types) {
            if (!type.isPrimitive() && !(type instanceof AnyTypeReference)) continue;
            return true;
        }
        return false;
    }

    protected LightweightTypeReference getTypeParametersForSupertype(Multimap<JvmType, LightweightTypeReference> all, JvmType rawType, ITypeReferenceOwner owner, List<LightweightTypeReference> initiallyRequested) {
        if (rawType instanceof JvmTypeParameterDeclarator) {
            EList typeParameters = ((JvmTypeParameterDeclarator)rawType).getTypeParameters();
            if (typeParameters.isEmpty()) {
                return this.getFirstForRawType(all, rawType);
            }
            ArrayList parameterSuperTypes = Lists.newArrayListWithCapacity((int)typeParameters.size());
            int i = 0;
            while (i < typeParameters.size()) {
                ArrayList parameterReferences = Lists.newArrayListWithCapacity((int)typeParameters.size());
                for (LightweightTypeReference reference : all.get((Object)rawType)) {
                    if (reference instanceof ParameterizedTypeReference) {
                        ParameterizedTypeReference parameterized = (ParameterizedTypeReference)reference;
                        if (parameterized.getTypeArguments().isEmpty()) {
                            return parameterized;
                        }
                        LightweightTypeReference parameterReference = parameterized.getTypeArguments().get(i);
                        if (parameterized instanceof FunctionTypeReference && !(parameterReference instanceof WildcardTypeReference)) {
                            WildcardTypeReference wildcard;
                            FunctionTypeReference functionType = (FunctionTypeReference)parameterized;
                            if (i == typeParameters.size() - 1 && parameterReference.equals(functionType.getReturnType())) {
                                wildcard = new WildcardTypeReference(owner);
                                wildcard.addUpperBound(parameterReference);
                                parameterReferences.add(wildcard);
                                continue;
                            }
                            if (functionType.getParameterTypes().contains(parameterReference)) {
                                wildcard = this.createObjectWildcardReference(owner);
                                wildcard.setLowerBound(parameterReference);
                                parameterReferences.add(wildcard);
                                continue;
                            }
                            parameterReferences.add(parameterReference);
                            continue;
                        }
                        parameterReferences.add(parameterReference);
                        continue;
                    }
                    return null;
                }
                LightweightTypeReference parameterSuperType = this.getCommonParameterSuperType(parameterReferences, initiallyRequested, owner);
                if (parameterSuperType == null) {
                    return null;
                }
                parameterSuperTypes.add(parameterSuperType);
                ++i;
            }
            ParameterizedTypeReference result = new ParameterizedTypeReference(owner, rawType);
            for (LightweightTypeReference parameterSuperType : parameterSuperTypes) {
                result.addTypeArgument(parameterSuperType.copyInto(owner));
            }
            FunctionTypeReference resultAsFunctionType = result.getAsFunctionTypeReference();
            if (resultAsFunctionType != null) {
                return resultAsFunctionType;
            }
            return result;
        }
        if (rawType instanceof JvmArrayType) {
            JvmComponentType componentType = ((JvmArrayType)rawType).getComponentType();
            LinkedHashMultimap copiedMultimap = LinkedHashMultimap.create(all);
            Collection originalReferences = all.get((Object)rawType);
            ArrayList componentReferences = Lists.newArrayListWithCapacity((int)originalReferences.size());
            for (LightweightTypeReference originalReference : originalReferences) {
                this.addComponentType(originalReference, componentReferences);
            }
            copiedMultimap.replaceValues((Object)componentType, (Iterable)componentReferences);
            ArrayList componentRequests = Lists.newArrayListWithCapacity((int)initiallyRequested.size());
            for (LightweightTypeReference initialRequest : initiallyRequested) {
                this.addComponentType(initialRequest, componentRequests);
            }
            LightweightTypeReference componentTypeReference = this.getTypeParametersForSupertype((Multimap<JvmType, LightweightTypeReference>)copiedMultimap, (JvmType)componentType, owner, componentRequests);
            if (componentTypeReference != null) {
                return new ArrayTypeReference(owner, componentTypeReference);
            }
        }
        return null;
    }

    protected void addComponentType(LightweightTypeReference reference, List<LightweightTypeReference> result) {
        if (reference.isArray()) {
            result.add(((ArrayTypeReference)reference).getComponentType());
        } else {
            result.add(reference);
        }
    }

    protected LightweightTypeReference getFirstForRawType(Multimap<JvmType, LightweightTypeReference> all, JvmType rawType) {
        for (LightweightTypeReference result : all.get((Object)rawType)) {
            if (!(result instanceof ParameterizedTypeReference) && !(result instanceof ArrayTypeReference)) continue;
            return result;
        }
        throw new IllegalStateException(String.valueOf(all.toString()) + " does not contain a useful type reference for rawtype " + rawType.getQualifiedName());
    }

    protected void initializeDistance(LightweightTypeReference firstType, Multimap<JvmType, LightweightTypeReference> all, Multiset<JvmType> cumulatedDistance) {
        MaxDistanceRawTypeAcceptor acceptor = new MaxDistanceRawTypeAcceptor(cumulatedDistance, all);
        acceptor.accept(firstType, 0);
        firstType.collectSuperTypes(acceptor);
    }

    protected void cumulateDistance(List<LightweightTypeReference> references, Multimap<JvmType, LightweightTypeReference> all, Multiset<JvmType> cumulatedDistance) {
        for (LightweightTypeReference other : references) {
            LinkedHashMultiset otherDistance = LinkedHashMultiset.create();
            this.initializeDistance(other, all, (Multiset<JvmType>)otherDistance);
            cumulatedDistance.retainAll((Collection)otherDistance);
            for (Multiset.Entry typeToDistance : otherDistance.entrySet()) {
                if (!cumulatedDistance.contains(typeToDistance.getElement())) continue;
                cumulatedDistance.add((Object)((JvmType)typeToDistance.getElement()), typeToDistance.getCount());
            }
        }
    }

    protected void inplaceSortByDistanceAndName(List<Multiset.Entry<JvmType>> candidates) {
        Collections.sort(candidates, new Comparator<Multiset.Entry<JvmType>>(){

            @Override
            public int compare(Multiset.Entry<JvmType> o1, Multiset.Entry<JvmType> o2) {
                if (o1.getCount() == o2.getCount()) {
                    JvmType element1 = (JvmType)o1.getElement();
                    JvmType element2 = (JvmType)o2.getElement();
                    return this.compare(element1, element2);
                }
                if (o1.getCount() < o2.getCount()) {
                    return -1;
                }
                return 1;
            }

            @Override
            protected int compare(JvmType element1, JvmType element2) {
                int result;
                if (element1 instanceof JvmArrayType && element2 instanceof JvmArrayType) {
                    return this.compare((JvmType)((JvmArrayType)element1).getComponentType(), (JvmType)((JvmArrayType)element2).getComponentType());
                }
                if (element1 instanceof JvmGenericType && element2 instanceof JvmGenericType && (result = Booleans.compare((boolean)((JvmGenericType)element1).isInterface(), (boolean)((JvmGenericType)element2).isInterface())) != 0) {
                    return result;
                }
                return element1.getIdentifier().compareTo(element2.getIdentifier());
            }
        });
    }

    public LightweightTypeReference getCommonParameterSuperType(List<LightweightTypeReference> types, List<LightweightTypeReference> initiallyRequested, ITypeReferenceOwner owner) {
        LightweightTypeReference superType;
        LightweightTypeReference mostSpecialTypeIfAllWildcards = this.getMostSpecialTypeIfAllWildcards(types, owner);
        if (mostSpecialTypeIfAllWildcards != null) {
            if (mostSpecialTypeIfAllWildcards instanceof WildcardTypeReference) {
                return mostSpecialTypeIfAllWildcards;
            }
            WildcardTypeReference result = this.createObjectWildcardReference(owner);
            result.setLowerBound(mostSpecialTypeIfAllWildcards);
            return result;
        }
        HashSet allNames = Sets.newHashSet();
        HashSet allBoundNames = Sets.newHashSet();
        int i = 0;
        while (i < types.size()) {
            LightweightTypeReference type = types.get(i).getInvariantBoundSubstitute();
            types.set(i, type);
            this.addIdentifier(type, allNames, allBoundNames);
            ++i;
        }
        if (allNames.size() == 1) {
            return types.get(0);
        }
        if (types.size() == initiallyRequested.size()) {
            boolean containsAll = true;
            for (LightweightTypeReference initialRequest : initiallyRequested) {
                if (allNames.contains(this.getIdentifier(initialRequest))) continue;
                containsAll = false;
                break;
            }
            if (containsAll) {
                return this.createObjectWildcardReference(owner);
            }
        }
        if ((superType = this.getCommonSuperType(types, owner)) instanceof WildcardTypeReference) {
            return superType;
        }
        if (superType == null) {
            return this.createObjectWildcardReference(owner);
        }
        if (superType instanceof UnboundTypeReference) {
            return superType;
        }
        if (allBoundNames.size() != allNames.size() && allBoundNames.size() == 1 && allBoundNames.contains(this.getIdentifier(superType))) {
            return superType;
        }
        WildcardTypeReference result = new WildcardTypeReference(owner);
        result.addUpperBound(superType.copyInto(owner));
        return result;
    }

    private void addIdentifier(LightweightTypeReference type, Set<String> allNames, Set<String> allBoundNames) {
        if (type instanceof UnboundTypeReference && !type.isResolved()) {
            allNames.add(((UnboundTypeReference)type).getHandle().toString());
        } else {
            String identifier = type.getJavaIdentifier();
            allNames.add(identifier);
            allBoundNames.add(identifier);
        }
    }

    private String getIdentifier(LightweightTypeReference type) {
        if (type instanceof UnboundTypeReference && !type.isResolved()) {
            return ((UnboundTypeReference)type).getHandle().toString();
        }
        return type.getJavaIdentifier();
    }

    private LightweightTypeReference getMostSpecialTypeIfAllWildcards(List<LightweightTypeReference> types, ITypeReferenceOwner owner) {
        boolean objectIsCandidate = false;
        boolean lowerBoundSeen = false;
        for (LightweightTypeReference type : types) {
            if (type instanceof WildcardTypeReference) {
                if (((WildcardTypeReference)type).getLowerBound() == null) {
                    objectIsCandidate = true;
                    continue;
                }
                lowerBoundSeen = true;
                continue;
            }
            return null;
        }
        if (!lowerBoundSeen) {
            return null;
        }
        if (objectIsCandidate) {
            return this.createObjectWildcardReference(owner);
        }
        return this.getMostSpecialType(types);
    }

    public LightweightTypeReference getMostSpecialType(List<LightweightTypeReference> candidates) {
        LightweightTypeReference type = candidates.get(0).getLowerBoundSubstitute();
        int i = 1;
        while (i < candidates.size()) {
            LightweightTypeReference candidate = candidates.get(i).getLowerBoundSubstitute();
            if (type.isAssignableFrom(candidate)) {
                type = candidate;
            } else if (!candidate.isAssignableFrom(type)) {
                return null;
            }
            ++i;
        }
        return type;
    }

    protected WildcardTypeReference createObjectWildcardReference(ITypeReferenceOwner owner) {
        JvmType objectType = owner.getServices().getTypeReferences().findDeclaredType(Object.class, (Notifier)owner.getContextResourceSet());
        ParameterizedTypeReference objectReference = new ParameterizedTypeReference(owner, objectType);
        WildcardTypeReference result = new WildcardTypeReference(owner);
        result.addUpperBound(objectReference);
        return result;
    }

    protected LightweightTypeReference conformsToAll(LightweightTypeReference type, List<LightweightTypeReference> types) {
        LightweightTypeReference result = type;
        int i = 0;
        while (i < types.size()) {
            LightweightTypeReference other = types.get(i);
            if (result != other) {
                TypeConformanceResult conformance = this.isConformant(result, other, new TypeConformanceComputationArgument(false, false, true, true, true, false));
                if (conformance.isConformant()) {
                    boolean resultIsFunctionType = result instanceof FunctionTypeReference;
                    if (!resultIsFunctionType && other instanceof FunctionTypeReference && other.isAssignableFrom(result)) {
                        result = other;
                    }
                } else {
                    return null;
                }
            }
            ++i;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NonNullByDefault
    protected static class MaxDistanceRawTypeAcceptor
    implements SuperTypeAcceptor {
        private final Multiset<JvmType> distances;
        private final Multimap<JvmType, LightweightTypeReference> rawTypeToReference;

        protected MaxDistanceRawTypeAcceptor(Multiset<JvmType> result, Multimap<JvmType, LightweightTypeReference> all) {
            this.distances = result;
            this.rawTypeToReference = all;
        }

        @Override
        public boolean accept(LightweightTypeReference superType, int distance) {
            if (superType == null) {
                throw new IllegalStateException("superType may not be null");
            }
            JvmType type = superType.getType();
            if (type != null) {
                this.rawTypeToReference.put((Object)type, (Object)superType);
                if (this.distances.contains((Object)type)) {
                    int currentCount = this.distances.count((Object)type);
                    if (currentCount < distance + 1) {
                        this.distances.setCount((Object)type, distance + 1);
                    }
                } else {
                    this.distances.add((Object)type, distance + 1);
                }
            }
            return true;
        }
    }
}

