/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import com.google.inject.Inject;
import java.util.EnumSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;

public class SynonymTypesProvider {
    @Inject
    private TypeReferences typeReferences;

    public void collectSynonymTypes(@Nullable LightweightTypeReference type, @NonNull Acceptor acceptor) {
        if (type == null || type.isPrimitiveVoid() || type.isType(Void.class)) {
            return;
        }
        if (type.isWrapper() ? !acceptor.accept(type.getPrimitiveIfWrapperType(), ConformanceHint.UNBOXING) : type.isPrimitive() && !acceptor.accept(type.getWrapperTypeIfPrimitive(), ConformanceHint.BOXING)) {
            return;
        }
        this.addArrayAndListSynonyms(type, acceptor);
    }

    @NonNullByDefault
    protected void addArrayAndListSynonyms(LightweightTypeReference type, Acceptor acceptor) {
        ArrayTypeReference arrayType;
        if (type.isArray()) {
            LightweightTypeReference listType = type.tryConvertToListType();
            if (listType != null) {
                LightweightTypeReference componentType = type.getComponentType();
                if (componentType == null) {
                    throw new IllegalStateException("Component type of an array may not be null");
                }
                if (componentType.isPrimitive() ? !acceptor.accept(listType, EnumSet.of(ConformanceHint.DEMAND_CONVERSION, ConformanceHint.BOXING)) : !acceptor.accept(listType, ConformanceHint.DEMAND_CONVERSION)) {
                    return;
                }
            }
        } else if (type instanceof ParameterizedTypeReference && (arrayType = type.tryConvertToArray()) != null) {
            LightweightTypeReference componentType = arrayType.getComponentType();
            if (componentType.isWrapper()) {
                LightweightTypeReference primitiveComponentType = componentType.getPrimitiveIfWrapperType();
                ArrayTypeReference primitiveArray = new ArrayTypeReference(type.getOwner(), primitiveComponentType);
                if (!acceptor.accept((LightweightTypeReference)primitiveArray, EnumSet.of(ConformanceHint.DEMAND_CONVERSION, ConformanceHint.UNBOXING))) {
                    return;
                }
            }
            if (!acceptor.accept((LightweightTypeReference)arrayType, ConformanceHint.DEMAND_CONVERSION)) {
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NonNullByDefault
    public static abstract class Acceptor {
        protected boolean accept(LightweightTypeReference synonym, ConformanceHint hint) {
            return this.accept(synonym, EnumSet.of(hint, ConformanceHint.SUCCESS, ConformanceHint.CHECKED));
        }

        protected abstract boolean accept(LightweightTypeReference var1, EnumSet<ConformanceHint> var2);
    }
}

