/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.scoping.batch.AbstractFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.AbstractNestedFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.ContextualVisibilityHelper;

@NonNullByDefault
public class FeatureScopeSessionWithContext
extends AbstractNestedFeatureScopeSession {
    private ContextualVisibilityHelper visibilityHelper;

    public FeatureScopeSessionWithContext(AbstractFeatureScopeSession parent, LightweightTypeReference contextType) {
        super(parent);
        this.visibilityHelper = new ContextualVisibilityHelper(parent, contextType);
    }

    public FeatureScopeSessionWithContext(AbstractFeatureScopeSession parent, LightweightTypeReference contextType, String packageName) {
        super(parent);
        this.visibilityHelper = new ContextualVisibilityHelper(parent, contextType, packageName);
    }

    public boolean isVisible(JvmMember member) {
        return this.visibilityHelper.isVisible(member);
    }

    public boolean isVisible(JvmMember member, @Nullable JvmIdentifiableElement receiverFeature) {
        boolean result = this.isVisible(member);
        if (result && JvmVisibility.PROTECTED == member.getVisibility() && receiverFeature != null) {
            if (this.isThisOrSuper(receiverFeature)) {
                return true;
            }
            JvmType contextType = this.visibilityHelper.getRawContextType();
            if (contextType instanceof JvmDeclaredType) {
                String packageName = ((JvmDeclaredType)contextType).getPackageName();
                String memberPackageName = member.getDeclaringType().getPackageName();
                return Strings.equal((String)packageName, (String)memberPackageName);
            }
            return false;
        }
        return result;
    }

    protected boolean isThisOrSuper(JvmIdentifiableElement receiverFeature) {
        return receiverFeature instanceof JvmType;
    }
}

