/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportManager {
    private Map<String, String> imports = Maps.newHashMap();
    private boolean organizeImports;
    private Set<String> thisTypeSimpleNames = Sets.newHashSet();
    private Set<String> thisTypeQualifiedNames = Sets.newHashSet();
    private final char innerTypeSeparator;
    private Pattern JAVA_LANG_PACK = Pattern.compile("java\\.lang\\.[\\w]+");
    private boolean thisCollidesWithJavaLang;

    public ImportManager(boolean organizeImports, char innerTypeSeparator) {
        this(organizeImports, null, innerTypeSeparator);
    }

    public ImportManager() {
        this(true, null);
    }

    public ImportManager(boolean organizeImports) {
        this(organizeImports, null);
    }

    public ImportManager(boolean organizeImports, JvmDeclaredType thisType) {
        this(organizeImports, thisType, '.');
    }

    public ImportManager(boolean organizeImports, JvmDeclaredType thisType, char innerTypeSeparator) {
        this.organizeImports = organizeImports;
        this.innerTypeSeparator = innerTypeSeparator;
        if (thisType != null) {
            this.thisTypeSimpleNames.add(thisType.getSimpleName());
            this.thisTypeQualifiedNames.add(thisType.getQualifiedName(innerTypeSeparator));
            this.thisCollidesWithJavaLang = CodeGenUtil.isJavaLangType((String)thisType.getSimpleName());
            for (JvmMember jvmMember : Collections2.filter((Collection)thisType.getMembers(), (Predicate)Predicates.instanceOf(JvmDeclaredType.class))) {
                this.thisTypeSimpleNames.add(jvmMember.getSimpleName());
                this.thisTypeQualifiedNames.add(jvmMember.getQualifiedName(innerTypeSeparator));
                this.thisCollidesWithJavaLang |= CodeGenUtil.isJavaLangType((String)jvmMember.getSimpleName());
            }
        }
    }

    public CharSequence serialize(JvmType type) {
        StringBuilder sb = new StringBuilder();
        this.appendType(type, sb);
        return sb;
    }

    public void appendType(JvmType type, StringBuilder builder) {
        if (type instanceof JvmPrimitiveType || type instanceof JvmVoid || type instanceof JvmTypeParameter) {
            builder.append(type.getQualifiedName(this.innerTypeSeparator));
        } else if (type instanceof JvmArrayType) {
            this.appendType((JvmType)((JvmArrayType)type).getComponentType(), builder);
            builder.append("[]");
        } else {
            String simpleName;
            String qualifiedName = type.getQualifiedName(this.innerTypeSeparator);
            if (this.allowsSimpleName(qualifiedName, simpleName = type.getSimpleName())) {
                builder.append(simpleName);
            } else if (this.needsQualifiedName(qualifiedName, simpleName)) {
                builder.append(qualifiedName);
            } else if (this.imports.containsKey(simpleName)) {
                if (qualifiedName.equals(this.imports.get(simpleName))) {
                    builder.append(simpleName);
                } else {
                    builder.append(qualifiedName);
                }
            } else {
                this.imports.put(simpleName, qualifiedName);
                builder.append(simpleName);
            }
        }
    }

    protected boolean allowsSimpleName(String qualifiedName, String simpleName) {
        return this.thisTypeQualifiedNames.contains(qualifiedName) || !this.thisCollidesWithJavaLang && this.JAVA_LANG_PACK.matcher(qualifiedName).matches() || Strings.equal((String)qualifiedName, (String)simpleName);
    }

    protected boolean needsQualifiedName(String qualifiedName, String simpleName) {
        return !this.organizeImports || this.thisTypeSimpleNames.contains(simpleName) && !this.thisTypeQualifiedNames.contains(qualifiedName) || CodeGenUtil.isJavaLangType((String)simpleName);
    }

    public boolean addImportFor(JvmType type) {
        String simpleName;
        String qualifiedName = type.getQualifiedName(this.innerTypeSeparator);
        if (!(this.allowsSimpleName(qualifiedName, simpleName = type.getSimpleName()) || this.needsQualifiedName(qualifiedName, simpleName) || this.imports.containsKey(simpleName))) {
            this.imports.put(simpleName, qualifiedName);
            return true;
        }
        return false;
    }

    public List<String> getImports() {
        ArrayList result = Lists.newArrayList(this.imports.values());
        Collections.sort(result);
        return result;
    }
}

