/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.builderState.PersistedStateProvider;
import org.eclipse.xtext.builder.impl.BuildScheduler;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.internal.Activator;
import org.eclipse.xtext.resource.IResourceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFBasedPersister
implements PersistedStateProvider {
    private static final Logger log = Logger.getLogger(EMFBasedPersister.class);
    @Inject
    private IWorkspace workspace;
    @Inject
    private IBuilderState builderState;
    @Inject
    private BuildScheduler buildManager;
    private Resource.Factory factory;
    private IPath cachedPath;

    /*
     * Unable to fully structure code
     */
    @Override
    public Iterable<IResourceDescription> load() {
        block21: {
            block20: {
                location = this.getBuilderStateLocation();
                if (location == null || !location.exists()) ** GOTO lbl33
                resource = this.createResource();
                if (resource == null) break block20;
                resource.load(null);
                EcoreUtil.resolveAll((Resource)resource);
                var4_4 = this.loadFromResource(resource);
                location.delete();
                try {
                    if (this.workspace != null) {
                        this.workspace.addSaveParticipant((Plugin)Activator.getDefault(), new ISaveParticipant(){

                            public void saving(ISaveContext context) throws CoreException {
                                if (context.getKind() == 1) {
                                    EMFBasedPersister.this.save(EMFBasedPersister.this.builderState.getAllResourceDescriptions());
                                }
                            }

                            public void rollback(ISaveContext context) {
                            }

                            public void prepareToSave(ISaveContext context) throws CoreException {
                            }

                            public void doneSaving(ISaveContext context) {
                            }
                        });
                    }
                }
                catch (CoreException e) {
                    EMFBasedPersister.log.error((Object)"Error adding builder state save participant", (Throwable)e);
                }
                return var4_4;
            }
            try {
                try {
                    if (this.workspace != null && this.workspace.isAutoBuilding()) {
                        this.scheduleRecoveryBuild();
                    }
                    break block21;
                    {
                        catch (Throwable var3_8) {
                            throw var3_8;
                        }
                    }
                    finally {
                        location.delete();
                    }
lbl33:
                    // 1 sources

                    if (this.workspace != null && this.workspace.isAutoBuilding()) {
                        this.scheduleRecoveryBuild();
                    }
                }
                catch (Exception e) {
                    EMFBasedPersister.log.error((Object)"Error while loading persistable builder state. Triggering a full build.", (Throwable)e);
                    this.scheduleRecoveryBuild();
                    throw new WrappedException(e);
                }
            }
            catch (Throwable var5_9) {
                try {
                    if (this.workspace != null) {
                        this.workspace.addSaveParticipant((Plugin)Activator.getDefault(), new /* invalid duplicate definition of identical inner class */);
                    }
                }
                catch (CoreException e) {
                    EMFBasedPersister.log.error((Object)"Error adding builder state save participant", (Throwable)e);
                }
                throw var5_9;
            }
        }
        try {
            if (this.workspace != null) {
                this.workspace.addSaveParticipant((Plugin)Activator.getDefault(), new /* invalid duplicate definition of identical inner class */);
            }
        }
        catch (CoreException e) {
            EMFBasedPersister.log.error((Object)"Error adding builder state save participant", (Throwable)e);
        }
        return Collections.emptySet();
    }

    public Iterable<IResourceDescription> loadFromResource(Resource resource) {
        ArrayList result = Lists.newArrayList((Iterable)Iterables.filter((Iterable)resource.getContents(), IResourceDescription.class));
        resource.getContents().clear();
        return result;
    }

    public void save(Iterable<IResourceDescription> descriptions) {
        Resource res = this.createResource();
        if (res != null) {
            this.saveToResource(res, descriptions);
            try {
                res.save(null);
            }
            catch (IOException e) {
                throw new WrappedException((Exception)e);
            }
        }
    }

    public Resource createResource() {
        URI fileURI = this.getBuilderStateURI();
        if (fileURI == null) {
            return null;
        }
        Resource res = this.getFactory().createResource(fileURI);
        return res;
    }

    public void saveToResource(Resource res, Iterable<IResourceDescription> descriptions) {
        Iterables.addAll((Collection)res.getContents(), (Iterable)Iterables.filter(descriptions, EObject.class));
    }

    public URI getBuilderStateURI() {
        File location = this.getBuilderStateLocation();
        if (location == null) {
            return null;
        }
        URI fileURI = URI.createFileURI((String)location.getAbsolutePath());
        return fileURI;
    }

    protected File getBuilderStateLocation() {
        IPath path;
        Activator activator = Activator.getDefault();
        if (activator == null) {
            if (this.cachedPath != null) {
                return this.cachedPath.toFile();
            }
            return null;
        }
        this.cachedPath = path = activator.getStateLocation().append("builder.state");
        return path.toFile();
    }

    public void setFactory(Resource.Factory factory) {
        this.factory = factory;
    }

    public Resource.Factory getFactory() {
        if (this.factory == null) {
            this.factory = new XMIResourceFactoryImpl();
        }
        return this.factory;
    }

    protected void scheduleRecoveryBuild() {
        ArrayList projects = Lists.newArrayList((Object[])this.workspace.getRoot().getProjects());
        this.buildManager.scheduleBuildIfNecessary(projects, IBuildFlag.RECOVERY_BUILD);
    }
}

