/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit.validation;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationTestHelper {
    public List<Issue> validate(EObject model) {
        IResourceValidator validator = ((XtextResource)model.eResource()).getResourceServiceProvider().getResourceValidator();
        return validator.validate(model.eResource(), CheckMode.ALL, CancelIndicator.NullImpl);
    }

    public void assertNoIssues(EObject model) {
        List<Issue> validate = this.validate(model);
        if (!Iterables.isEmpty(validate)) {
            Assert.fail((String)("Expected no issues, but got :" + validate));
        }
    }

    public void assertNoErrors(EObject model) {
        List<Issue> validate = this.validate(model);
        Iterable issues = Iterables.filter(validate, (Predicate)new Predicate<Issue>(){

            public boolean apply(Issue input) {
                return Severity.ERROR == input.getSeverity();
            }
        });
        if (!Iterables.isEmpty((Iterable)issues)) {
            Assert.fail((String)("Expected no errors, but got :" + issues));
        }
    }

    public void assertNoError(EObject model, final String issuecode) {
        List<Issue> validate = this.validate(model);
        Iterable issues = Iterables.filter(validate, (Predicate)new Predicate<Issue>(){

            public boolean apply(Issue input) {
                return issuecode.equals(input.getCode());
            }
        });
        if (!Iterables.isEmpty((Iterable)issues)) {
            Assert.fail((String)("Expected no error '" + issuecode + "' but got " + issues));
        }
    }

    public void assertError(EObject model, EClass objectType, String code, String ... messageParts) {
        this.assertIssue(model, objectType, code, Severity.ERROR, messageParts);
    }

    public void assertIssue(final EObject model, final EClass objectType, final String code, final Severity severity, final String ... messageParts) {
        List<Issue> validate = this.validate(model);
        Iterable matchingErrors = Iterables.filter(validate, (Predicate)new Predicate<Issue>(){

            public boolean apply(Issue input) {
                EObject object;
                if (Strings.equal((String)input.getCode(), (String)code) && input.getSeverity() == severity && objectType.isInstance((Object)(object = model.eResource().getResourceSet().getEObject(input.getUriToProblem(), true)))) {
                    String[] stringArray = messageParts;
                    int n = messageParts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String messagePart = stringArray[n2];
                        if (!input.getMessage().toLowerCase().contains(messagePart.toLowerCase())) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
                return false;
            }
        });
        if (Iterables.isEmpty((Iterable)matchingErrors)) {
            Assert.fail((String)("Expected " + severity + " '" + code + "' but got " + validate));
        }
    }

    public void assertWarning(EObject model, EClass objectType, String code, String ... messageParts) {
        this.assertIssue(model, objectType, code, Severity.WARNING, messageParts);
    }
}

