/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.IMirrorExtension;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.util.AbstractTypeReferenceVisitor;
import org.eclipse.xtext.common.types.util.ITypeReferenceVisitor;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.resource.AnnotationSignatureRelevanceUtil;

@Singleton
public class JvmDeclaredTypeSignatureHashProvider {
    private static final Logger LOG = Logger.getLogger(JvmDeclaredTypeSignatureHashProvider.class);
    @Inject
    private IResourceScopeCache cache;
    @Inject
    private Provider<SignatureHashBuilder> signatureBuilderProvider;
    private static final String HASH_CACHE_KEY = "SignatureHash";

    public String getHash(final JvmDeclaredType type) {
        IMirror mirror;
        if (type.eResource() instanceof TypeResource && (mirror = ((TypeResource)type.eResource()).getMirror()) instanceof IMirrorExtension && ((IMirrorExtension)mirror).isSealed()) {
            return type.getIdentifier();
        }
        return (String)this.cache.get((Object)Tuples.create((Object)HASH_CACHE_KEY, (Object)type), type.eResource(), (Provider)new Provider<String>(){

            public String get() {
                return ((SignatureHashBuilder)JvmDeclaredTypeSignatureHashProvider.this.signatureBuilderProvider.get()).appendSignature(type).hash();
            }
        });
    }

    public static class SignatureHashBuilder {
        @Inject
        private SuperTypeCollector superTypeCollector;
        @Inject
        private JvmDeclaredTypeSignatureHashProvider hashProvider;
        @Inject
        private AnnotationSignatureRelevanceUtil annotationRelevance;
        private MessageDigest digest = this.createDigest();
        private StringBuilder builder;

        public SignatureHashBuilder() {
            if (this.digest == null) {
                this.builder = new StringBuilder();
            }
        }

        protected MessageDigest createDigest() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error((Object)"Error creating message digest", (Throwable)e);
                return null;
            }
        }

        protected SignatureHashBuilder append(String s) {
            if (this.digest != null) {
                try {
                    this.digest.update(s.getBytes("UTF8"));
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error((Object)"Error encoding String", (Throwable)e);
                }
            }
            if (this.builder != null) {
                this.builder.append(s);
            }
            return this;
        }

        public SignatureHashBuilder appendSignature(JvmDeclaredType type) {
            if (type.getVisibility() != JvmVisibility.PRIVATE) {
                this.appendAnnotationReferences((JvmAnnotationTarget)type);
                this.appendVisibility(type.getVisibility()).append(" ");
                if (type.isAbstract()) {
                    this.append("abstract ");
                }
                if (type.isStatic()) {
                    this.append("static ");
                }
                if (type.isFinal()) {
                    this.append("final ");
                }
                this.append("class ").append(type.getIdentifier());
                if (type instanceof JvmTypeParameterDeclarator) {
                    this.appendTypeParameters((JvmTypeParameterDeclarator)type);
                }
                this.append("\n").appendSuperTypeSignatures(type).appendMemberSignatures(type, false);
            }
            return this;
        }

        protected SignatureHashBuilder appendMemberSignatures(JvmDeclaredType type, boolean innerTypesOnly) {
            Object members = type.getMembers();
            if (innerTypesOnly) {
                members = Iterables.filter((Iterable)members, JvmDeclaredType.class);
            }
            for (JvmMember member : members) {
                if (member.getVisibility() == JvmVisibility.PRIVATE) continue;
                this.appendAnnotationReferences((JvmAnnotationTarget)member);
                if (member instanceof JvmOperation) {
                    this.appendSignature((JvmOperation)member);
                } else if (member instanceof JvmConstructor) {
                    this.appendSignature((JvmConstructor)member);
                } else if (member instanceof JvmField) {
                    this.appendSignature((JvmField)member);
                } else if (member instanceof JvmDeclaredType) {
                    this.append(member.getQualifiedName());
                    this.appendMemberSignatures((JvmDeclaredType)member, true);
                }
                this.append("\n");
            }
            return this;
        }

        protected void appendAnnotationReferences(JvmAnnotationTarget target) {
            for (JvmAnnotationReference annotationReference : target.getAnnotations()) {
                if (!this.annotationRelevance.isRelevant(annotationReference)) continue;
                this.append(this.hashProvider.getHash((JvmDeclaredType)annotationReference.getAnnotation())).append(" ");
            }
        }

        protected SignatureHashBuilder appendSuperTypeSignatures(JvmDeclaredType type) {
            for (JvmTypeReference superType : this.superTypeCollector.collectSuperTypes((JvmType)type)) {
                this.append("super ");
                superType.accept((ITypeReferenceVisitor)new AbstractTypeReferenceVisitor.InheritanceAware<Void>(){

                    public Void doVisitTypeReference(JvmTypeReference reference) {
                        if (reference.getType() instanceof JvmDeclaredType) {
                            SignatureHashBuilder.this.append(SignatureHashBuilder.this.hashProvider.getHash((JvmDeclaredType)reference.getType()));
                        } else {
                            SignatureHashBuilder.this.append(reference.getIdentifier());
                        }
                        return null;
                    }

                    public Void doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference) {
                        this.doVisitTypeReference((JvmTypeReference)reference);
                        SignatureHashBuilder.this.append("<");
                        for (JvmTypeReference typeArgument : reference.getArguments()) {
                            SignatureHashBuilder.this.append(typeArgument.getIdentifier());
                            SignatureHashBuilder.this.append(",");
                        }
                        SignatureHashBuilder.this.append(">");
                        return null;
                    }
                });
                this.append("\n");
            }
            return this;
        }

        protected SignatureHashBuilder appendSignature(JvmOperation operation) {
            this.appendVisibility(operation.getVisibility()).append(" ");
            if (operation.isAbstract()) {
                this.append("abstract ");
            }
            if (operation.isStatic()) {
                this.append("static ");
            }
            if (operation.isFinal()) {
                this.append("final ");
            }
            this.appendType(operation.getReturnType()).appendTypeParameters((JvmTypeParameterDeclarator)operation).append(" ").append(operation.getSimpleName()).append("(");
            for (JvmFormalParameter p : operation.getParameters()) {
                this.appendType(p.getParameterType());
                this.append(" ");
            }
            this.append(") ");
            for (JvmTypeReference ex : operation.getExceptions()) {
                this.appendType(ex).append(" ");
            }
            return this;
        }

        protected SignatureHashBuilder appendSignature(JvmField field) {
            this.appendVisibility(field.getVisibility()).append(" ");
            if (field.isStatic()) {
                this.append("static ");
            }
            if (field.isFinal()) {
                this.append("final ");
            }
            return this.appendType(field.getType()).append(" ").append(field.getSimpleName());
        }

        protected SignatureHashBuilder appendSignature(JvmConstructor operation) {
            this.appendVisibility(operation.getVisibility()).appendTypeParameters((JvmTypeParameterDeclarator)operation).append("(");
            for (JvmFormalParameter p : operation.getParameters()) {
                this.appendType(p.getParameterType()).append(" ");
            }
            this.append(") ");
            for (JvmTypeReference ex : operation.getExceptions()) {
                this.appendType(ex).append(" ");
            }
            return this;
        }

        protected SignatureHashBuilder appendTypeParameters(JvmTypeParameterDeclarator decl) {
            this.append("<");
            for (JvmTypeParameter tp : decl.getTypeParameters()) {
                this.appendTypeParameter(tp).append(",");
            }
            this.append(">");
            return this;
        }

        protected SignatureHashBuilder appendType(JvmTypeReference ref) {
            if (ref != null && ref.getIdentifier() != null) {
                this.append(ref.getIdentifier());
            } else {
                this.append("*unresolved*");
            }
            return this;
        }

        protected SignatureHashBuilder appendVisibility(JvmVisibility v) {
            this.append(v.getLiteral());
            return this;
        }

        protected SignatureHashBuilder appendTypeParameter(JvmTypeParameter p) {
            if (p != null && p.getIdentifier() != null) {
                this.append(p.getIdentifier());
            } else {
                this.append("*unresolved*");
            }
            return this;
        }

        public String hash() {
            try {
                if (this.digest != null) {
                    byte[] digestBytes = this.digest.digest();
                    return new BigInteger(digestBytes).toString(16);
                }
                return this.builder.toString();
            }
            catch (Exception e) {
                LOG.error((Object)"Error hashing JvmDeclaredType signature", (Throwable)e);
                return "";
            }
        }
    }
}

