/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl.javasupport;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.builder.impl.ToBeBuiltComputer;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.common.types.ui.notification.TypeResourceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ChangedResourceDescriptionDelta;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.resource.JarEntryLocator;
import org.eclipse.xtext.ui.resource.PackageFragmentRootWalker;
import org.eclipse.xtext.ui.util.IJdtHelper;
import org.eclipse.xtext.util.Pair;

public class JdtToBeBuiltComputer
extends ToBeBuiltComputer {
    private static final Logger log = Logger.getLogger(JdtToBeBuiltComputer.class);
    @Inject
    private TypeURIHelper typeURIHelper;
    @Inject
    private QueuedBuildData queuedBuildData;
    @Inject
    private ModificationStampCache modificationStampCache;
    @Inject
    private IJdtHelper jdtHelper;

    public ToBeBuilt removeProject(IProject project, IProgressMonitor monitor) {
        ToBeBuilt toBeBuilt = super.removeProject(project, monitor);
        if (toBeBuilt.getToBeDeleted().isEmpty() && toBeBuilt.getToBeUpdated().isEmpty()) {
            return toBeBuilt;
        }
        this.modificationStampCache.projectToModificationStamp.clear();
        return toBeBuilt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToBeBuilt updateProject(final IProject project, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        final ToBeBuilt toBeBuilt = super.updateProject(project, (IProgressMonitor)progress.newChild(1));
        if (!project.isAccessible() || progress.isCanceled()) {
            return toBeBuilt;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject.exists()) {
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            progress.setWorkRemaining(roots.length);
            final HashSet previouslyBuilt = Sets.newHashSet();
            final HashSet subsequentlyBuilt = Sets.newHashSet();
            final JarEntryLocator locator = new JarEntryLocator();
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    final IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (progress.isCanceled()) {
                        return toBeBuilt;
                    }
                    if (this.shouldHandle(root)) {
                        try {
                            final HashMap updated = Maps.newHashMap();
                            new PackageFragmentRootWalker<Boolean>(){

                                protected Boolean handle(IJarEntryResource jarEntry, PackageFragmentRootWalker.TraversalState state) {
                                    URI uri = locator.getURI(root, jarEntry, state);
                                    if (JdtToBeBuiltComputer.this.isValid(uri, (IStorage)jarEntry)) {
                                        if (this.wasFragmentRootAlreadyProcessed(uri)) {
                                            return Boolean.TRUE;
                                        }
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)("Scheduling: " + project.getName() + " - " + uri));
                                        }
                                        toBeBuilt.getToBeDeleted().add(uri);
                                        toBeBuilt.getToBeUpdated().add(uri);
                                    }
                                    return null;
                                }

                                protected boolean wasFragmentRootAlreadyProcessed(URI uri) {
                                    Iterable storages = JdtToBeBuiltComputer.this.getMapper().getStorages(uri);
                                    for (Pair pair : storages) {
                                        IProject otherProject = (IProject)pair.getSecond();
                                        if (((IProject)pair.getSecond()).equals((Object)project)) continue;
                                        if (previouslyBuilt.contains(otherProject.getName())) {
                                            return true;
                                        }
                                        if (subsequentlyBuilt.contains(otherProject.getName())) continue;
                                        boolean process = XtextProjectHelper.hasNature((IProject)otherProject);
                                        String otherName = otherProject.getName();
                                        if (!process) {
                                            Long previousStamp;
                                            boolean bl = process = otherProject.isAccessible() && otherProject.isHidden();
                                            if (process && ((previousStamp = ((JdtToBeBuiltComputer)JdtToBeBuiltComputer.this).modificationStampCache.projectToModificationStamp.get(otherName)) == null || otherProject.getModificationStamp() > previousStamp)) {
                                                process = false;
                                                updated.put(otherName, otherProject.getModificationStamp());
                                            }
                                        }
                                        if (!process) continue;
                                        IWorkspace.ProjectOrder projectOrder = project.getWorkspace().computeProjectOrder(new IProject[]{project, otherProject});
                                        if (!projectOrder.hasCycles) {
                                            if (otherProject.equals((Object)projectOrder.projects[0])) {
                                                previouslyBuilt.add(otherName);
                                                return true;
                                            }
                                            subsequentlyBuilt.add(otherName);
                                            continue;
                                        }
                                        subsequentlyBuilt.add(otherName);
                                    }
                                    return false;
                                }
                            }.traverse(root, true);
                            ModificationStampCache modificationStampCache = this.modificationStampCache;
                            synchronized (modificationStampCache) {
                                this.modificationStampCache.projectToModificationStamp.putAll(updated);
                            }
                        }
                        catch (JavaModelException ex) {
                            if (ex.isDoesNotExist()) break block10;
                            log.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
                progress.worked(1);
                ++n2;
            }
        }
        return toBeBuilt;
    }

    private boolean shouldHandle(IPackageFragmentRoot root) {
        try {
            boolean result = !JavaRuntime.newDefaultJREContainerPath().isPrefixOf(root.getRawClasspathEntry().getPath());
            return result &= root.isArchive() || root.isExternal();
        }
        catch (JavaModelException ex) {
            if (!ex.isDoesNotExist()) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            return false;
        }
    }

    public boolean removeStorage(IProgressMonitor monitor, ToBeBuilt toBeBuilt, IStorage storage) {
        if (!this.isHandled(storage)) {
            return true;
        }
        URI uri = this.getUri(storage);
        if (uri != null) {
            toBeBuilt.getToBeDeleted().add(uri);
        } else if (storage instanceof IFile && JavaCore.isJavaLikeFileName((String)storage.getFullPath().lastSegment())) {
            IJavaElement element = JavaCore.create((IResource)((IFile)storage).getParent());
            String fileName = storage.getFullPath().lastSegment();
            String typeName = fileName.substring(0, fileName.lastIndexOf(46));
            if (element instanceof IPackageFragmentRoot) {
                this.queueJavaChange(typeName);
            } else if (element instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)element;
                this.queueJavaChange(String.valueOf(packageFragment.getElementName()) + "." + typeName);
            }
        }
        return true;
    }

    protected void queueJavaChange(String typeName) {
        URI typeURI = this.typeURIHelper.createResourceURIForFQN(typeName);
        TypeResourceDescription oldDescription = new TypeResourceDescription(typeURI, Collections.emptyList());
        ChangedResourceDescriptionDelta delta = new ChangedResourceDescriptionDelta((IResourceDescription)oldDescription, null);
        this.queuedBuildData.queueChanges(Collections.singleton(delta));
    }

    protected boolean isHandled(IStorage resource) {
        return resource instanceof IJarEntryResource || super.isHandled(resource);
    }

    protected boolean isHandled(IFolder folder) {
        boolean result = super.isHandled(folder) && !this.jdtHelper.isFromOutputPath((IResource)folder);
        return result;
    }

    @Singleton
    public static class ModificationStampCache {
        protected Map<String, Long> projectToModificationStamp = Maps.newHashMap();
    }
}

