/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.ui.refactoring.IRenameRefactoringProvider;
import org.eclipse.xtext.ui.refactoring.impl.AbstractProcessorBasedRenameParticipant;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.JvmElementFinder;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.RenameJvmReferenceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTRenamePartcipant
extends AbstractProcessorBasedRenameParticipant {
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private JvmElementFinder jvmElementFinder;
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private IRenameRefactoringProvider ownRenamRefactoringProvider;
    private IJavaElement javaElement;
    private ResourceSet resourceSet;
    private Set<EObject> sourceElements;

    protected List<? extends IRenameElementContext> createRenameElementContexts(Object element) {
        if (element instanceof IJavaElement) {
            this.javaElement = (IJavaElement)element;
            EClass expectedJvmType = this.getExpectedJvmType(this.javaElement);
            if (expectedJvmType != null) {
                IJavaProject javaProject = this.javaElement.getJavaProject();
                IProject project = javaProject.getProject();
                this.resourceSet = this.resourceSetProvider.get(project);
                EObject correspondingJvmElement = this.jvmElementFinder.getCorrespondingJvmElement(this.javaElement, this.resourceSet);
                JvmIdentifiableElement jvmElementDeclaration = this.jvmElementFinder.findJvmElementDeclarationInIndex(correspondingJvmElement, project);
                if (jvmElementDeclaration != null) {
                    this.sourceElements = this.associations.getSourceElements((EObject)jvmElementDeclaration);
                    if (!Iterables.isEmpty(this.sourceElements)) {
                        ArrayList contexts = Lists.newArrayList();
                        for (EObject sourceElement : this.sourceElements) {
                            contexts.add(this.createRenameDeclarationContext(sourceElement));
                        }
                        return contexts;
                    }
                } else if (correspondingJvmElement instanceof JvmMember) {
                    return Collections.singletonList(this.createRenameReferenceContext((JvmMember)correspondingJvmElement));
                }
            }
        }
        return null;
    }

    protected RenameJvmReferenceContext createRenameReferenceContext(JvmMember jvmMember) {
        return new RenameJvmReferenceContext(jvmMember, this.javaElement, null, null, null);
    }

    protected IRenameElementContext createRenameDeclarationContext(EObject jvmElement) {
        return new IRenameElementContext.Impl(EcoreUtil2.getNormalizedURI((EObject)jvmElement), jvmElement.eClass(), null, null, null);
    }

    protected IRenameRefactoringProvider getRenameRefactoringProvider(IRenameElementContext renameElementContext) {
        return this.ownRenamRefactoringProvider;
    }

    protected List<EObject> getRenamedElementsOrProxies(EObject originalTarget) {
        return null;
    }

    protected EClass getExpectedJvmType(IJavaElement javaElement) {
        try {
            switch (javaElement.getElementType()) {
                case 7: {
                    return TypesPackage.Literals.JVM_TYPE;
                }
                case 9: {
                    IMethod method = (IMethod)javaElement;
                    if (method.isConstructor()) {
                        return TypesPackage.Literals.JVM_CONSTRUCTOR;
                    }
                    return TypesPackage.Literals.JVM_OPERATION;
                }
                case 8: {
                    return TypesPackage.Literals.JVM_FIELD;
                }
            }
            return null;
        }
        catch (JavaModelException exc) {
            throw new WrappedException((Exception)((Object)exc));
        }
    }
}

