/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.project;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class WizardContribution
implements Comparable<WizardContribution> {
    private String name;
    private String mweSnippet;
    private String[] requiredBundles;
    private String sortKey;

    public static Map<String, WizardContribution> getFromRegistry() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.xtext.xtext.ui.wizardContribution");
        HashMap<String, WizardContribution> elements = new HashMap<String, WizardContribution>();
        int i = 0;
        while (i < config.length) {
            IConfigurationElement e = config[i];
            String name = e.getAttribute("name");
            String mweSnippet = e.getChildren("MweSnippet")[0].getValue();
            String requiredBundlesAsString = e.getAttribute("requiredBundles");
            String sortKey = e.getAttribute("sortKey");
            String[] requiredBundles = new String[]{};
            if (requiredBundlesAsString != null) {
                requiredBundles = requiredBundlesAsString.split(",");
            }
            elements.put(name, new WizardContribution(name, mweSnippet, requiredBundles, sortKey));
            ++i;
        }
        return elements;
    }

    public WizardContribution(String name, String mweSnippet, String[] requiredBundles, String sortKey) {
        this.name = name;
        this.mweSnippet = mweSnippet;
        this.requiredBundles = requiredBundles;
        this.sortKey = sortKey;
    }

    public String getName() {
        return this.name;
    }

    public String getMweSnippet() {
        return this.mweSnippet;
    }

    public String[] getRequiredBundles() {
        return this.requiredBundles;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    @Override
    public int compareTo(WizardContribution o) {
        if (this.getSortKey() == null) {
            return -1000;
        }
        if (o.getSortKey() == null) {
            return 1000;
        }
        return this.getSortKey().compareTo(o.getSortKey());
    }
}

