/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.debug;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.util.ITextRegion;

public class TextRegionListToString {
    private List<Item> items = Lists.newArrayList();

    public void add(ITextRegion region, String text) {
        this.add(region, text, true);
    }

    protected void add(ITextRegion region, String text, boolean indented) {
        this.items.add(new Item(region, text, indented));
    }

    public void add(String text) {
        this.add(null, text, true);
    }

    public void add(String text, boolean indented) {
        this.add(null, text, indented);
    }

    public String toString() {
        int offsetDigits = 0;
        int lengthDigits = 0;
        for (Item item : this.items) {
            int lengthO;
            if (item.region == null) continue;
            int lengthD = String.valueOf(item.region.getLength()).length();
            if (lengthDigits < lengthD) {
                lengthDigits = lengthD;
            }
            if (offsetDigits >= (lengthO = String.valueOf(item.region.getOffset()).length())) continue;
            offsetDigits = lengthO;
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)this.items.size());
        String prefix = Strings.repeat((String)" ", (int)(offsetDigits + lengthDigits + 2));
        for (Item item : this.items) {
            if (item.region != null) {
                String offset = Strings.padStart((String)String.valueOf(item.region.getOffset()), (int)offsetDigits, (char)' ');
                String length = Strings.padStart((String)String.valueOf(item.region.getLength()), (int)lengthDigits, (char)' ');
                result.add(String.valueOf(offset) + " " + length + " " + item.text);
                continue;
            }
            if (item.indented) {
                result.add(String.valueOf(prefix) + item.text);
                continue;
            }
            result.add(item.text);
        }
        return Joiner.on((String)"\n").join((Iterable)result);
    }

    protected static class Item {
        private boolean indented;
        private ITextRegion region;
        private String text;

        public Item(ITextRegion region, String text, boolean indented) {
            this.region = region;
            this.text = text;
            this.indented = indented;
        }
    }
}

