/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hyperlinking;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkLabelProvider;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class HyperlinkHelper
implements IHyperlinkHelper {
    @Inject
    @HyperlinkLabelProvider
    private ILabelProvider labelProvider;
    @Inject
    private Provider<XtextHyperlink> hyperlinkProvider;
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;

    protected Provider<XtextHyperlink> getHyperlinkProvider() {
        return this.hyperlinkProvider;
    }

    protected ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    protected EObjectAtOffsetHelper getEObjectAtOffsetHelper() {
        return this.eObjectAtOffsetHelper;
    }

    @Override
    public IHyperlink[] createHyperlinksByOffset(XtextResource resource, int offset, boolean createMultipleHyperlinks) {
        ArrayList links = Lists.newArrayList();
        HyperlinkAcceptor acceptor = new HyperlinkAcceptor(links);
        this.createHyperlinksByOffset(resource, offset, acceptor);
        if (!links.isEmpty()) {
            return (IHyperlink[])Iterables.toArray((Iterable)links, IHyperlink.class);
        }
        return null;
    }

    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        INode crossRefNode = this.eObjectAtOffsetHelper.getCrossReferenceNode(resource, (ITextRegion)new TextRegion(offset, 0));
        if (crossRefNode == null) {
            return;
        }
        EObject crossLinkedEObject = this.eObjectAtOffsetHelper.getCrossReferencedElement(crossRefNode);
        if (crossLinkedEObject != null && !crossLinkedEObject.eIsProxy()) {
            this.createHyperlinksTo(resource, crossRefNode, crossLinkedEObject, acceptor);
        }
    }

    protected void createHyperlinksTo(XtextResource resource, INode node, EObject target, IHyperlinkAcceptor acceptor) {
        ITextRegion textRegion = node.getTextRegion();
        Region region = new Region(textRegion.getOffset(), textRegion.getLength());
        this.createHyperlinksTo(resource, region, target, acceptor);
    }

    @Deprecated
    protected INode getParentNodeWithCrossReference(INode startNode) {
        if (startNode == null) {
            return null;
        }
        if (startNode.getGrammarElement() instanceof CrossReference) {
            return startNode;
        }
        return this.getParentNodeWithCrossReference((INode)startNode.getParent());
    }

    public void createHyperlinksTo(XtextResource from, Region region, EObject target, IHyperlinkAcceptor acceptor) {
        URIConverter uriConverter = from.getResourceSet().getURIConverter();
        String hyperlinkText = this.labelProvider.getText((Object)target);
        URI uri = EcoreUtil.getURI((EObject)target);
        URI normalized = uri.isPlatformResource() ? uri : uriConverter.normalize(uri);
        XtextHyperlink result = (XtextHyperlink)this.hyperlinkProvider.get();
        result.setHyperlinkRegion(region);
        result.setURI(normalized);
        result.setHyperlinkText(hyperlinkText);
        acceptor.accept(result);
    }

    protected static class HyperlinkAcceptor
    implements IHyperlinkAcceptor {
        private final List<IHyperlink> links;

        public HyperlinkAcceptor(List<IHyperlink> links) {
            this.links = links;
        }

        @Override
        public void accept(IHyperlink hyperlink) {
            if (hyperlink != null) {
                this.links.add(hyperlink);
            }
        }
    }
}

