/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.wizard.template;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.CodeGenerationContext;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.file.Path;

public abstract class TemplateProcessor
extends AbstractClassProcessor {
    private static final Object LOCK = TemplateProcessor.class;
    private Map<Path, String> propertyContentMap;
    private String actualPropertyContents;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGenerateCode(List<? extends ClassDeclaration> annotatedSourceElements, CodeGenerationContext context) {
        Object object = LOCK;
        synchronized (object) {
            this.buildFileMaps(annotatedSourceElements, context);
            for (ClassDeclaration classDeclaration : annotatedSourceElements) {
                this.actualPropertyContents = this.propertyContentMap.get(this.getMessagesProperties(classDeclaration));
                this.doGenerateCode(classDeclaration, context);
            }
            this.saveFileMaps(annotatedSourceElements, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGenerateCode(ClassDeclaration annotatedClass, CodeGenerationContext context) {
        Object object = LOCK;
        synchronized (object) {
            String propertyContents = this.generatePropertiesFile(annotatedClass, context);
            this.generateMessagesClass(propertyContents, annotatedClass, context);
        }
    }

    private String generatePropertiesFile(ClassDeclaration annotatedClass, CodeGenerationContext context) {
        String label = this.replaceNewlines(this.getLabel(annotatedClass, context));
        String description = this.replaceNewlines(this.getDescription(annotatedClass, context));
        String labelLineStart = String.valueOf(annotatedClass.getSimpleName()) + "_Label=";
        String labelLine = String.valueOf(labelLineStart) + label;
        this.actualPropertyContents = this.actualPropertyContents.contains(labelLineStart) ? this.actualPropertyContents.replaceFirst("(?m)^" + labelLineStart + ".*$", labelLine) : String.valueOf(this.actualPropertyContents) + labelLine + System.lineSeparator();
        String descriptionLineStart = String.valueOf(annotatedClass.getSimpleName()) + "_Description=";
        String descriptionLine = String.valueOf(descriptionLineStart) + description;
        this.actualPropertyContents = this.actualPropertyContents.contains(descriptionLineStart) ? this.actualPropertyContents.replaceFirst("(?m)^" + descriptionLineStart + ".*$", descriptionLine) : String.valueOf(this.actualPropertyContents) + descriptionLine + System.lineSeparator();
        this.propertyContentMap.put(this.getMessagesProperties(annotatedClass), this.actualPropertyContents);
        return this.actualPropertyContents;
    }

    private void generateMessagesClass(String propertyContents, ClassDeclaration annotatedClass, CodeGenerationContext context) {
        Path classFile = annotatedClass.getCompilationUnit().getFilePath().getParent().append("Messages.java");
        String contents = "";
        if (context.exists(classFile)) {
            String oldContents = context.getContents(classFile).toString();
            if (oldContents.trim().startsWith("/*") && oldContents.contains("*/") && oldContents.length() > oldContents.indexOf("*/") + 2) {
                contents = String.valueOf(contents) + oldContents.substring(0, oldContents.indexOf("*/") + 2) + System.lineSeparator();
            }
        } else {
            contents = String.valueOf(contents) + annotatedClass.getCompilationUnit().getDocComment() + System.lineSeparator();
        }
        contents = String.valueOf(contents) + "package " + annotatedClass.getCompilationUnit().getPackageName() + ";" + System.lineSeparator();
        contents = String.valueOf(contents) + System.lineSeparator() + "import org.eclipse.osgi.util.NLS;" + System.lineSeparator() + System.lineSeparator() + "public class Messages extends NLS {" + System.lineSeparator() + "\tprivate static final String BUNDLE_NAME = \"" + annotatedClass.getCompilationUnit().getPackageName() + ".messages\"; //$NON-NLS-1$" + System.lineSeparator() + "\t" + System.lineSeparator();
        String[] stringArray = propertyContents.split("(\r?\n)+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.contains("=")) {
                String[] parts = line.split("=");
                contents = String.valueOf(contents) + "\tpublic static String " + parts[0].trim() + ";" + System.lineSeparator();
            }
            ++n2;
        }
        contents = String.valueOf(contents) + "\t" + System.lineSeparator() + "\tstatic {" + System.lineSeparator() + "\t// initialize resource bundle" + System.lineSeparator() + "\tNLS.initializeMessages(BUNDLE_NAME, Messages.class);" + System.lineSeparator() + "\t}" + System.lineSeparator() + "\t" + System.lineSeparator() + "\tprivate Messages() {" + System.lineSeparator() + "\t}" + System.lineSeparator() + "}" + System.lineSeparator();
        context.setContents(classFile, (CharSequence)contents);
    }

    private String replaceNewlines(String input) {
        return input.replaceAll("(\r?\n)+", " ");
    }

    protected void buildFileMaps(List<? extends ClassDeclaration> annotatedSourceElements, CodeGenerationContext context) {
        this.propertyContentMap = new HashMap<Path, String>();
        for (ClassDeclaration classDeclaration : annotatedSourceElements) {
            Path propertyFile = this.getMessagesProperties(classDeclaration);
            if (this.propertyContentMap.containsKey(propertyFile)) continue;
            if (context.exists(propertyFile)) {
                String propertyContents = context.getContents(propertyFile).toString();
                if (propertyContents.length() > 0) {
                    boolean endsWithWindowsLineSeparator = propertyContents.endsWith("\r\n");
                    boolean endsWithUnixLineSeparator = propertyContents.endsWith("\n");
                    if (!endsWithWindowsLineSeparator && !endsWithUnixLineSeparator) {
                        propertyContents = String.valueOf(propertyContents) + System.lineSeparator();
                    }
                }
                this.propertyContentMap.put(propertyFile, propertyContents);
                continue;
            }
            this.propertyContentMap.put(propertyFile, "");
        }
    }

    protected void saveFileMaps(List<? extends ClassDeclaration> annotatedSourceElements, CodeGenerationContext context) {
        for (ClassDeclaration classDeclaration : annotatedSourceElements) {
            this.actualPropertyContents = this.propertyContentMap.get(this.getMessagesProperties(classDeclaration));
            context.setContents(this.getMessagesProperties(classDeclaration), (CharSequence)this.actualPropertyContents);
        }
    }

    private Path getMessagesProperties(ClassDeclaration annotatedClass) {
        return annotatedClass.getCompilationUnit().getFilePath().getParent().append("messages.properties");
    }

    protected abstract String getLabel(ClassDeclaration var1, CodeGenerationContext var2);

    protected abstract String getDescription(ClassDeclaration var1, CodeGenerationContext var2);
}

