/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.templates;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContext;

public class XtextTemplateProposal
extends TemplateProposal
implements ICompletionProposalExtension4 {
    public XtextTemplateProposal(Template template, TemplateContext context, IRegion region, Image image) {
        super(template, context, region, image);
    }

    public XtextTemplateProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
        super(template, context, region, image, relevance);
    }

    public boolean isAutoInsertable() {
        return this.getTemplate().isAutoInsertable();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof XtextTemplateProposal)) {
            return false;
        }
        XtextTemplateProposal other = (XtextTemplateProposal)((Object)obj);
        return this.getTemplate().equals((Object)other.getTemplate());
    }

    public int hashCode() {
        return this.getTemplate().hashCode();
    }

    public String getAdditionalProposalInfo() {
        TemplateBuffer templateBuffer;
        try {
            TemplateContext context = this.getContext();
            context.setReadOnly(true);
            try {
                Template template = this.getTemplate();
                templateBuffer = context instanceof XtextTemplateContext ? ((XtextTemplateContext)context).evaluateForDisplay(template) : context.evaluate(template);
            }
            catch (TemplateException templateException) {
                return null;
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return templateBuffer.getString();
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        if (document instanceof IDocumentExtension4) {
            IDocumentExtension4 docExt4 = (IDocumentExtension4)document;
            DocumentRewriteSession session = docExt4.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
            super.apply(viewer, trigger, stateMask, offset);
            if (session != null) {
                docExt4.stopRewriteSession(session);
            }
        } else {
            super.apply(viewer, trigger, stateMask, offset);
        }
    }
}

